/*****************************************************************************
 * toolbox.h: misc useful X11 functions for UI.  Athena Widgets.
 *****************************************************************************
 * $Id: toolbox.h,v 1.4 2004/06/14 20:51:37 pingus77 Exp $
 *****************************************************************************
 *  Copyright (C) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#ifndef _TOOLBOX_H_
#define _TOOLBOX_H_

/* --- Variables  -------------------------------------------------------- */

extern Cursor left_ptr;
extern Cursor menu_ptr;
extern Cursor qu_ptr;
extern Cursor no_ptr;

extern Pixmap bm_yes;
extern Pixmap bm_no;

/* --- Prototypes -------------------------------------------------------- */

void oops (char *msg);

Widget add_pulldown_menu (Widget, char *);
Widget add_menu_entry (Widget, char *, XtCallbackProc, XtPointer);
Widget add_menu_sep (Widget menu, char *name);

int popup_menu (Widget, char *, struct STRTAB *);
void popdown_CB (Widget widget, XtPointer client_data, XtPointer calldata);
void destroy_CB (Widget widget, XtPointer client_data, XtPointer calldata);
void center_under_mouse (Widget shell, int, int);
void autoscroll (Widget widget, XEvent *event, String *params, Cardinal *nparm);

char *get_string_resource (Widget widget, char *name);

void kbd_scroll_viewport_AC (Widget widget, XEvent * event,
                 String * params, Cardinal * num_params);
void report_viewport_CB (Widget, XtPointer, XtPointer);

void get_user_string (Widget, char *, char *, char *, XtCallbackProc,
              XtPointer);
void tell_user (Widget, char *, char *);
void xperror (Widget, char *);

void help_AC (Widget widget, XEvent * event,
          String * params, Cardinal * num_params);
void HidePopup (Widget widget, XEvent * event,
          String * params, Cardinal * num_params);	  
void set_shadowWidth_AC (Widget widget, XEvent * event,
             String * params, Cardinal * num_params);

void create_pointers (Widget);
void create_bitmaps (Widget);

#endif // _TOOLBOX_H_
