/*****************************************************************************
 * wmhooks.c: Some WindowManager specific stuff
 *****************************************************************************
 * $Id: wmhooks.c,v 1.18 2004/07/12 21:19:25 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * This software was based on xawtv. Those portions are
 * Copyright (C) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>

#include <string.h>
#include "grab.h"

/* ------------------------------------------------------------------------ */

void (*wm_stay_on_top)(Display *dpy, Window win, int state) = NULL;
void (*wm_fullscreen)(Display *dpy, Window win, int state) = NULL;

/* ------------------------------------------------------------------------ */
extern int full;
extern int stay;
extern int oldswitch;

static Atom net_wm            = None;
static Atom net_wm_state      = None;
static Atom net_wm_top        = None;
static Atom net_wm_above      = None;
static Atom net_wm_fullscreen = None;

#define _NET_WM_STATE_REMOVE        0    /* remove/unset property */
#define _NET_WM_STATE_ADD           1    /* add/set property */
#define _NET_WM_STATE_TOGGLE        2    /* toggle property  */

/* MWM decorations values */
#define MWM_DECOR_NONE          0
#define MWM_DECOR_ALL           (1L << 0)
#define MWM_DECOR_BORDER        (1L << 1)
#define MWM_DECOR_RESIZEH       (1L << 2)
#define MWM_DECOR_TITLE         (1L << 3)
#define MWM_DECOR_MENU          (1L << 4)
#define MWM_DECOR_MINIMIZE      (1L << 5)
#define MWM_DECOR_MAXIMIZE      (1L << 6)

/* KDE decoration values */
enum {
  KDE_noDecoration = 0,
  KDE_normalDecoration = 1,
  KDE_tinyDecoration = 2,
  KDE_noFocus = 256,
  KDE_standaloneMenuBar = 512,
  KDE_desktopIcon = 1024 ,
  KDE_staysOnTop = 2048
};

void
net_wm_stay_on_top(Display *dpy, Window win, int state)
{
  XEvent e;

  memset(&e, 0, sizeof(e));  
  e.xclient.type = ClientMessage;
  e.xclient.message_type = net_wm_state;
  e.xclient.display = dpy;
  e.xclient.window = win;
  e.xclient.format = 32;
  e.xclient.data.l[0] = (state == 1)
	? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
  e.xclient.data.l[1] = net_wm_top;
  e.xclient.data.l[2] = 0l;
  e.xclient.data.l[3] = 0l;
  e.xclient.data.l[4] = 0l;

  XSendEvent(dpy, DefaultRootWindow(dpy), True, 
  	SubstructureRedirectMask | SubstructureNotifyMask, (XEvent *) &e);
  XSync(dpy, False);
}

void
net_wm_stay_above(Display *dpy, Window win, int state)
{
  XEvent e;
  
  memset(&e, 0, sizeof(e));
  e.xclient.type = ClientMessage;
  e.xclient.message_type = net_wm_state;
  e.xclient.display = dpy;
  e.xclient.window = win;
  e.xclient.format = 32;
  e.xclient.data.l[0] = (state == 1)
	? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
  e.xclient.data.l[1] = net_wm_above;
  e.xclient.data.l[2] = 0l;
  e.xclient.data.l[3] = 0l;
  e.xclient.data.l[4] = 0l;

  XSendEvent(dpy, DefaultRootWindow(dpy), True, 
  	SubstructureRedirectMask | SubstructureNotifyMask, (XEvent *) &e);
  XSync(dpy, False);
}

void
wm_netwm_set_fullscreen(Display *dpy, Window win, int state)
{
  XEvent e;

  memset(&e, 0, sizeof(e));
  e.xclient.type = ClientMessage;
  e.xclient.window = win;  
  e.xclient.message_type = net_wm_state;
  e.xclient.display = dpy;
  e.xclient.format = 32;
  e.xclient.data.l[0] = (state == 1)
	? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
  e.xclient.data.l[1] = net_wm_fullscreen;
  e.xclient.data.l[2] = 0l;
  e.xclient.data.l[3] = 0l;
  e.xclient.data.l[4] = 0l;

  XSendEvent(dpy, DefaultRootWindow(dpy), False, 
  	SubstructureRedirectMask | SubstructureNotifyMask, (XEvent *) &e);
  XSync(dpy, False);
}

void
wm_decoration(Widget w, int decorations)
{
  Atom WM_HINTS;
  int set;
  Display *display= XOpenDisplay(NULL);
  Window window;
  
  display = XtDisplay(w);
  window = XtWindow(w);
    
  if (!decorations)
    {
      /* We haven't modified the window manager hints yet */
      set = False;

      /* First try to set MWM hints */
      WM_HINTS = XInternAtom(display, "_MOTIF_WM_HINTS", True);
      if ( WM_HINTS != None )
        {
		  #define MWM_HINTS_DECORATIONS   (1L << 1)
          struct {
            unsigned long flags;
            unsigned long functions;
            unsigned long decorations;
                     long input_mode;
            unsigned long status;
          } MWMHints = { MWM_HINTS_DECORATIONS, 0, 0/*MWM_DECOR_BORDER*/, 0, 0 };

          XChangeProperty(display, window, WM_HINTS, WM_HINTS, 32,
                          PropModeReplace, (unsigned char *)&MWMHints,
                          sizeof(MWMHints)/4);
          set = True;
        }

      /* Now try to set KWM hints */
      WM_HINTS = XInternAtom(display, "KWM_WIN_DECORATION", True);
      if ( WM_HINTS != None )
        {
          long KWMHints = KDE_tinyDecoration;

          XChangeProperty(display, window, WM_HINTS, WM_HINTS, 32,
                          PropModeReplace, (unsigned char *)&KWMHints,
                          sizeof(KWMHints)/4);
          set = True;
        }

      /* Now try to set GNOME hints */
      WM_HINTS = XInternAtom(display, "_WIN_HINTS", True);
      if ( WM_HINTS != None )
        {
          long GNOMEHints = 0;

          XChangeProperty(display, window, WM_HINTS, WM_HINTS, 32,
                          PropModeReplace, (unsigned char *)&GNOMEHints,
                          sizeof(GNOMEHints)/4);
          set = True;
        }

      /* Now try to set KDE NET_WM hints */
      WM_HINTS = XInternAtom(display, "_NET_WM_WINDOW_TYPE", True);
      if ( WM_HINTS != None )
        {
          Atom NET_WMHints[2];

          NET_WMHints[0] = XInternAtom(display, "_KDE_NET_WM_WINDOW_TYPE_OVERRIDE", True);
          /* define a fallback... */
          NET_WMHints[1] = XInternAtom(display, "_NET_WM_WINDOW_TYPE_NORMAL", True);

          XChangeProperty(display, window,
                          WM_HINTS, XA_ATOM, 32, PropModeReplace,
                          (unsigned char *)&NET_WMHints, 2);
          set = True;
        }

      /* Finally set the transient hints if necessary */
     if ( set )
        {
          XSetTransientForHint(display, window, RootWindow(display, DefaultScreen(display)));    
	  XtUnmapWidget(w);
          XtMapWidget(w);
          if (stay ==1)
            net_wm_stay_on_top(display, window, stay);
        }
    }
  else
    {
      /* We haven't modified the window manager hints yet */
      set = False;

      /* First try to unset MWM hints */
      WM_HINTS = XInternAtom(display, "_MOTIF_WM_HINTS", True);
      if ( WM_HINTS != None )
        {

          XDeleteProperty(display, window, WM_HINTS);
          set = True;
        }

      /* Now try to unset KWM hints */
      WM_HINTS = XInternAtom(display, "KWM_WIN_DECORATION", True);
      if ( WM_HINTS != None )
        {
          XDeleteProperty(display, window, WM_HINTS);
          set = True;
        }

      /* Now try to unset GNOME hints */
      WM_HINTS = XInternAtom(display, "_WIN_HINTS", True);
      if ( WM_HINTS != None )
        {
		  XDeleteProperty(display, window, WM_HINTS);
          set = True;
        }

      /* Now try to unset NET_WM hints */
      WM_HINTS = XInternAtom(display, "_NET_WM_WINDOW_TYPE", True);
      if ( WM_HINTS != None )
        {
          Atom NET_WMHints = XInternAtom(display, "_NET_WM_WINDOW_TYPE_NORMAL", True);

          if ( NET_WMHints != None )
            {
              XChangeProperty(display, window,
                              WM_HINTS, XA_ATOM, 32, PropModeReplace,
                              (unsigned char *)&NET_WMHints, 1);
              set = True;
            }
        }

      /* Finally unset the transient hints if necessary */
      if ( set )
        {
          /* NOTE: Does this work? */
          XSetTransientForHint(display, window, None);
          XtUnmapWidget(w);
          XtMapWidget(w);
          if (stay ==1)
            net_wm_stay_on_top(display, window, stay);
        }
    }
}

/* ------------------------------------------------------------------------ */

static Atom gnome       = None;
static Atom gnome_layer = None;


#define WIN_LAYER_DESKTOP                0
#define WIN_LAYER_BELOW                  2
#define WIN_LAYER_NORMAL                 4
#define WIN_LAYER_ONTOP                  6
#define WIN_LAYER_DOCK                   8
#define WIN_LAYER_ABOVE_DOCK             10
#define WIN_LAYER_MENU                   12

void
gnome_win_layer_stay_on_top(Display *dpy, Window win, int state)
{
  XClientMessageEvent  xev;

  if (0 == win)
	return;

  memset(&xev, 0, sizeof(xev));
  xev.type = ClientMessage;
  xev.window = win;
  xev.message_type = XInternAtom(dpy, "_WIN_LAYER", False);
  xev.format = 32;
  switch (state)
    {
    case -1:
      xev.data.l[0] = WIN_LAYER_BELOW;
      break;
    case  0:
      xev.data.l[0] = WIN_LAYER_NORMAL;
      break;
    case  1:
      xev.data.l[0] = WIN_LAYER_ABOVE_DOCK;
      break;
    default:
      xev.data.l[0] = WIN_LAYER_NORMAL;
      break;
    }
  XSendEvent(dpy,DefaultRootWindow(dpy),False,
             SubstructureNotifyMask,(XEvent*)&xev);
  if (state)
    XRaiseWindow(dpy,win);
}

void
gnome_no_win_layer_stay_on_top(Display *dpy, Window win, int state)
{
  long data[1];
 
  switch (state)
    {
    case -1:
      data[0] = WIN_LAYER_BELOW;
      break;
    case 0:
      data[0] = WIN_LAYER_ONTOP;
      break;
    case 1:
      data[0] = WIN_LAYER_ABOVE_DOCK;
      break;
    default:
      data[0] = WIN_LAYER_ONTOP;
      break;
    }

  XChangeProperty(dpy, win, gnome_layer,
                  XA_CARDINAL, 32, PropModeReplace, (unsigned char *)data,
                  1);

  if (state)
    XRaiseWindow(dpy,win);
}

/* ------------------------------------------------------------------------ */

int
wm_detect(Display *dpy)
{
  Atom            type;
  int             format;
  unsigned long   nitems, bytesafter;
  unsigned char  *args = NULL;
  Atom            gnome_protocols;
  Window root = DefaultRootWindow(dpy);
  int             i;
  int             have_win_layer = 0;
  char            *atom_name;

  /* test ntwm compliance first for the few window managers (like metacity)
   * which are netwm and gnome compliant as netwm is the preferred method
   * to control things...
   */

  /* netwm compliant */

  if ((net_wm = XInternAtom(dpy, "_NET_SUPPORTED", False)) != None)
    {
      if (Success == XGetWindowProperty
          (dpy, root, net_wm, 0, (65536 / sizeof(long)), False,
           AnyPropertyType, &type, &format, &nitems, &bytesafter, &args) &&
          nitems > 0)
        {
          fprintf(stderr,"wmhooks: netwm detected\n");
          for(i=0;i<nitems;i++)
            {
              atom_name = XGetAtomName(dpy,((long *)args)[i]);
              if (debug)
                fprintf(stderr, "_NET_WM atom: %s\n", atom_name);
              if (strcmp("_NET_WM_STATE", atom_name) == 0)
                {
                  net_wm_state = ((long *)args)[i];
                  if (debug)
                    fprintf(stderr,"wmhooks: netwm supports _NET_WM_STATE\n");
                }
              else if (strcmp("_NET_WM_STATE_STAYS_ON_TOP", atom_name) == 0)
                {
                  net_wm_top = ((long *)args)[i];
                  if (debug)
                    fprintf(stderr,"wmhooks: netwm supports _NET_WM_STATE_STAYS_ON_TOP\n");
                }
              else if (strcmp("_NET_WM_STATE_FULLSCREEN", atom_name) == 0)
                {
                  net_wm_fullscreen = ((long *)args)[i];
                  if (debug)
                    fprintf(stderr,"wmhooks: netwm supports _NET_WM_STATE_FULLSCREEN\n");
                }
              else if (strcmp("_NET_WM_STATE_ABOVE", atom_name) == 0)
                {
                  net_wm_above = ((long *)args)[i];
                  if (debug)
                    fprintf(stderr,"wmhooks: netwm supports _NET_WM_STATE_ABOVE\n");
                }
            }

          if (net_wm_state != None)
            {
	      if (debug)
	      {
                fprintf(stderr,"net_wm_fullscreen: %d\n",(int)net_wm_fullscreen);
                fprintf(stderr,"net_wm_state: %d\n",(int)net_wm_state);
	      }
              if (net_wm_above != None)
                {
                  fprintf(stderr,"wmhooks: netwm state above supported\n");
                  wm_stay_on_top = net_wm_stay_above;
                }
              else if (net_wm_top != None)
                {
                  fprintf(stderr,"wmhooks: netwm stay on top supported\n");
                  wm_stay_on_top = net_wm_stay_on_top;
                }
              if (net_wm_fullscreen != None)
                {
                  fprintf(stderr,"wmhooks: netwm fullscreen supported\n");
                  if (oldswitch)
		    wm_fullscreen = wm_netwm_set_fullscreen;
                }
            }
          XFree(args);
        }
    }

  /* gnome-compilant */
  if ((gnome = XInternAtom(dpy, "_WIN_SUPPORTING_WM_CHECK", False)) != None)
    {
      if (Success == XGetWindowProperty
          (dpy, root, gnome, 0, (65536 / sizeof(long)), False,
           AnyPropertyType, &type, &format, &nitems, &bytesafter, &args) &&
          nitems > 0)
        {
          fprintf(stderr,"wmhooks: gnome detected\n");
          XFree(args);

          /* check capabilities */
          gnome_protocols   = XInternAtom(dpy, "_WIN_PROTOCOLS", False);
          if (Success == XGetWindowProperty
              (dpy, root, gnome_protocols, 0, (65536 / sizeof(long)), False,
               AnyPropertyType, &type, &format, &nitems, &bytesafter, &args) &&
              nitems > 0)
            {
              for(i=0;i<nitems;i++)
                {
                  atom_name = XGetAtomName(dpy,((long *)args)[i]);
                  if (debug)
                    fprintf(stderr, "_WIN_PROTOCOLS atom: %s\n", atom_name);
                  if (strcmp("_WIN_LAYER", atom_name) == 0)
                    {
                      have_win_layer = 1;
                      break;
                    }
                }
            }

          gnome_layer = XInternAtom(dpy, "_WIN_LAYER", False);
          if (have_win_layer)
            {
              if (wm_stay_on_top == NULL)
                {
                  fprintf(stderr,"wmhooks: gnome stay on top with _WIN_LAYER\n");
                  wm_stay_on_top = gnome_win_layer_stay_on_top;
                }
            }
          else
            {
              if (wm_stay_on_top == NULL)
                {
                  fprintf(stderr,"wmhooks: gnome stay on top without _WIN_LAYER\n");
                  wm_stay_on_top = gnome_no_win_layer_stay_on_top;
                }
            }

          XFree(args);
          return 0;
        }
    }

  /* nothing found... */
  fprintf(stderr,"wmhooks: nothing found...\n");
  return -1;
}
