/*****************************************************************************
 * writefile.c: save pictures to disk (ppm,pgm,jpeg)
 *****************************************************************************
 * $Id: writefile.c,v 1.3 2004/08/04 18:39:14 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *  (c) 1998 Gerd Knorr <kraxel@goldbach.in-berlin.de>
 *
 *****************************************************************************/
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#ifdef HAVE_LIBJPEG
# include <jpeglib.h>
#endif

#include "writefile.h"

extern int have_xv;

/* ---------------------------------------------------------------------- */

/*
 * count up the latest block of digits in the passed string
 * (used for filename numbering
 */
int
patch_up (char *name)
{
  char *ptr;

  for (ptr = name + strlen (name); ptr >= name; ptr--)
    if (isdigit (*ptr))
      break;
  if (ptr < name)
    return 0;
  while (*ptr == '9' && ptr >= name)
    *(ptr--) = '0';
  if (ptr < name)
    return 0;
  if (isdigit (*ptr))
    {
      (*ptr)++;
      return 1;
    }
  return 0;
}

char *
snap_filename (char *base, char *channel, char *ext)
{
  static time_t last = 0;
  static int count = 0;
  static char *filename = NULL;
  
  time_t now;
  struct tm *tm;
  char timestamp[32];
  char *pt;

  time (&now);
  tm = localtime (&now);

  if (last != now)
    count = 0;
  last = now;
  count++;
   

  if (filename != NULL)
    free (filename);
  filename  = malloc (strlen (base) + strlen (channel) + strlen (ext) + 32);

  strftime (timestamp, 31, "%Y%m%d-%H%M%S", tm);
  sprintf (filename, "%s-%s-%s-%d.%s", base, channel, timestamp, count, ext);

  pt = filename;
  while (*pt != 0)
    {
      if (*pt == '/')
        *pt = '|';
      pt++;
    }

  return filename;
}

#ifdef HAVE_LIBJPEG
int
write_jpeg (char *filepath, char *filename, char *data, int width, int height, int quality,
            int gray)
{
  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  FILE *fp;
  int i;
  unsigned char *line;
  int line_length;
  char filename_full[256];
  
  sprintf(filename_full,"%s/%s",filepath, filename);
  if (NULL == (fp = fopen (filename_full, "w")))
    {
      fprintf (stderr, "write_jpeg: can't open %s: %s\n", filename_full,
               strerror (errno));
      return -1;
    }

  cinfo.err = jpeg_std_error (&jerr);
  jpeg_create_compress (&cinfo);
  jpeg_stdio_dest (&cinfo, fp);
  cinfo.image_width = width;
  cinfo.image_height = height;
  cinfo.input_components = gray ? 1 : 3;
  cinfo.in_color_space = gray ? JCS_GRAYSCALE : JCS_RGB;
  jpeg_set_defaults (&cinfo);
  jpeg_set_quality (&cinfo, quality, TRUE);
  jpeg_start_compress (&cinfo, TRUE);
  line_length = gray ? width : width * 3;

  for (i = 0, line = data; i < height; i++, line += line_length)
    jpeg_write_scanlines (&cinfo, &line, 1);

  jpeg_finish_compress (&(cinfo));
  jpeg_destroy_compress (&(cinfo));

  fclose (fp);

  return 0;
}
#endif

int
write_ppm (char *filepath, char *filename, char *data, int width, int height)
{
  FILE *fp;
  char filename_full[256];
  
  sprintf(filename_full,"%s/%s",filepath, filename);
  if (NULL == (fp = fopen (filename_full, "w")))
    {
      fprintf (stderr, "write_ppm: can't open %s: %s\n", filename_full,
               strerror (errno));
      return -1;
    }
  fprintf (fp, "P6\n%d %d\n255\n", width, height);
  fwrite (data, height, 3 * width, fp);
  fclose (fp);

  return 0;
}

int
write_pgm (char *filepath, char *filename, char *data, int width, int height)
{
  FILE *fp;
  char filename_full[256];
  
  sprintf(filename_full,"%s/%s",filepath, filename);
  if (NULL == (fp = fopen (filename_full, "w")))
    {
      fprintf (stderr, "write_pgm: can't open %s: %s\n", filename_full,
               strerror (errno));
      return -1;
    }
  fprintf (fp, "P5\n%d %d\n255\n", width, height);
  fwrite (data, height, width, fp);
  fclose (fp);

  return 0;
}
