/*******************************************************************
 *                                                                 *
 * program: xircp                                                  *
 * author: Anthony Lineberry <omin0us_@hotmail.com>                *
 *                                                                 *
 * This program is a GUI frontend to the program "ircp" that will  *
 * send files via IrDA beaming. It uses GTK+ 2.0 to display the    *
 * GUI frontend. I did not write the program "ircp" so please do   *
 * not e-mail me questions regarding problems with it. This program*
 * is lisenced under the GNU General Public License.               *
 * <http://www.gnu.org/licenses/gpl.html> If you did not recieve a *
 * copy of the GPL with this source please contact me at           *
 * omin0us_@hotmail.com (the 0 is a zero).                         *
 *                                                                 *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <strings.h>
#include <unistd.h>
#include <sys/types.h>

static gboolean close_application(GtkWidget *widget, GdkEvent *event, gpointer data);
static void irda_send( GtkWidget *widget, gpointer data);
static void irda_receive( GtkWidget *widget, gpointer data);
void get_file_name( GtkWidget *widget, GtkFileSelection *fs);
void browse(GtkWidget *widget, gpointer data);

char *filename; /* holds the name of the file to be sent */
GtkWidget *filew; /* external widget filew is the pointer to the File Selection Widget */

int main(int argc, char *argv[])
{
	GtkWidget *button;
	GtkWidget *window;
	GtkWidget *hbox1;
	GtkWidget *vbox1;
	GtkWidget *frame;
	GtkWidget *label;
	//GtkWidget *entry; /*this widget will be used later on mabey */
	GtkWidget *fileselect;

	gtk_init(&argc, &argv);
	
	/* we'll start up the IrDA device */
	system("/etc/rc.d/init.d/irda start");

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	/* lets connect the funtion to close the application with the "x" on the window */
	g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(close_application), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);	
	//gtk_window_set_default_size(GTK_WINDOW(window), 320, 240);


	vbox1 = gtk_vbox_new(TRUE, 5);

	/*lets create our "Send" button and connect it with the function "irda_send" when its clicked */
	button = gtk_button_new_with_label("Send");
	g_signal_connect( G_OBJECT(button), "clicked", G_CALLBACK(irda_send), NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);

	/*Now we'll create our "Recieve" button and connect it to our function "irda_recieve" when its clicked */
	button = gtk_button_new_with_label("Receive");
	g_signal_connect( G_OBJECT(button), "clicked", G_CALLBACK(irda_receive), NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new(FALSE, 5);


	/* we'll make a frame to go around our label so it looks all purty */
	frame = gtk_frame_new("xircp");

	/* and now we'll add in a label with some simple instructions of how to use the App. */
	label = gtk_label_new("Select the File you wish\nto transfer via IrDA.\nthen press Send. Or\npress recieve to accept\na file.");
	gtk_container_add(GTK_CONTAINER(frame), label);
	gtk_box_pack_start(GTK_BOX(hbox1), frame, TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(hbox1), vbox1, TRUE, FALSE, 5);
	//gtk_container_add(GTK_CONTAINER(window), hbox1);

	/* this may be used later on to just type in the path of the file to be sent, or to show what file was selected to be sent */
	//entry = gtk_entry_new();
	//gtk_entry_set_max_length(GTK_ENTRY(entry), 50);
	//g_signal_connect

	/* now we'll create a new button called "Browse" and connect it with our "browse" funtion. This will be the button to click 
	 * to select the file to be sent.*/
	button = gtk_button_new_with_label("Browse");
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(browse), NULL);

	/* lets pack it it all up into the window */
	vbox1 = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(window), vbox1);
	gtk_widget_show_all(window);

	gtk_main();

	system("/etc/rc.d/init.d/irda stop");
	return(0);
}

/* this function will close the apps window as well as the app*/
static gboolean close_application( GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
  return(FALSE);
}

/* this function is what displays the fileselection widget. It then calls the "get_file_name" function to inject the selected filename
*  into the external variable "filename". if it cannot complete this action, it displays an error dialog window */
void browse( GtkWidget *widget, gpointer data)
{
  //GtkWidget *filew;
  filew = gtk_file_selection_new("File_selection");

  g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(filew)->ok_button), "clicked", G_CALLBACK(get_file_name), (gpointer) filew);
  g_signal_connect_swapped(G_OBJECT(GTK_FILE_SELECTION(filew)->cancel_button), "clicked", G_CALLBACK(gtk_widget_destroy), G_OBJECT(filew));
  gtk_widget_show(filew);
}

/* This funtion is called by the funtion "browse". It does some error checking for the file name length and then copies the path of the
 * to the variable "filename" */
void get_file_name( GtkWidget *widget, GtkFileSelection *fs)
{
  g_print("Allocating space for filename...\n");
  if((filename = (char *)malloc(strlen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs))))) == NULL)
  {
    GtkWidget *window;
    GtkWidget *label;
    GtkWidget *button;
    GtkWidget *vbox;

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    vbox = gtk_vbox_new(FALSE,5);
    
    label = gtk_label_new("Error: Could not allocate space\nfor the filename.");
    gtk_box_pack_start(GTK_BOX(vbox),label, FALSE, FALSE, 5);
    button = gtk_button_new_with_label("OK");
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(close_application), NULL);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 5);
    gtk_container_add(GTK_CONTAINER(window), vbox);
    gtk_widget_show_all(window);
    /* oh no!! we couldn't allocate enough space. must be h4x0rs!! */
    g_print("Error: Could not allocate space for the filename.");
  }
  /* we were able to allocate the space. good job kernel */
  g_print("Success.\n");
  
  /* now this is were we actually copy the file name path to "filename" */
  strncpy(filename,(char *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),strlen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs))));
  gtk_widget_destroy(filew);
}


/* this function will send the file to the other device using the program ircp as the backend for it. */
static void irda_send( GtkWidget *widget, gpointer data)
{
  char *irdaprog[3];
  char *string;
  pid_t pid;

  irdaprog[0] = "/usr/bin/ircp";
  irdaprog[1] = filename;
  irdaprog[2] = NULL;
  
  g_print("starting child process...\n");
  
  /* lets try and fork a child process to run ircp*/
  if((pid = fork()) == 0)
  {
    
    //printf("string: %s\n",string);
    printf("sending %s via IrDA (/dev/ircomm)\n",irdaprog[1]);
    execve(irdaprog[0], irdaprog, NULL);
  } 
  
  /* uh-oh, we couldn't start a child process. what a bummer :( */
  else if(pid == -1)
    {
      GtkWidget *window;
      GtkWidget *label;
      
      /* since we failed, lets give them a dialog window to let them know it failed, and rub it in their faces. also we'll give a little
       * console output as well */
      window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_container_set_border_width(GTK_CONTAINER(window),5);
      label = gtk_label_new("Error: Could not start \nchild process");
      fprintf(stderr,"Error: could not start child process");
      gtk_container_add(GTK_CONTAINER(window),label);
      gtk_widget_show_all(window);
    }
  //strcpy(string, irdaprog[0]);
  //strcat(string, irdaprog[1]);
 
  /* Start the IrDA devcie. */
  //system("/etc/rc.d/init.d/irda start");
  /* send the file using ircp */
  
  //system(string);
  /* stop the IrDA device. There are bugs here at this point. The program exits right after the execve funtion above, and therefore
   * never stops the IrDA device */
  //system("/etc/rc.d/init.d/irda stop");
}

/* this funtion will recieve a file from another IrDA enabled device via the program ircp */
static void irda_receive( GtkWidget *widget, gpointer data)
{
  //system("/etc/rc.d/init.d/irda start");
  system("ircp -r ~");/* /etc/rc.d/init.d/irda stop");*/
  printf("Reveiving via IrDA...\nWaiting for incoming signal\n");
}
