//
// zmixer - audio mixer
// Copyright (C) 2005 Bryan Beicker <tokiko@tokiko.net>
//
// This file is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2)
// as published by the Free Software Foundation.
//
// This file is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#include <gtk/gtk.h>		// gtk
#include "main.h"
#include "master.xpm"
#include "pcm.xpm"
#include "cd.xpm"
#include "line.xpm"
#include "mic.xpm"


gboolean zmixer_delete_event_signal(GtkWidget * window, GdkEvent * event, gpointer data)
{
	return zmixer_unload();
}


void zmixer_destroy_signal(GtkWidget * window, gpointer data)
{
	zmixer_destroy();
}


void master_value_changed_signal(GtkWidget * widget, gpointer data)
{
	master_value_changed((int) gtk_range_get_value(GTK_RANGE(widget)));
}


void pcm_value_changed_signal(GtkWidget * widget, gpointer data)
{
	pcm_value_changed((int) gtk_range_get_value(GTK_RANGE(widget)));
}


void cd_value_changed_signal(GtkWidget * widget, gpointer data)
{
	cd_value_changed((int) gtk_range_get_value(GTK_RANGE(widget)));
}


void line_value_changed_signal(GtkWidget * widget, gpointer data)
{
	line_value_changed((int) gtk_range_get_value(GTK_RANGE(widget)));
}


void mic_value_changed_signal(GtkWidget * widget, gpointer data)
{
	mic_value_changed((int) gtk_range_get_value(GTK_RANGE(widget)));
}


void zmixer_create()
{
	zmixer = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(zmixer), "volume");
	gtk_widget_set_size_request(zmixer, -1, 180);
	gtk_window_set_resizable(GTK_WINDOW(zmixer), FALSE);

	GdkPixbuf * pixbuf;
	pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) master_xpm);
	gtk_window_set_icon(GTK_WINDOW(zmixer), pixbuf);

	GtkWidget * table;
	table = gtk_table_new(3, 9, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(zmixer), table);
	gtk_container_set_border_width(GTK_CONTAINER(table), 8);
	gtk_table_set_row_spacings(GTK_TABLE(table), 8);
	gtk_table_set_col_spacings(GTK_TABLE(table), 8);

	GdkPixbuf * master_pixbuf;
	GtkWidget * master_image;
	master_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) master_xpm);
	master_image = gtk_image_new_from_pixbuf(master_pixbuf);
	gtk_widget_show(master_image);
	gtk_table_attach(GTK_TABLE(table), master_image, 0, 1, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GdkPixbuf * pcm_pixbuf;
	GtkWidget * pcm_image;
	pcm_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) pcm_xpm);
	pcm_image = gtk_image_new_from_pixbuf(pcm_pixbuf);
	gtk_widget_show(pcm_image);
	gtk_table_attach(GTK_TABLE(table), pcm_image, 2, 3, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GdkPixbuf * cd_pixbuf;
	GtkWidget * cd_image;
	cd_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) cd_xpm);
	cd_image = gtk_image_new_from_pixbuf(cd_pixbuf);
	gtk_widget_show(cd_image);
	gtk_table_attach(GTK_TABLE(table), cd_image, 4, 5, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GdkPixbuf * line_pixbuf;
	GtkWidget * line_image;
	line_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) line_xpm);
	line_image = gtk_image_new_from_pixbuf(line_pixbuf);
	gtk_widget_show(line_image);
	gtk_table_attach(GTK_TABLE(table), line_image, 6, 7, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GdkPixbuf * mic_pixbuf;
	GtkWidget * mic_image;
	mic_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) mic_xpm);
	mic_image = gtk_image_new_from_pixbuf(mic_pixbuf);
	gtk_widget_show(mic_image);
	gtk_table_attach(GTK_TABLE(table), mic_image, 8, 9, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	master = gtk_vscale_new(NULL);
	gtk_widget_show(master);
	gtk_table_attach(GTK_TABLE(table), master, 0, 1, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 16, 0);
	gtk_scale_set_draw_value(GTK_SCALE(master), FALSE);
	gtk_range_set_inverted(GTK_RANGE(master), TRUE);

	pcm = gtk_vscale_new(NULL);
	gtk_widget_show(pcm);
	gtk_table_attach(GTK_TABLE(table), pcm, 2, 3, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 16, 0);
	gtk_scale_set_draw_value(GTK_SCALE(pcm), FALSE);
	gtk_range_set_inverted(GTK_RANGE(pcm), TRUE);

	cd = gtk_vscale_new(NULL);
	gtk_widget_show(cd);
	gtk_table_attach(GTK_TABLE(table), cd, 4, 5, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 16, 0);
	gtk_scale_set_draw_value(GTK_SCALE(cd), FALSE);
	gtk_range_set_inverted(GTK_RANGE(cd), TRUE);

	line = gtk_vscale_new(NULL);
	gtk_widget_show(line);
	gtk_table_attach(GTK_TABLE(table), line, 6, 7, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 16, 0);
	gtk_scale_set_draw_value(GTK_SCALE(line), FALSE);
	gtk_range_set_inverted(GTK_RANGE(line), TRUE);

	mic = gtk_vscale_new(NULL);
	gtk_widget_show(mic);
	gtk_table_attach(GTK_TABLE(table), mic, 8, 9, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 16, 0);
	gtk_scale_set_draw_value(GTK_SCALE(mic), FALSE);
	gtk_range_set_inverted(GTK_RANGE(mic), TRUE);

	GtkWidget * vseparator1;
	vseparator1 = gtk_vseparator_new();
	gtk_widget_show(vseparator1);
	gtk_table_attach(GTK_TABLE(table), vseparator1, 1, 2, 0, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	GtkWidget * vseparator2;
	vseparator2 = gtk_vseparator_new();
	gtk_widget_show(vseparator2);
	gtk_table_attach(GTK_TABLE(table), vseparator2, 3, 4, 0, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	GtkWidget * vseparator3;
	vseparator3 = gtk_vseparator_new();
	gtk_widget_show(vseparator3);
	gtk_table_attach(GTK_TABLE(table), vseparator3, 5, 6, 0, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	GtkWidget * vseparator4;
	vseparator4 = gtk_vseparator_new();
	gtk_widget_show(vseparator4);
	gtk_table_attach(GTK_TABLE(table), vseparator4, 7, 8, 0, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	GtkWidget * label1;
	label1 = gtk_label_new("master");
	gtk_widget_show(label1);
	gtk_table_attach(GTK_TABLE(table), label1, 0, 1, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GtkWidget * label2;
	label2 = gtk_label_new("pcm");
	gtk_widget_show(label2);
	gtk_table_attach(GTK_TABLE(table), label2, 2, 3, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GtkWidget * label3;
	label3 = gtk_label_new("cd");
	gtk_widget_show(label3);
	gtk_table_attach(GTK_TABLE(table), label3, 4, 5, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GtkWidget * label4;
	label4 = gtk_label_new("line");
	gtk_widget_show(label4);
	gtk_table_attach(GTK_TABLE(table), label4, 6, 7, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	GtkWidget * label5;
	label5 = gtk_label_new("mic");
	gtk_widget_show(label5);
	gtk_table_attach(GTK_TABLE(table), label5, 8, 9, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	g_signal_connect((gpointer) zmixer, "delete_event", G_CALLBACK(zmixer_delete_event_signal), NULL);
	g_signal_connect((gpointer) zmixer, "destroy", G_CALLBACK(zmixer_destroy_signal), NULL);
	g_signal_connect((gpointer) master, "value-changed", G_CALLBACK(master_value_changed_signal), NULL);
	g_signal_connect((gpointer) pcm, "value-changed", G_CALLBACK(pcm_value_changed_signal), NULL);
	g_signal_connect((gpointer) cd, "value-changed", G_CALLBACK(cd_value_changed_signal), NULL);
	g_signal_connect((gpointer) line, "value-changed", G_CALLBACK(line_value_changed_signal), NULL);
	g_signal_connect((gpointer) mic, "value-changed", G_CALLBACK(mic_value_changed_signal), NULL);

	zmixer_load();
	gtk_widget_show(zmixer);
}
