/* main.c
 * Copyright (C) 2003 Chris Parker
 *
 * This file is part of Battery-Status.
 * A battery status applet for the ROX desktop 
 *
 * Battery-Status is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Battery-Status is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <apm.h>

gint
update_progress_bar_apm (GtkWidget *progress_bar_apm)
{
	struct apm_info apminfo;
	char apm_buffer[256];

	float apm_percentage;

	apm_read (&apminfo);

	apm_percentage = (float) apminfo.battery_percentage / 100.0;

	if (apminfo.ac_line_status == AC_LINE_STATUS_ON) {	
		if (apminfo.battery_percentage == 100)
			snprintf(apm_buffer, sizeof(apm_buffer) - 1, "Charged");
		else
			snprintf(apm_buffer, sizeof(apm_buffer) - 1, "Charging");
	} else {
		snprintf (apm_buffer, sizeof(apm_buffer) - 1, "%d%%", 
			apminfo.battery_percentage);
/*
		snprintf (apm_buffer, strlen (apm_buffer) - 1, 
			"%d Minutes Left",
			apminfo.battery_time);
 */
	}
		
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progress_bar_apm), 
		apm_percentage);
	gtk_progress_bar_set_text (GTK_PROGRESS_BAR (progress_bar_apm), 
		apm_buffer);
	
	return TRUE;
}

GtkWidget *
create_window_data (void)
{
	GtkWidget *frame_main;
	GtkWidget *vbox_main;

	GtkWidget *label_title;
	
	GtkWidget *label_apm;
	GtkWidget *progress_bar_apm;

	frame_main = gtk_frame_new (NULL);
	gtk_widget_show (frame_main);

	vbox_main = gtk_vbox_new (FALSE, 5);
	gtk_widget_show (vbox_main);
	gtk_container_add (GTK_CONTAINER (frame_main), vbox_main);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_main), 5);
	
	label_title = gtk_label_new ("Battery");
	gtk_widget_show (label_title);
	gtk_frame_set_label_widget (GTK_FRAME (frame_main), label_title);
	gtk_label_set_justify (GTK_LABEL (label_title), GTK_JUSTIFY_LEFT);

	progress_bar_apm = gtk_progress_bar_new ();
	gtk_widget_show (progress_bar_apm);	
	gtk_timeout_add (250, (GtkFunction) update_progress_bar_apm, 
		progress_bar_apm);
	gtk_box_pack_start (GTK_BOX (vbox_main), 
		progress_bar_apm, FALSE, FALSE, 0);

	

	return frame_main;
}

int
main (int argc, char **argv)
{
	GtkWidget *window_main;
	GdkWindow *socket;
	GtkWidget *window_data;
	
	gtk_init (&argc, &argv);

	if (argc == 2) {
		gint32 xid;

		xid = atol (argv[1]);
		window_main = gtk_plug_new (xid);
		gtk_widget_set_size_request (window_main, 80, 30);
		socket = gdk_window_foreign_new (xid);
	} else {
		window_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (window_main), "Battery");
	}

	window_data = create_window_data ();
	gtk_container_add (GTK_CONTAINER (window_main), window_data);

	gtk_widget_show (window_main);
	g_signal_connect (window_main, "destroy",
		G_CALLBACK (gtk_main_quit), NULL);

	gtk_main ();

	return 0;
}
