/***************************************************************************
 *                       Bookmarks.cpp  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "Bookmarks.h"
#include <qtextstream.h>
#include <qfile.h>
#include <stdlib.h>

MQListViewItem::MQListViewItem(QListView* parent, QString bookmark,QString page, QString filePos, QString newparagraph)
    : QListViewItem(parent,bookmark,page,filePos,newparagraph) 
{
}

QString MQListViewItem::key( int column, bool ascending ) const
{
    if (( column == 1 ) || ( column == 2 ))
    {
        int filePosTemp = (text( 2 )).toInt();
	QString tempS;
	tempS.sprintf("%0*d",10,filePosTemp);
	return tempS;
    } else {
        return QListViewItem::key( column, ascending );
    }
}

//MyView Constructor
Bookmarks::Bookmarks(QWidget *parent, const char *name)
    : QWidget(parent, name)
{
    itemChanged = FALSE;
    boxAll = new QVBox(this);
    bookmarkslistview = new QListView(boxAll);
    bookmarkslistview->addColumn("Bookmark",0);
    bookmarkslistview->addColumn("Page",0);
    //bookmarkslistview->addColumn("",0); //File position
    //bookmarkslistview->addColumn("",0); //Newparagraph
    bookmarkslistview->setSorting(2,TRUE);
    // 2002-09-13, Psimon Ghim, Single-click is more convenient.
    //connect(bookmarkslistview,SIGNAL(doubleClicked(QListViewItem *)),this, SLOT( BookmarkSelected(QListViewItem *)));
    connect(bookmarkslistview,SIGNAL(clicked(QListViewItem *)),this, SLOT( BookmarkSelected(QListViewItem *)));
    connect(bookmarkslistview,SIGNAL(returnPressed(QListViewItem *)),this, SLOT(BookmarkSelected(QListViewItem *)));
    connect(bookmarkslistview,SIGNAL(currentChanged(QListViewItem *)),this, SLOT(currentItemChanged(QListViewItem *)));
}

Bookmarks::~Bookmarks()
{
}

void Bookmarks::resizeEvent(QResizeEvent *)
{
    QScrollBar *scrollbar = bookmarkslistview->verticalScrollBar();
    int scrollbarwidth;
    boxAll->resize(size());
    //bookmarkslistview->setColumnWidth(0,width()-70);
    bookmarkslistview->setColumnWidth(1,45);
    if (scrollbar->isVisible()) scrollbarwidth = scrollbar->width();
    else scrollbarwidth = 0;
    bookmarkslistview->setColumnWidth(0,width()-bookmarkslistview->columnWidth(1)-scrollbarwidth-4);
}

void Bookmarks::showEvent(QShowEvent *)
{
    QScrollBar *scrollbar = bookmarkslistview->verticalScrollBar(); 
    int scrollbarwidth;
//    bookmarkslistview->setFont(QFont::QFont(fontname,10,QFont::Normal,FALSE));
    if (scrollbar->isVisible()) scrollbarwidth = scrollbar->width();
    else scrollbarwidth = 0;
    bookmarkslistview->setColumnWidth(0,width()-bookmarkslistview->columnWidth(1)-scrollbarwidth-4);
}

void Bookmarks::addBookmark(QString markname,int filePos,int page,bool newparagraph)
{
    MQListViewItem *child = 0L;
    child = new MQListViewItem(bookmarkslistview,markname,QString::number(page),QString::number(filePos),QString::number(int(newparagraph)));
    
#ifndef __FOR_QT__
    Global::statusMessage(tr("Bookmark added: ") + markname + ":" + QString::number(page));
#endif
   
}

void Bookmarks::BookmarkSelected(QListViewItem *item)
{
    // 2002-09-13, Psimon Ghim, Avoid null-pointer access.
    if ( item == 0 ) return;
    filePos = (item->text(2)).toInt();
    newparagraph = bool((item->text(3)).toInt());
    itemChanged = TRUE;
    emit BookmarkSignal();
}

void Bookmarks::deleteSelected()
{
    if (bookmarkslistview->selectedItem())
    {
	// A workaround. If there is only one item in the list, destroying it causes segfault
	// so I call clear() on QListView on last item
	if (bookmarkslistview->childCount()<2) bookmarkslistview->clear();
	else (bookmarkslistview->selectedItem())->~QListViewItem();
    }
}

void Bookmarks::currentItemChanged( QListViewItem *item)
{
    // 2002-09-13, Psimon Ghim, Avoid null-pointer access.
    if ( item == 0 ) return;
    filePos = (item->text(2)).toInt();
    newparagraph = bool((item->text(3)).toInt());
    itemChanged = TRUE;
}

void Bookmarks::loadBookmarks(QString filename)
{
    bookmarkslistview->clear();
    QFile file;
    QString s1,s2,s3,s4;
    file.setName(filename);
    if (!file.exists()) return;
    if (!file.open(IO_ReadOnly)) return;
    QTextStream ts(&file);
    ts.setEncoding(QTextStream::UnicodeUTF8);
    bool valid;
    valid = TRUE;
    while (TRUE)
    {
	if (file.atEnd()) break;
	s1 = ts.readLine();
	if (file.atEnd()) break;
	s2 = ts.readLine();
	if (file.atEnd()) break;
	s3 = ts.readLine();
	if (file.atEnd()) break;
	s4 = ts.readLine();
	addBookmark(s1,s3.toInt(),s2.toInt(),bool(s3.toInt()));
    }
}

void Bookmarks::saveBookmarks(QString filename)
{
    QFile file;
    QString s;
    file.setName(filename);
    if (!file.open(IO_WriteOnly)) return;
    QTextStream ts(&file);
    ts.setEncoding(QTextStream::UnicodeUTF8);
    QListViewItemIterator it( bookmarkslistview);
    for ( ; it.current(); ++it )
    {
	s = (it.current())->text(0)+"\n"+(it.current())->text(1)+"\n"+(it.current())->text(2)+"\n"+(it.current())->text(3)+"\n";
	ts.operator<<(s);
    }
    file.close();
}

