/***************************************************************************
 *                       ColorComboBox.cpp  -  description
 *                               -------------------
 *  begin                : Tue May 22 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qpixmap.h>
#include <qapplication.h>
#include "ColorComboBox.h"

ColorComboBox::ColorComboBox(QWidget *parent, const char *name)
    : QComboBox(parent, name)
{
    maxColors = sizeof(colorArray)/sizeof(colorArray[0]);
    colorArray[0] = Qt::black;
    colorArray[1] = Qt::white;
    colorArray[2] = Qt::darkGray;
    colorArray[3] = Qt::gray;
    colorArray[4] = Qt::lightGray;
    colorArray[5] = Qt::red;
    colorArray[6] = Qt::green;
    colorArray[7] = Qt::blue;
    colorArray[8] = Qt::cyan;
    colorArray[9] = Qt::magenta;
    colorArray[10] = Qt::yellow;
    colorArray[11] = Qt::darkRed;
    colorArray[12] = Qt::darkGreen;
    colorArray[13] = Qt::darkBlue;
    colorArray[14] = Qt::darkCyan;
    colorArray[15] = Qt::darkMagenta;
    colorArray[16] = Qt::darkYellow;

    QFont defaultFont = QApplication::font();
    int x = defaultFont.pixelSize();
    setMaximumWidth(x * 8);
    //setFixedSize(64,24);
    
    for (int i = 0;i<maxColors;i++)
    {
    	QPixmap p(x * 8, x, -1);
    	p.fill(colorArray[i]);
    	insertItem(p,i);
    }
    connect(this,SIGNAL(activated(int)),this,SLOT(setColor(int)));
}

void ColorComboBox::setColor(int i)
{
    color = colorArray[i];
}

void ColorComboBox::setCurrentColor(QColor c)
{
    for (int i = 0;i<maxColors;i++)
    {
	if (colorArray[i] == c)
	{
	     setCurrentItem(i);
	     color = colorArray[i];
	     return;
	}
    }
    color = colorArray[3];
    setCurrentItem(3);
}


