/***************************************************************************
 *                       IntDict.cpp  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "IntDict.h"
#include <stdio.h>

IntDict::IntDict()
{
    dict = 0;
    dictName = "";
    error = "";
}

IntDict::~IntDict()
{
}

QString IntDict::getDictName()
{
    return dictName;
}

void IntDict::setDictName(QString d)
{
    if (!d) return;
    if (d == dictName) return;
    dictName = d;
    if (dict) dict->~Dictionary();
    dict = Dictionary::create(dictName);
    if (!dict)
    {
	error = "Error openning dictionary file!";
    } else {
	error = QString::fromUtf8(dict->getError().c_str());;
    }
}

void IntDict::findWord(QString w)
{
    if (!dict) return;
    word = w.lower();
    ret = dict->findEntry(string(word.utf8()),subword);
    translatedWord = QString::fromUtf8(dict->getWord().c_str());
    meaning = QString::fromUtf8(dict->getSense().c_str());
    sense = dictFormat(meaning, translatedWord);
    if (ret)
    {
	info = "Exact translation";
    } else {
	info = "Closest translation";
    }
}

void IntDict::nextWord()
{
    if (!dict) return;
    dict->nextEntry();
    translatedWord = QString::fromUtf8(dict->getWord().c_str());
}

void IntDict::prevWord()
{
    if (!dict) return;
    dict->prevEntry();
    translatedWord = QString::fromUtf8(dict->getWord().c_str());
}

QString IntDict::getWord()
{
    if (!dict) return "";
    return translatedWord;
}

QString IntDict::getSense()
{
    if (!dict) return "";
    return sense;
}

QString IntDict::getError()
{
    return error;
}

QString IntDict::getInfo()
{
    return info;
}

QString IntDict::dictFormat(const QString& text, const QString& headword)
{
    QString result;
    QString etag;
    headWord = headword;
    partOfSpeech = QString();
    pron = QString();
    ndef = 0;
    if (dictProcessBody(text, 0, etag, result) >= 0)
    {
	return result;
    } else {
	return text;
    }
}

int IntDict::dictProcessBody(const QString& text, int idx, QString& etag, QString& ret)
{
	int n, i = idx;
	bool showPron;
	showPron = true;
	QString savePartOfSpeech;

	while ((n = text.find('{', i)) >= 0) {
		// append the body text to the result
		ret += text.mid(i, n - i);

		// find the end of the tag
		int k = text.find('}', n+1);
		if (k < 0) {
			return -1;
		}

		// get the tag and whether it is empty
		QString tag = text.mid(n+1, k-n-1);
		bool empty = false;

		if (tag[tag.length()-1] == '/') {
			empty = true;
			tag = tag.left(tag.length() - 1);
		}

		// if the tag is closing tag, check if it is
		// the one we are looking for
		if (tag[0] == '/') {
			tag = tag.right(tag.length() - 1);
			if (tag != etag) {
				// non-matching end tag -- error
				return -1;
			} else {
				// found it, return
				return k+1;
			}
		}
		i = k+1;

		if (tag == "s") {
			savePartOfSpeech = partOfSpeech;
			ndef=0;
		}

		QString val;

		if (!empty) {
			i = dictProcessBody(text, i, tag, val);
		}

		if (i < 0) {
			// ignore the tag
			i = k+1;
			continue;
		}

		if (tag == "hw") {
			ret += "<b>" + headWord + "</b>";
		} else if (tag == "ps") {
			partOfSpeech = val;
		} else if (tag == "s") {
			ret += "<b>" + headWord + "</b> ";
			if (!pron.isEmpty() && showPron) {
				ret += " /" + pron + "/ ";
			}

			if (!partOfSpeech.isEmpty()) {
				ret += "<i>" + partOfSpeech + "</i>";
			}

			if (ndef > 1) {
				ret += "<ol>" + val + "</ol><hr/>";
			} else {
				while ((k = val.find("<li>")) >= 0) {
					val.remove(k, 4);
				}

				while ((k = val.find("</li>")) >= 0) {
					val.remove(k, 5);
				}

				ret += val + "<hr/>";
			}
			partOfSpeech = savePartOfSpeech;
		} else if (tag == "ss") {
			int ti, tn;
			ret += "<li>";
			for(ti = 0; (tn = val.find('\n', ti)) >= 0; ti = tn+1) {
				ret += "<p>" + val.mid(ti, tn-ti) + "</p>";
			}

			ret += "<p>" + val.right(val.length() - ti) + "</p></li>";
			ndef++;
		} else if (tag == "ex") {
			ret += "<i>" + val + "</i>";
		} else if (tag == "sa") {
			ret += "<a href=\"" + val + "\">" + val + "</a>";
		} else if (tag == "pr") {
			pron = val;
		} else {
			return -1;
		}
	}

	ret += text.right(text.length() - i);

	return text.length();
}
