/***************************************************************************
 *                       StreamPalmMP.cpp  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "StreamPalmMP.h"

StreamPalmMP::~StreamPalmMP()
{
/*    QDir dir;
    dir = QDir::QDir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }*/   
}

QChar StreamPalmMP::isTag(QChar t)
{
    if (t == '\n')
    {
	if (tag.pre)
	{
	    newLine = true;
	    return QChar();
	}
	return ' ';
    }
    if ((t != '<') && (t !='&')) return t;
    return getTag(t);
}

QChar StreamPalmMP::getTag(QChar t)
{
    if (t == '&')
    {
	bool ok;
	tempPos = getPosition();
	QString num = "";
	QString entity = "";
	int i = 10;
	while (--i)
	{
	    textstream->operator>>(tc);
	    if (tc == ';') break;
	    entity.append(tc.lower());
	}
	if (!i)
	{
	    setPosition(tempPos);
	    return t;
	}
	if (entity.at(0) == '#')
	{
	    c = QChar(entity.mid(1).toUShort(&ok,10));
	    if (ok) return c;
	} else {
	    c = entityToChar(entity);
	    return c;
	}
	setPosition(tempPos);
	return t;
    } else {
	//newParagraph = false;
	tagString = "";
	while (1)
	{
	    if (atEnd()) break;
	    //tempPos = getPosition();
	    textstream->operator>>(tc);
	    if (tc == '>') break;
	    tagString.append(tc);
	}
	//setPosition(tempPos);
	tagString = tagString.stripWhiteSpace();
	tagStringLc = tagString.lower();
	tagStart = true;
	if (tagStringLc.at(0) == '/')
	{
	    tagStart = false;
	    tagStringLc.remove(0,1);
	    tagString.remove(0,1);
	    tagName = tagStringLc;
	} else {
	    tagName = tagStringLc;
	    tagName.replace(QRegExp(" .*$"),"");
	}
	if (tagName == "p")
	{
	    //printf("<p>");
	    tag.p = tagStart;
	    newParagraph = tagStart;
	    newLine = true;
	} else if (tagName == "br")
	{
	   tag.br = tagStart;
	   newLine = true;
	} else if (tagName == "tr")
	{
	    tag.br = tagStart;
	    newLine = tagStart;
	} else if (tagName == "hr")
	{
	    newParagraph = true;
	    newLine = true;
	} else if (tagName == "ul")
	{
	    tag.ul = tagStart;
	} else if (tagName == "li")
	{
	    //newLine = true;
	    tag.li = tagStart;
	} else if (tagName == "ol")
	{
	    tag.ol = tagStart;
	} else if (tagName == "dl")
	{
	    tag.dl = tagStart;
	} else if (tagName == "pre")
	{
	    tag.pre = tagStart;
	    newLine = tagStart;
	} else if (tagName == "strong")
	{
	    tag.strong = tagStart;
	} else if (tagName == "i")
	{
	    tag.i = tagStart;
	} else if (tagName == "b")
	{
	    tag.b = tagStart;
	} else if (tagName == "tt")
	{
	    tag.tt = tagStart;
	} else if (tagName == "big")
	{
	    tag.big = tagStart;
	} else if (tagName == "small")
	{
	    tag.small = tagStart;
	} else if (tagName == "em")
	{
	    tag.em = tagStart;
	} else if (tagName == "dfn")
	{
	    tag.dfn = tagStart;
	} else if (tagName == "samp")
	{
	    tag.samp = tagStart;
	} else if (tagName == "kbd")
	{
	    tag.kbd = tagStart;
	} else if (tagName == "var")
	{
	    tag.var = tagStart;
	} else if (tagName == "cite")
	{
	    tag.cite = tagStart;
	} else if (tagName == "del")
	{
	    tag.del = tagStart;
	} else if ((tagName == "s") || (tagName == "strike"))
	{
	    tag.strike = tagStart;
	} else if (tagName == "u")
	{
	    tag.u = tagStart;
	} else if (tagName == "a")
	{
	    tag.a = tagStart;
	    tag.href="";
	    if (tagStringLc.find(QRegExp("filepos="),0)>-1)
	    {
		unsigned int i;
		i = tagStringLc.find(QRegExp("filepos="),0) + 8;
		while((i<tagString.length()) && (!tagString.at(i).isSpace()))
		{
		    tag.href.append(tagString.at(i++));
		}
		(tag.href.stripWhiteSpace());
		if (tag.href.at(0) == '\"') tag.href = tag.href.mid(1);
		if (tag.href.at(tag.href.length()-1) == '\"') tag.href= tag.href.left(tag.href.length()-1);
		tag.href = "#" + tag.href;
		//printf("href=\"");
		//printf(tag.href);
		//printf("\"\n");
	    }
	} else if (tagName == "link")
	{
	    tag.link = tagStart;
	} else if (tagName == "tag")
	{
	    tag.html = tagStart;
	} else if (tagName == "head")
	{
	    tag.head = tagStart;
	} else if (tagName == "title")
	{
	    tag.title = tagStart;
	} else if (tagName == "body")
	{
	    tag.body = tagStart;
	} else if (tagName == "div")
	{
	    tag.div = tagStart;
	    newLine = tagStart;
	} else if (tagName.find(QRegExp("^h[1-6]$")) > -1)
	{
	    //newParagraph = tagStart;
	    newLine = true;
	    if (tagStart)
	    {
		newParagraph = true;
		tag.h = int((7 - tagName.at(1).digitValue())/2+1);
	    } else {
		//newLine = true;
		tag.h = 0;
	    }
	} else if (tagName == "code")
	{
	    tag.code = tagStart;
	} else if (tagName == "img")
	{
	    tag.imgAlt = "";
	    tag.imgSrc = "";
	    int src;
	    int alt;
	    tag.img = tagStart;
	    src = tagStringLc.find(QRegExp("src="));
	    alt = tagStringLc.find(QRegExp("alt="));
	    if (alt>-1)
	    {
		alt += 4;
		while (1)
		{
		    if ((unsigned (alt)>=tagString.length()) || (tagString.at(alt).isSpace())) break;
		    tag.imgAlt.append(tagString.at(alt));
		    ++alt;
		}
		
	    }
	    if (src>-1)
	    {
		src += 4;
		while (1)
		{
		    if ((unsigned (src)>=tagString.length()) || (tagString.at(src).isSpace())) break;
		    tag.imgSrc.append(tagString.at(src));
		    ++src;
		}
	    }
	    (tag.imgSrc.stripWhiteSpace());
	    if (tag.imgSrc.at(0) == '\"') tag.imgSrc = tag.imgSrc.mid(1);
	    if (tag.imgSrc.at(tag.imgSrc.length()-1) == '\"') tag.imgSrc= tag.imgSrc.left(tag.imgSrc.length()-1);
	    (tag.imgAlt.stripWhiteSpace());
	    if (tag.imgAlt.at(0) == '\"') tag.imgAlt = tag.imgAlt.mid(1);
	    if (tag.imgAlt.at(tag.imgAlt.length()-1) == '\"') tag.imgAlt= tag.imgAlt.left(tag.imgAlt.length()-1);
	} else {
	}
	//printf("<");
	//printf(tagName);
	//printf(">");
	return QChar();	
    }
}

bool StreamPalmMP::openFile(const QString & filepath)
{
    char out_char[256],rim_char[256];
    plucker_file = new char[256];
    QString out_file,rim_file;
    QDir dir;
    out_file = "/tmp/justreader/palmdoc.tmp\0";
    rim_file = "/tmp/justreader/palmdoc.rim\0";
    strncpy(plucker_file,(filepath+"\0").latin1(),(filepath+"\0").length()+1);
    strncpy(out_char,out_file.latin1(),out_file.length()+1);
    strncpy(rim_char,rim_file.latin1(),rim_file.length()+1);
    //printf("%s\n%s\n%s\n",plucker_file,out_char,rim_char);
    //plucker_file[255] = 0;
    //out_char[255] = 0;
    //rim_file[255] = 0;
    QFile f;
    int docType;
    if ( !QFile::exists( filepath ) ) return false;
    f.setName( filepath ); 
    if (!f.open( IO_ReadOnly ))
    {
	return false;
    }
    fileOpened = true;
    f.close();
    if (file.isOpen()) file.close();
    dir = QDir::QDir("/tmp/justreader");
    dir.mkdir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }
    docType = Decomp(plucker_file,out_char,rim_char,reorderPlucker);
    if (docType == 0) return false; 
    file.setName( out_file ); 
    file.open( IO_ReadOnly );
    docSize = file.size();
    numberOfPages = int(docSize/2000) + 1;
    newParagraph = false;
    newLine = false;
    if (textstream) textstream->~QTextStream();
    textstream = new QTextStream(&file);
    resetTags();
    setEncoding(encoding);
    if (links) delete [] links;
    links = 0;
    linksFound = false;
    return true;
}

void StreamPalmMP::findLinks()
{
    if (linksFound) return;
    if (!textstream) return;
    //printf("Looking for links\n");
    int p;
    QChar ch;
    QString tag;
    linksCount = 0;
    tempLinks = new linksProps[500];
    p = getPosition();
    setPosition(0);
    while (!atEnd())
    {
	textstream->operator>>(ch);
	if (ch != '<') continue;
	tag = "";
	while (1)
	{
	    if (atEnd()) break;
	    textstream->operator>>(ch);
	    if (ch == '>')
	    {
		if (tag.lower().find(QRegExp("^a\\s+name\\s*=\\s*\".+\""))>-1)
		{
		    tempLinks[linksCount].position = getPosition();
		    tempLinks[linksCount].name = "";
		    for (unsigned int i = (tag.find(QRegExp("\"")) + 1); i<tag.length();i++)
		    {
			if ((ch = tag.at(i)) == '"') break;
			tempLinks[linksCount].name.append(ch);
		    }
		    ++linksCount;
		}
		break;
	    } else {
		tag.append(ch);
	    }
	}
    }
    if (linksCount>0)
    {
	if (links) delete [] links;
	links = new linksProps[linksCount];
	for (int i = 0; i<linksCount;i++)
	{
	    links[i] = tempLinks[i];
	    //printf("%4d: %7d ",i,links[i].position);
	    //printf(links[i].name);
	    //printf("\n");
	}
    }
    delete [] tempLinks;
    tempLinks = 0;
    linksFound = true;
    setPosition(p);
}

QString StreamPalmMP::findNextContent()
{
    int p;
    int page;
    QChar ch;
    QString tag;
    QString content,s;
    while(!atEnd())
    {
	textstream->operator>>(ch);
	if (ch != '<') continue;
	tag = "";
	while  (1)
	{
	    if (atEnd()) break;
	    textstream->operator>>(ch);
	    if (ch == '>')
	    {
		if (tag.lower().find(QRegExp("^a\\s+name\\s*=\\s*\".+\""))>-1)
		{
		    p = getPosition();
		    page = getPageNumber();
		    content = "";
		    for (int i=0;i<8;i++)
		    {
			s = readWordForward(true);
			//if (s == "") break;
			content += s + " ";
		    }
		    return content + "\n" + QString::number(page)+"\n"+QString::number(p)+"\n1\n";
		} else {
		    break;
		}
	    } else {
		tag.append(ch);
	    }
	}
    }
    return "";
}

int StreamPalmMP::getInLinkPosition(QString l)
{
    bool ok;
    int n;
    n = l.mid(1).toInt(&ok,10);
    if (ok) return n;
    return -1;
}
