/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: cfft_tab.h,v 1.15 2004/06/30 12:45:55 menno Exp $
**/

#ifndef __CFFT_TAB_H__
#define __CFFT_TAB_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef FIXED_POINT

ALIGN static const complex_t cfft_tab_512[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999924719333649), FRAC_CONST(0.012271538376808) },
    { FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628) },
    { FRAC_CONST(0.999322354793549), FRAC_CONST(0.036807224154472) },
    { FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352) },
    { FRAC_CONST(0.998118102550507), FRAC_CONST(0.061320740729570) },
    { FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848) },
    { FRAC_CONST(0.996312618255615), FRAC_CONST(0.085797317326069) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.993906974792480), FRAC_CONST(0.110222205519676) },
    { FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409) },
    { FRAC_CONST(0.990902662277222), FRAC_CONST(0.134580716490746) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.987301409244537), FRAC_CONST(0.158858150243759) },
    { FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525) },
    { FRAC_CONST(0.983105480670929), FRAC_CONST(0.183039888739586) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.978317379951477), FRAC_CONST(0.207111388444901) },
    { FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500) },
    { FRAC_CONST(0.972939968109131), FRAC_CONST(0.231058120727539) },
    { FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029) },
    { FRAC_CONST(0.966976463794708), FRAC_CONST(0.254865676164627) },
    { FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151) },
    { FRAC_CONST(0.960430502891541), FRAC_CONST(0.278519690036774) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.953306019306183), FRAC_CONST(0.302005946636200) },
    { FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639) },
    { FRAC_CONST(0.945607304573059), FRAC_CONST(0.325310319662094) },
    { FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221) },
    { FRAC_CONST(0.937339007854462), FRAC_CONST(0.348418682813644) },
    { FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(0.928506076335907), FRAC_CONST(0.371317207813263) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.919113874435425), FRAC_CONST(0.393992066383362) },
    { FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788) },
    { FRAC_CONST(0.909167945384979), FRAC_CONST(0.416429579257965) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.898674488067627), FRAC_CONST(0.438616245985031) },
    { FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813) },
    { FRAC_CONST(0.887639641761780), FRAC_CONST(0.460538715124130) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.876070082187653), FRAC_CONST(0.482183754444122) },
    { FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302) },
    { FRAC_CONST(0.863972842693329), FRAC_CONST(0.503538370132446) },
    { FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(0.851355195045471), FRAC_CONST(0.524589717388153) },
    { FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253) },
    { FRAC_CONST(0.838224709033966), FRAC_CONST(0.545324981212616) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.824589252471924), FRAC_CONST(0.565731823444366) },
    { FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225) },
    { FRAC_CONST(0.810457170009613), FRAC_CONST(0.585797905921936) },
    { FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734) },
    { FRAC_CONST(0.795836925506592), FRAC_CONST(0.605511009693146) },
    { FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340) },
    { FRAC_CONST(0.780737221240997), FRAC_CONST(0.624859511852264) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.765167236328125), FRAC_CONST(0.643831551074982) },
    { FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(0.749136388301849), FRAC_CONST(0.662415802478790) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.732654273509979), FRAC_CONST(0.680601000785828) },
    { FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886) },
    { FRAC_CONST(0.715730786323547), FRAC_CONST(0.698376297950745) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.698376238346100), FRAC_CONST(0.715730845928192) },
    { FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055) },
    { FRAC_CONST(0.680601000785828), FRAC_CONST(0.732654273509979) },
    { FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069) },
    { FRAC_CONST(0.662415742874146), FRAC_CONST(0.749136388301849) },
    { FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360) },
    { FRAC_CONST(0.643831551074982), FRAC_CONST(0.765167295932770) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.624859452247620), FRAC_CONST(0.780737280845642) },
    { FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668) },
    { FRAC_CONST(0.605511009693146), FRAC_CONST(0.795836925506592) },
    { FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(0.585797846317291), FRAC_CONST(0.810457170009613) },
    { FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(0.565731823444366), FRAC_CONST(0.824589312076569) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.545324981212616), FRAC_CONST(0.838224709033966) },
    { FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016) },
    { FRAC_CONST(0.524589657783508), FRAC_CONST(0.851355195045471) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.503538429737091), FRAC_CONST(0.863972842693329) },
    { FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099) },
    { FRAC_CONST(0.482183724641800), FRAC_CONST(0.876070141792297) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.460538715124130), FRAC_CONST(0.887639641761780) },
    { FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(0.438616186380386), FRAC_CONST(0.898674488067627) },
    { FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(0.416429549455643), FRAC_CONST(0.909168004989624) },
    { FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240) },
    { FRAC_CONST(0.393991947174072), FRAC_CONST(0.919113874435425) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.371317148208618), FRAC_CONST(0.928506076335907) },
    { FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375) },
    { FRAC_CONST(0.348418682813644), FRAC_CONST(0.937339007854462) },
    { FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(0.325310230255127), FRAC_CONST(0.945607364177704) },
    { FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674) },
    { FRAC_CONST(0.302005946636200), FRAC_CONST(0.953306019306183) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.278519600629807), FRAC_CONST(0.960430562496185) },
    { FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(0.254865646362305), FRAC_CONST(0.966976463794708) },
    { FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.231058135628700), FRAC_CONST(0.972939968109131) },
    { FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667) },
    { FRAC_CONST(0.207111328840256), FRAC_CONST(0.978317379951477) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.183039888739586), FRAC_CONST(0.983105480670929) },
    { FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(0.158858075737953), FRAC_CONST(0.987301409244537) },
    { FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(0.134580686688423), FRAC_CONST(0.990902662277222) },
    { FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399) },
    { FRAC_CONST(0.110222116112709), FRAC_CONST(0.993906974792480) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.085797272622585), FRAC_CONST(0.996312618255615) },
    { FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156) },
    { FRAC_CONST(0.061320748180151), FRAC_CONST(0.998118102550507) },
    { FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(0.036807164549828), FRAC_CONST(0.999322414398193) },
    { FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(0.012271529063582), FRAC_CONST(0.999924719333649) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.012271616607904), FRAC_CONST(0.999924719333649) },
    { FRAC_CONST(-0.024541223421693), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(-0.036807250231504), FRAC_CONST(0.999322354793549) },
    { FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.061320833861828), FRAC_CONST(0.998118102550507) },
    { FRAC_CONST(-0.073564574122429), FRAC_CONST(0.997290432453156) },
    { FRAC_CONST(-0.085797362029552), FRAC_CONST(0.996312618255615) },
    { FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.110222205519676), FRAC_CONST(0.993906974792480) },
    { FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755) },
    { FRAC_CONST(-0.134580776095390), FRAC_CONST(0.990902602672577) },
    { FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(-0.158858165144920), FRAC_CONST(0.987301409244537) },
    { FRAC_CONST(-0.170961946249008), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(-0.183039978146553), FRAC_CONST(0.983105480670929) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.207111418247223), FRAC_CONST(0.978317379951477) },
    { FRAC_CONST(-0.219101309776306), FRAC_CONST(0.975702106952667) },
    { FRAC_CONST(-0.231058210134506), FRAC_CONST(0.972939908504486) },
    { FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(-0.254865705966949), FRAC_CONST(0.966976463794708) },
    { FRAC_CONST(-0.266712844371796), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(-0.278519690036774), FRAC_CONST(0.960430502891541) },
    { FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073) },
    { FRAC_CONST(-0.302006036043167), FRAC_CONST(0.953306019306183) },
    { FRAC_CONST(-0.313681721687317), FRAC_CONST(0.949528157711029) },
    { FRAC_CONST(-0.325310319662094), FRAC_CONST(0.945607304573059) },
    { FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(-0.348418772220612), FRAC_CONST(0.937338948249817) },
    { FRAC_CONST(-0.359895050525665), FRAC_CONST(0.932992815971375) },
    { FRAC_CONST(-0.371317237615585), FRAC_CONST(0.928506076335907) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.393992036581039), FRAC_CONST(0.919113874435425) },
    { FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595) },
    { FRAC_CONST(-0.416429519653320), FRAC_CONST(0.909168004989624) },
    { FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(-0.438616245985031), FRAC_CONST(0.898674428462982) },
    { FRAC_CONST(-0.449611365795136), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(-0.460538804531097), FRAC_CONST(0.887639582157135) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.482183903455734), FRAC_CONST(0.876070022583008) },
    { FRAC_CONST(-0.492898166179657), FRAC_CONST(0.870087027549744) },
    { FRAC_CONST(-0.503538370132446), FRAC_CONST(0.863972842693329) },
    { FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014) },
    { FRAC_CONST(-0.524589717388153), FRAC_CONST(0.851355135440826) },
    { FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372) },
    { FRAC_CONST(-0.545325100421906), FRAC_CONST(0.838224649429321) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.565731763839722), FRAC_CONST(0.824589312076569) },
    { FRAC_CONST(-0.575808167457581), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(-0.585797905921936), FRAC_CONST(0.810457170009613) },
    { FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(-0.605511128902435), FRAC_CONST(0.795836865901947) },
    { FRAC_CONST(-0.615231692790985), FRAC_CONST(0.788346350193024) },
    { FRAC_CONST(-0.624859631061554), FRAC_CONST(0.780737102031708) },
    { FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829) },
    { FRAC_CONST(-0.643831551074982), FRAC_CONST(0.765167236328125) },
    { FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715) },
    { FRAC_CONST(-0.662415802478790), FRAC_CONST(0.749136328697205) },
    { FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779) },
    { FRAC_CONST(-0.680601119995117), FRAC_CONST(0.732654154300690) },
    { FRAC_CONST(-0.689540684223175), FRAC_CONST(0.724246978759766) },
    { FRAC_CONST(-0.698376238346100), FRAC_CONST(0.715730845928192) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.715730845928192), FRAC_CONST(0.698376238346100) },
    { FRAC_CONST(-0.724247157573700), FRAC_CONST(0.689540505409241) },
    { FRAC_CONST(-0.732654333114624), FRAC_CONST(0.680600941181183) },
    { FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111) },
    { FRAC_CONST(-0.749136507511139), FRAC_CONST(0.662415623664856) },
    { FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(-0.765167295932770), FRAC_CONST(0.643831551074982) },
    { FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088) },
    { FRAC_CONST(-0.780737280845642), FRAC_CONST(0.624859452247620) },
    { FRAC_CONST(-0.788346469402313), FRAC_CONST(0.615231513977051) },
    { FRAC_CONST(-0.795836985111237), FRAC_CONST(0.605510950088501) },
    { FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800) },
    { FRAC_CONST(-0.810457170009613), FRAC_CONST(0.585797846317291) },
    { FRAC_CONST(-0.817584812641144), FRAC_CONST(0.575808167457581) },
    { FRAC_CONST(-0.824589312076569), FRAC_CONST(0.565731763839722) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.838224768638611), FRAC_CONST(0.545324862003326) },
    { FRAC_CONST(-0.844853639602661), FRAC_CONST(0.534997463226318) },
    { FRAC_CONST(-0.851355314254761), FRAC_CONST(0.524589538574219) },
    { FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(-0.863972842693329), FRAC_CONST(0.503538370132446) },
    { FRAC_CONST(-0.870087027549744), FRAC_CONST(0.492898136377335) },
    { FRAC_CONST(-0.876070141792297), FRAC_CONST(0.482183694839478) },
    { FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962) },
    { FRAC_CONST(-0.887639701366425), FRAC_CONST(0.460538566112518) },
    { FRAC_CONST(-0.893224298954010), FRAC_CONST(0.449611365795136) },
    { FRAC_CONST(-0.898674488067627), FRAC_CONST(0.438616245985031) },
    { FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193) },
    { FRAC_CONST(-0.909168004989624), FRAC_CONST(0.416429489850998) },
    { FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499) },
    { FRAC_CONST(-0.919113874435425), FRAC_CONST(0.393991917371750) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.928506076335907), FRAC_CONST(0.371317237615585) },
    { FRAC_CONST(-0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(-0.937339007854462), FRAC_CONST(0.348418653011322) },
    { FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576) },
    { FRAC_CONST(-0.945607364177704), FRAC_CONST(0.325310200452805) },
    { FRAC_CONST(-0.949528217315674), FRAC_CONST(0.313681602478027) },
    { FRAC_CONST(-0.953306078910828), FRAC_CONST(0.302005797624588) },
    { FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442) },
    { FRAC_CONST(-0.960430502891541), FRAC_CONST(0.278519690036774) },
    { FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506) },
    { FRAC_CONST(-0.966976463794708), FRAC_CONST(0.254865586757660) },
    { FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740) },
    { FRAC_CONST(-0.972939968109131), FRAC_CONST(0.231057971715927) },
    { FRAC_CONST(-0.975702166557312), FRAC_CONST(0.219101071357727) },
    { FRAC_CONST(-0.978317379951477), FRAC_CONST(0.207111403346062) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.983105480670929), FRAC_CONST(0.183039844036102) },
    { FRAC_CONST(-0.985277652740479), FRAC_CONST(0.170961812138557) },
    { FRAC_CONST(-0.987301409244537), FRAC_CONST(0.158858031034470) },
    { FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666) },
    { FRAC_CONST(-0.990902662277222), FRAC_CONST(0.134580522775650) },
    { FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151) },
    { FRAC_CONST(-0.993906974792480), FRAC_CONST(0.110222198069096) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470) },
    { FRAC_CONST(-0.996312618255615), FRAC_CONST(0.085797227919102) },
    { FRAC_CONST(-0.997290492057800), FRAC_CONST(0.073564447462559) },
    { FRAC_CONST(-0.998118102550507), FRAC_CONST(0.061320584267378) },
    { FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547) },
    { FRAC_CONST(-0.999322354793549), FRAC_CONST(0.036807239055634) },
    { FRAC_CONST(-0.999698817729950), FRAC_CONST(0.024541210383177) },
    { FRAC_CONST(-0.999924719333649), FRAC_CONST(0.012271485291421) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628) },
    { FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352) },
    { FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500) },
    { FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029) },
    { FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639) },
    { FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221) },
    { FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302) },
    { FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225) },
    { FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734) },
    { FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055) },
    { FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069) },
    { FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668) },
    { FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375) },
    { FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156) },
    { FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073) },
    { FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829) },
    { FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111) },
    { FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088) },
    { FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962) },
    { FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576) },
    { FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442) },
    { FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470) },
    { FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.788346469402313), FRAC_CONST(0.615231573581696) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.575808227062225), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.313681751489639), FRAC_CONST(0.949528157711029) },
    { FRAC_CONST(0.242980241775513), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.024541255086660), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.266712725162506), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(-0.336889803409576), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372) },
    { FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(-0.803207516670227), FRAC_CONST(0.595699369907379) },
    { FRAC_CONST(-0.844853520393372), FRAC_CONST(0.534997701644897) },
    { FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218) },
    { FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499) },
    { FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576) },
    { FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151) },
    { FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067724496126) },
    { FRAC_CONST(-0.999698817729950), FRAC_CONST(-0.024541147053242) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824) },
    { FRAC_CONST(-0.985277652740479), FRAC_CONST(-0.170961990952492) },
    { FRAC_CONST(-0.970031261444092), FRAC_CONST(-0.242980241775513) },
    { FRAC_CONST(-0.949528157711029), FRAC_CONST(-0.313681781291962) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.893224298954010), FRAC_CONST(-0.449611306190491) },
    { FRAC_CONST(-0.857728660106659), FRAC_CONST(-0.514102697372437) },
    { FRAC_CONST(-0.817584872245789), FRAC_CONST(-0.575808107852936) },
    { FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443) },
    { FRAC_CONST(-0.724247038364410), FRAC_CONST(-0.689540624618530) },
    { FRAC_CONST(-0.671558916568756), FRAC_CONST(-0.740951180458069) },
    { FRAC_CONST(-0.615231573581696), FRAC_CONST(-0.788346469402313) },
    { FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216) },
    { FRAC_CONST(-0.492898195981979), FRAC_CONST(-0.870086967945099) },
    { FRAC_CONST(-0.427554935216904), FRAC_CONST(-0.903989374637604) },
    { FRAC_CONST(-0.359895110130310), FRAC_CONST(-0.932992756366730) },
    { FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718) },
    { FRAC_CONST(-0.219101369380951), FRAC_CONST(-0.975702106952667) },
    { FRAC_CONST(-0.146730408072472), FRAC_CONST(-0.989176511764526) },
    { FRAC_CONST(-0.073564760386944), FRAC_CONST(-0.997290432453156) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443) },
    { FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216) },
    { FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000) }
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const complex_t cfft_tab_480[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999914348125458), FRAC_CONST(0.013089596293867) },
    { FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974) },
    { FRAC_CONST(0.999229013919830), FRAC_CONST(0.039259817451239) },
    { FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870) },
    { FRAC_CONST(0.997858941555023), FRAC_CONST(0.065403133630753) },
    { FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127) },
    { FRAC_CONST(0.995804905891418), FRAC_CONST(0.091501623392105) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.993068456649780), FRAC_CONST(0.117537401616573) },
    { FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867) },
    { FRAC_CONST(0.989651381969452), FRAC_CONST(0.143492624163628) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.985556066036224), FRAC_CONST(0.169349506497383) },
    { FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.975342333316803), FRAC_CONST(0.220697447657585) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.969230890274048), FRAC_CONST(0.246153295040131) },
    { FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322) },
    { FRAC_CONST(0.962455213069916), FRAC_CONST(0.271440446376801) },
    { FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354) },
    { FRAC_CONST(0.955019950866699), FRAC_CONST(0.296541601419449) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.946930110454559), FRAC_CONST(0.321439445018768) },
    { FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859) },
    { FRAC_CONST(0.938191354274750), FRAC_CONST(0.346117079257965) },
    { FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197) },
    { FRAC_CONST(0.928809583187103), FRAC_CONST(0.370557427406311) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.918791174888611), FRAC_CONST(0.394743889570236) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.908143162727356), FRAC_CONST(0.418659746646881) },
    { FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506) },
    { FRAC_CONST(0.896872758865356), FRAC_CONST(0.442288726568222) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.884987652301788), FRAC_CONST(0.465614527463913) },
    { FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333) },
    { FRAC_CONST(0.872496008872986), FRAC_CONST(0.488621264696121) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.859406411647797), FRAC_CONST(0.511293113231659) },
    { FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853) },
    { FRAC_CONST(0.845727801322937), FRAC_CONST(0.533614516258240) },
    { FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000) },
    { FRAC_CONST(0.816641509532928), FRAC_CONST(0.577145218849182) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.801253795623779), FRAC_CONST(0.598324596881866) },
    { FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682) },
    { FRAC_CONST(0.785316884517670), FRAC_CONST(0.619093954563141) },
    { FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899) },
    { FRAC_CONST(0.768841803073883), FRAC_CONST(0.639438986778259) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.751839756965637), FRAC_CONST(0.659345865249634) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.734322488307953), FRAC_CONST(0.678800761699677) },
    { FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145) },
    { FRAC_CONST(0.716301918029785), FRAC_CONST(0.697790503501892) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.697790443897247), FRAC_CONST(0.716301977634430) },
    { FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692) },
    { FRAC_CONST(0.678800702095032), FRAC_CONST(0.734322547912598) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.659345805644989), FRAC_CONST(0.751839816570282) },
    { FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(0.639438986778259), FRAC_CONST(0.768841862678528) },
    { FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635) },
    { FRAC_CONST(0.619093954563141), FRAC_CONST(0.785316944122314) },
    { FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736) },
    { FRAC_CONST(0.598324596881866), FRAC_CONST(0.801253855228424) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.577145159244537), FRAC_CONST(0.816641569137573) },
    { FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531) },
    { FRAC_CONST(0.533614516258240), FRAC_CONST(0.845727801322937) },
    { FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184) },
    { FRAC_CONST(0.511293113231659), FRAC_CONST(0.859406411647797) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.488621175289154), FRAC_CONST(0.872496068477631) },
    { FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(0.465614467859268), FRAC_CONST(0.884987652301788) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.442288666963577), FRAC_CONST(0.896872758865356) },
    { FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275) },
    { FRAC_CONST(0.418659746646881), FRAC_CONST(0.908143162727356) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.394743800163269), FRAC_CONST(0.918791234493256) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.370557397603989), FRAC_CONST(0.928809583187103) },
    { FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(0.346117049455643), FRAC_CONST(0.938191354274750) },
    { FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(0.321439474821091), FRAC_CONST(0.946930110454559) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.296541512012482), FRAC_CONST(0.955019950866699) },
    { FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130) },
    { FRAC_CONST(0.271440386772156), FRAC_CONST(0.962455272674561) },
    { FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(0.246153265237808), FRAC_CONST(0.969230890274048) },
    { FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(0.220697447657585), FRAC_CONST(0.975342333316803) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(0.169349446892738), FRAC_CONST(0.985556066036224) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.143492594361305), FRAC_CONST(0.989651381969452) },
    { FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(0.117537401616573), FRAC_CONST(0.993068456649780) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(0.091501533985138), FRAC_CONST(0.995804905891418) },
    { FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(0.065403074026108), FRAC_CONST(0.997858941555023) },
    { FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(0.039259787648916), FRAC_CONST(0.999229013919830) },
    { FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(0.013089597225189), FRAC_CONST(0.999914348125458) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.013089684769511), FRAC_CONST(0.999914348125458) },
    { FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(-0.039259877055883), FRAC_CONST(0.999229013919830) },
    { FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.065403163433075), FRAC_CONST(0.997858941555023) },
    { FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(-0.091501623392105), FRAC_CONST(0.995804905891418) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.117537491023541), FRAC_CONST(0.993068456649780) },
    { FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(-0.143492683768272), FRAC_CONST(0.989651381969452) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.169349536299706), FRAC_CONST(0.985556066036224) },
    { FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.220697522163391), FRAC_CONST(0.975342273712158) },
    { FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(-0.246153354644775), FRAC_CONST(0.969230890274048) },
    { FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(-0.271440476179123), FRAC_CONST(0.962455213069916) },
    { FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486) },
    { FRAC_CONST(-0.296541571617126), FRAC_CONST(0.955019950866699) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.321439564228058), FRAC_CONST(0.946930110454559) },
    { FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(-0.346117109060287), FRAC_CONST(0.938191294670105) },
    { FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(-0.370557487010956), FRAC_CONST(0.928809523582459) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.394743859767914), FRAC_CONST(0.918791234493256) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(-0.418659836053848), FRAC_CONST(0.908143103122711) },
    { FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630) },
    { FRAC_CONST(-0.442288637161255), FRAC_CONST(0.896872758865356) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.465614557266235), FRAC_CONST(0.884987592697144) },
    { FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(-0.488621354103088), FRAC_CONST(0.872495949268341) },
    { FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814) },
    { FRAC_CONST(-0.511293053627014), FRAC_CONST(0.859406411647797) },
    { FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894) },
    { FRAC_CONST(-0.533614575862885), FRAC_CONST(0.845727801322937) },
    { FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.566406309604645), FRAC_CONST(0.824126124382019) },
    { FRAC_CONST(-0.577145218849182), FRAC_CONST(0.816641569137573) },
    { FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.598324656486511), FRAC_CONST(0.801253736019135) },
    { FRAC_CONST(-0.608761429786682), FRAC_CONST(0.793353319168091) },
    { FRAC_CONST(-0.619093894958496), FRAC_CONST(0.785316944122314) },
    { FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346) },
    { FRAC_CONST(-0.639439046382904), FRAC_CONST(0.768841803073883) },
    { FRAC_CONST(-0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(-0.659345924854279), FRAC_CONST(0.751839697360992) },
    { FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738) },
    { FRAC_CONST(-0.678800761699677), FRAC_CONST(0.734322488307953) },
    { FRAC_CONST(-0.688354671001434), FRAC_CONST(0.725374281406403) },
    { FRAC_CONST(-0.697790503501892), FRAC_CONST(0.716301858425140) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.716302037239075), FRAC_CONST(0.697790324687958) },
    { FRAC_CONST(-0.725374460220337), FRAC_CONST(0.688354492187500) },
    { FRAC_CONST(-0.734322547912598), FRAC_CONST(0.678800702095032) },
    { FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672) },
    { FRAC_CONST(-0.751839876174927), FRAC_CONST(0.659345746040344) },
    { FRAC_CONST(-0.760406017303467), FRAC_CONST(0.649448037147522) },
    { FRAC_CONST(-0.768841803073883), FRAC_CONST(0.639439046382904) },
    { FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610) },
    { FRAC_CONST(-0.785316944122314), FRAC_CONST(0.619093894958496) },
    { FRAC_CONST(-0.793353319168091), FRAC_CONST(0.608761429786682) },
    { FRAC_CONST(-0.801253914833069), FRAC_CONST(0.598324477672577) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.816641569137573), FRAC_CONST(0.577145218849182) },
    { FRAC_CONST(-0.824126303195953), FRAC_CONST(0.566406130790710) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(-0.845727920532227), FRAC_CONST(0.533614337444305) },
    { FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209) },
    { FRAC_CONST(-0.859406411647797), FRAC_CONST(0.511293053627014) },
    { FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645) },
    { FRAC_CONST(-0.872496068477631), FRAC_CONST(0.488621145486832) },
    { FRAC_CONST(-0.878817141056061), FRAC_CONST(0.477158725261688) },
    { FRAC_CONST(-0.884987652301788), FRAC_CONST(0.465614557266235) },
    { FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172) },
    { FRAC_CONST(-0.896872758865356), FRAC_CONST(0.442288637161255) },
    { FRAC_CONST(-0.902585268020630), FRAC_CONST(0.430511116981506) },
    { FRAC_CONST(-0.908143222332001), FRAC_CONST(0.418659597635269) },
    { FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624) },
    { FRAC_CONST(-0.918791234493256), FRAC_CONST(0.394743859767914) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.928809583187103), FRAC_CONST(0.370557337999344) },
    { FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875) },
    { FRAC_CONST(-0.938191413879395), FRAC_CONST(0.346116900444031) },
    { FRAC_CONST(-0.942641556262970), FRAC_CONST(0.333806753158569) },
    { FRAC_CONST(-0.946930170059204), FRAC_CONST(0.321439445018768) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.955020010471344), FRAC_CONST(0.296541452407837) },
    { FRAC_CONST(-0.958819746971130), FRAC_CONST(0.284015297889709) },
    { FRAC_CONST(-0.962455213069916), FRAC_CONST(0.271440476179123) },
    { FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032) },
    { FRAC_CONST(-0.969230949878693), FRAC_CONST(0.246153235435486) },
    { FRAC_CONST(-0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(-0.975342333316803), FRAC_CONST(0.220697283744812) },
    { FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.983254909515381), FRAC_CONST(0.182235360145569) },
    { FRAC_CONST(-0.985556066036224), FRAC_CONST(0.169349402189255) },
    { FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257) },
    { FRAC_CONST(-0.989651441574097), FRAC_CONST(0.143492430448532) },
    { FRAC_CONST(-0.991444885730743), FRAC_CONST(0.130526080727577) },
    { FRAC_CONST(-0.993068456649780), FRAC_CONST(0.117537356913090) },
    { FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249) },
    { FRAC_CONST(-0.995804965496063), FRAC_CONST(0.091501489281654) },
    { FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482) },
    { FRAC_CONST(-0.997858941555023), FRAC_CONST(0.065403148531914) },
    { FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258) },
    { FRAC_CONST(-0.999229013919830), FRAC_CONST(0.039259742945433) },
    { FRAC_CONST(-0.999657332897186), FRAC_CONST(0.026176951825619) },
    { FRAC_CONST(-0.999914348125458), FRAC_CONST(0.013089434243739) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974) },
    { FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870) },
    { FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322) },
    { FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859) },
    { FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853) },
    { FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682) },
    { FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635) },
    { FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664) },
    { FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531) },
    { FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130) },
    { FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814) },
    { FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886) },
    { FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346) },
    { FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672) },
    { FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645) },
    { FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172) },
    { FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624) },
    { FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032) },
    { FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333) },
    { FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257) },
    { FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249) },
    { FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258) },
    { FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777) },
    { FRAC_CONST(-0.998629510402679), FRAC_CONST(-0.052335985004902) },
    { FRAC_CONST(-0.994521856307983), FRAC_CONST(-0.104528672993183) },
    { FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031) },
    { FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267) },
    { FRAC_CONST(-0.965925812721252), FRAC_CONST(-0.258819073438644) },
    { FRAC_CONST(-0.951056540012360), FRAC_CONST(-0.309016972780228) },
    { FRAC_CONST(-0.933580398559570), FRAC_CONST(-0.358368098735809) },
    { FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236) },
    { FRAC_CONST(-0.891006529331207), FRAC_CONST(-0.453990548849106) },
    { FRAC_CONST(-0.866025269031525), FRAC_CONST(-0.500000178813934) },
    { FRAC_CONST(-0.838670492172241), FRAC_CONST(-0.544639170169830) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(-0.777145922183990), FRAC_CONST(-0.629320442676544) },
    { FRAC_CONST(-0.743144810199738), FRAC_CONST(-0.669130623340607) },
    { FRAC_CONST(-0.707106649875641), FRAC_CONST(-0.707106888294220) },
    { FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382) },
    { FRAC_CONST(-0.629320323467255), FRAC_CONST(-0.777145981788635) },
    { FRAC_CONST(-0.587785065174103), FRAC_CONST(-0.809017121791840) },
    { FRAC_CONST(-0.544639110565186), FRAC_CONST(-0.838670551776886) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482) },
    { FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(-0.649447917938232), FRAC_CONST(-0.760406076908112) },
    { FRAC_CONST(-0.453990221023560), FRAC_CONST(-0.891006648540497) },
    { FRAC_CONST(-0.233445450663567), FRAC_CONST(-0.972369909286499) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715) }
};
#endif

ALIGN static const complex_t cfft_tab_64[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443) },
    { FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216) },
    { FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000) }
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const complex_t cfft_tab_60[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814) },
    { FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624) },
    { FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333) },
    { FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777) },
    { FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267) },
    { FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715) }
};
#endif

#ifdef LD_DEC

ALIGN static const complex_t cfft_tab_256[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628) },
    { FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352) },
    { FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500) },
    { FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029) },
    { FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639) },
    { FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221) },
    { FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302) },
    { FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225) },
    { FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734) },
    { FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055) },
    { FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069) },
    { FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668) },
    { FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375) },
    { FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156) },
    { FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073) },
    { FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829) },
    { FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111) },
    { FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088) },
    { FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081) },
    { FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962) },
    { FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576) },
    { FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442) },
    { FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470) },
    { FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848) },
    { FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116) },
    { FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665) },
    { FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516) },
    { FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.788346469402313), FRAC_CONST(0.615231573581696) },
    { FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401) },
    { FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.575808227062225), FRAC_CONST(0.817584812641144) },
    { FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659) },
    { FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.313681751489639), FRAC_CONST(0.949528157711029) },
    { FRAC_CONST(0.242980241775513), FRAC_CONST(0.970031261444092) },
    { FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(0.024541255086660), FRAC_CONST(0.999698817729950) },
    { FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734) },
    { FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.266712725162506), FRAC_CONST(0.963776051998138) },
    { FRAC_CONST(-0.336889803409576), FRAC_CONST(0.941544055938721) },
    { FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372) },
    { FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227) },
    { FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826) },
    { FRAC_CONST(-0.803207516670227), FRAC_CONST(0.595699369907379) },
    { FRAC_CONST(-0.844853520393372), FRAC_CONST(0.534997701644897) },
    { FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218) },
    { FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499) },
    { FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576) },
    { FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151) },
    { FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067724496126) },
    { FRAC_CONST(-0.999698817729950), FRAC_CONST(-0.024541147053242) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824) },
    { FRAC_CONST(-0.985277652740479), FRAC_CONST(-0.170961990952492) },
    { FRAC_CONST(-0.970031261444092), FRAC_CONST(-0.242980241775513) },
    { FRAC_CONST(-0.949528157711029), FRAC_CONST(-0.313681781291962) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.893224298954010), FRAC_CONST(-0.449611306190491) },
    { FRAC_CONST(-0.857728660106659), FRAC_CONST(-0.514102697372437) },
    { FRAC_CONST(-0.817584872245789), FRAC_CONST(-0.575808107852936) },
    { FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443) },
    { FRAC_CONST(-0.724247038364410), FRAC_CONST(-0.689540624618530) },
    { FRAC_CONST(-0.671558916568756), FRAC_CONST(-0.740951180458069) },
    { FRAC_CONST(-0.615231573581696), FRAC_CONST(-0.788346469402313) },
    { FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216) },
    { FRAC_CONST(-0.492898195981979), FRAC_CONST(-0.870086967945099) },
    { FRAC_CONST(-0.427554935216904), FRAC_CONST(-0.903989374637604) },
    { FRAC_CONST(-0.359895110130310), FRAC_CONST(-0.932992756366730) },
    { FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718) },
    { FRAC_CONST(-0.219101369380951), FRAC_CONST(-0.975702106952667) },
    { FRAC_CONST(-0.146730408072472), FRAC_CONST(-0.989176511764526) },
    { FRAC_CONST(-0.073564760386944), FRAC_CONST(-0.997290432453156) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479) },
    { FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797) },
    { FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124) },
    { FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531) },
    { FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757) },
    { FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218) },
    { FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439) },
    { FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443) },
    { FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216) },
    { FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000) }
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const complex_t cfft_tab_240[] =
{
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974) },
    { FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870) },
    { FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322) },
    { FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859) },
    { FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853) },
    { FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682) },
    { FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635) },
    { FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664) },
    { FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531) },
    { FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130) },
    { FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186) },
    { FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325) },
    { FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870) },
    { FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300) },
    { FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197) },
    { FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000) },
    { FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899) },
    { FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382) },
    { FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531) },
    { FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218) },
    { FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679) },
    { FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512) },
    { FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215) },
    { FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814) },
    { FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886) },
    { FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346) },
    { FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672) },
    { FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541) },
    { FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645) },
    { FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172) },
    { FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624) },
    { FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032) },
    { FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333) },
    { FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257) },
    { FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249) },
    { FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258) },
    { FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777) },
    { FRAC_CONST(-0.998629510402679), FRAC_CONST(-0.052335985004902) },
    { FRAC_CONST(-0.994521856307983), FRAC_CONST(-0.104528672993183) },
    { FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031) },
    { FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267) },
    { FRAC_CONST(-0.965925812721252), FRAC_CONST(-0.258819073438644) },
    { FRAC_CONST(-0.951056540012360), FRAC_CONST(-0.309016972780228) },
    { FRAC_CONST(-0.933580398559570), FRAC_CONST(-0.358368098735809) },
    { FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236) },
    { FRAC_CONST(-0.891006529331207), FRAC_CONST(-0.453990548849106) },
    { FRAC_CONST(-0.866025269031525), FRAC_CONST(-0.500000178813934) },
    { FRAC_CONST(-0.838670492172241), FRAC_CONST(-0.544639170169830) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(-0.777145922183990), FRAC_CONST(-0.629320442676544) },
    { FRAC_CONST(-0.743144810199738), FRAC_CONST(-0.669130623340607) },
    { FRAC_CONST(-0.707106649875641), FRAC_CONST(-0.707106888294220) },
    { FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382) },
    { FRAC_CONST(-0.629320323467255), FRAC_CONST(-0.777145981788635) },
    { FRAC_CONST(-0.587785065174103), FRAC_CONST(-0.809017121791840) },
    { FRAC_CONST(-0.544639110565186), FRAC_CONST(-0.838670551776886) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000) },
    { FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563) },
    { FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761) },
    { FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783) },
    { FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796) },
    { FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419) },
    { FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894) },
    { FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930) },
    { FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482) },
    { FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031) },
    { FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(-0.649447917938232), FRAC_CONST(-0.760406076908112) },
    { FRAC_CONST(-0.453990221023560), FRAC_CONST(-0.891006648540497) },
    { FRAC_CONST(-0.233445450663567), FRAC_CONST(-0.972369909286499) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037) },
    { FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550) },
    { FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715) },
    { FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293) },
    { FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000) },
    { FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715) }
};
#endif

#endif

#endif

#ifdef __cplusplus
}
#endif
#endif
