.\"
.\" $XFree86: xc/lib/Xft/Xft.man,v 1.6 2003/06/12 14:12:27 eich Exp $
.\"
.\" Copyright 2000 Keith Packard, member of The XFree86 Project, Inc..\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XFT 3 "Version 2.0" "XFree86"

.SH NAME
 Xft \- X FreeType interface library

.SH DESCRIPTION
.B Xft
is a simple library designed to interface the FreeType rasterizer with the X
Rendering Extension.  This manual page barely scratches the surface of this
library.

.SH DATATYPES

.B XftFont
contains general font metrics and a pointer to either the core XFontStruct
data or a structure holding FreeType and X Render Extension data.

.B XftDraw
is an opaque object which holds information used to render to an X drawable
using either core protocol or the X Rendering extension.

.B XftColor
contains a pixel value and the ARGB values associated with it. 

.SH FUNCTIONS
.nf
XftFont *
XftFontOpen (Display *dpy, int screen, ...);
.fi
.B XftFontOpen
takes a list of pattern elements of the form (field, type, value) terminated
with a 0, matches that pattern against the available fonts and opens the
matching font.
.PP
Example:
.br
	font = XftFontOpen (dpy, scr,
			    XFT_FAMILY, XftTypeString, "charter",
			    XFT_SIZE, XftTypeDouble, 12.0);
.PP
This opens the charter font at 12 points.  The point size is automatically
converted to the correct pixel size based on the resolution of the monitor.
.PP
.nf
void
XftTextExtents8 (Display	*dpy,
		 XftFont	*font,
		 FcChar8  	*string, 
		 int		len,
		 XGlyphInfo	*extents);
.fi
.B XftTextExtents8
computes the pixel extents of "string" when drawn with "font".
.PP
.nf
XftDraw *
XftDrawCreate (Display   *dpy,
	       Drawable  drawable,
	       Visual    *visual,
	       Colormap  colormap);
.fi
.B XtDrawCreate
creates a structure that can be used to render text and rectangles
to the screen.
.PP
.nf
void
XftDrawString8 (XftDraw		*d,
		XftColor	*color,
		XftFont		*font,
		int		x, 
		int		y,
		FcChar8		*string,
		int		len);
.fi
.B XftDrawString8
draws "string" using "font" in "color" at "x, y".
.PP
.nf
void
XftDrawRect (XftDraw	    *d,
	     XftColor	    *color,
	     int	    x, 
	     int	    y,
	     unsigned int   width,
	     unsigned int   height);
.fi
.B XftDrawRect
fills a solid rectangle in the specified color.
.PP
.nf
Bool
XftColorAllocName (Display  *dpy,
		   Visual   *visual,
		   Colormap cmap,
		   char	    *name,
		   XftColor *result);
.fi
.B XftColorAllocName 
allocates a 
.I XftColor
structure. It asks the X server to allocate a pixel and return the associated
RGB values wich are used to construct an 
.I XRenderColor .
This requires a round trip (bad).
.PP
.nf
Bool
XftColorAllocValue (Display	    *dpy,
		    Visual	    *visual,
		    Colormap	    cmap,
		    XRenderColor    *color,
		    XftColor	    *result);
.fi
For TrueColor visuals, 
.I XftColorAllocValue 
computes the nearest supported ARGB value and the associated pixel
value and stores them in the result.  No round trip is required.  For
non-TrueColor visuals,
.I XftColorAllocValue 
asks the X server to allocate the specified color and stores the
resulting pixel and ARGB values into result.
.PP
.nf
void
XftColorFree (Display	*dpy,
	      Visual	*visual,
	      Colormap	cmap,
	      XftColor	*color);

.fi
.B XftColorFree 
frees a color when it is no longer in use. 
.SH CONFIGURATION
The 
.B Xft 
version 2 library uses 
.IR fontconfig (3) 
for its configuration. The 
.B XftConfig
files are not used anymore. 
.SH COMPATIBILITY
As of version 2, 
.B Xft
has become relatively stable and is expected to retain source and binary
compatibility in future releases.
.SH "SEE ALSO"
fonttconfig(3)
.br
__projectroot__/lib/X11/doc/README.fonts
.SH AUTHOR
Keith Packard, member of the XFree86 Project, Inc.
