#undef		DEBUG

#include	"cfxga.h"
#include	<syslog.h>
#include	<error.h>
#include	<string.h>
#include	<linux/fb.h>
#include	<sys/ioctl.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<stdio.h>

extern int	errno ;

//static unsigned char	MirrorBuf[ 640*480*(16/8) ] ;	// Max Buffer Size of Screen, 640x480 16bpp

void MsgPrint( int, char * ) ;
int isRotate( void ) ;


/*********************
	Class [SysInfo]
*********************/
class SysInfo {
  public :
	SysInfo() ;
	~SysInfo() ;
	int		pid ;
	int		nFB0Handle ;		// FB0 file descriptor
	int		nRotate ;			// Is Frame Buffer need rotate?
	int		nCFXGAHandle ;		// CFXGA file descriptor
	unsigned long	SrcAdr ;	// Address of Frame Buffer to set CFXGA
	unsigned long	BufLen ;	// Buffer Length to set CFXGA
} ;


/* Constructor of  Class : SysInfo */
SysInfo::SysInfo()
{
	int		nFB0Handle = 0 ;
	struct fb_fix_screeninfo	fix ;

	nRotate = isRotate() ;		// 1: Width > Height, 0: Height > Width
	nCFXGAHandle = 0 ;
	nFB0Handle = open( "/dev/fb0", O_RDONLY ) ;
	if ( nFB0Handle == 0 ) {		// can you access FB0
	    MsgPrint( LOG_INFO, "<<Info:FB0>> %s\n" ) ;
//	    SrcAdr = (unsigned long)MirrorBuf ;
		BufLen = 0 ;
	} else {
	    fix.smem_start = 0 ;
	    if ( ioctl( nFB0Handle, FBIOGET_FSCREENINFO, &fix) < 0 ) {
			MsgPrint( LOG_ERR, "<<Err:FB0>> %s\n" ) ;
//			SrcAdr = (unsigned long)MirrorBuf ;
			BufLen = 0 ;
		} else {
			SrcAdr = fix.smem_start ;
			BufLen = fix.smem_len ;
		}
	}
}

/* deconstructor of  Class : SysInfo */
SysInfo::~SysInfo()
{
	if ( nFB0Handle != 0 ) close( nFB0Handle ) ;		// close FB0
	if ( ( pid == 1 ) && ( nCFXGAHandle != 0 ) ) close( nCFXGAHandle ) ;		// close CFXGA
	MsgPrint( LOG_INFO, "<<info>>SysInfo is terminated\n" ) ;
}


#ifdef QT_QWS_CUSTOM

#include	<qgfx_qws.h>
#include	<asm/sharp_apm.h>
#include	<asm/hardware.h>

extern QScreen *qt_screen ;

#endif



// original setting on this program
#define	W_LT_H	0
#define	W_GT_H	1
#define	CFXGA_CRT_640_480_72_16	0
#define	CFXGA_CRT_640_480_85_16	1
#define	CFXGA_CRT_848_480_60_16	2
#define	CFXGA_CRT_800_600_60_16	3
#define	CFXGA_NTSC_C_640_480_16	4
#define	CFXGA_NTSC_C_696_436_16	5
#define	CFXGA_NTSC_S_640_480_16	6
#define	CFXGA_NTSC_S_696_436_16	7


/*********************************************************
  get Screen rotate status 
*********************************************************/
int isRotate()
{
//	return (
//	    ( qt_screen->deviceWidth() > qt_screen->deviceHeight() )
//	    ? W_GT_H : W_LT_H ) ;
	return W_LT_H ;

}


/*********************************************************
  MsgPrint
*********************************************************/
void MsgPrint( int lvl, char *message )
{
#ifdef	DEBUG
	syslog( lvl, message, strerror( errno ) ) ;
	printf( message, strerror( errno ) ) ;
#endif
}


/*********************************************************
  MirrorMode by CFXGA
*********************************************************/
int MirrorMode( SysInfo *sys )
{
	int		result ;
	int		nNowMode ;
	status_t	CFXGAStatus ;
	copy_info_t		UseBufCopy ;
	copy2_info_t		UseFB0Copy ;
	unsigned char		*buf ;


	result = ioctl( sys->nCFXGAHandle, CFXGA_GET_STATUS, &CFXGAStatus ) ;
	if ( result == -1 ) {	// CFXGA not found
	    MsgPrint( LOG_ERR, "<<Err:Mirror>> %s\n" ) ;
	} else if ( ( result & CFXGA_INSTALLED ) ) {		// CFXGA not found
	    MsgPrint( LOG_ERR, "<<Err:MirrorStatus>>\n" ) ;
	    result = -1 ;
	} else {
//		nNowMode = isRotate() ;
// Resolution change
//		if ( nNowMode != sys->nRotate ) {
//			sys->nRotate = nNowMode ;
//			( nNowMode == W_GT_H )
//			       	? ioctl( sys->nCFXGAHandle, CFXGA_SET_RESO, CFXGA_CRT_640_480_72_16 )
//				: ioctl( sys->nCFXGAHandle, CFXGA_SET_RESO, CFXGA_CRT_800_600_60_16 ) ;
//		}
//		if ( ( nNowMode == W_LT_H ) && ( sys->nFB0Handle ) ) {
// read FB0
			UseFB0Copy.x		=   0 ;		// Destnation x
			UseFB0Copy.y		=   0 ;		// Destnation y
			UseFB0Copy.w		= 640 ;		// width
			UseFB0Copy.h		= 480 ;		// height
			UseFB0Copy.bpp		=  16 ;		// Source bit per pixel
			UseFB0Copy.stride	= UseFB0Copy.w * UseFB0Copy.bpp / 8 ;	// src screen stride
			UseFB0Copy.phys_adr	= sys->SrcAdr ;	// Source data start address
			UseFB0Copy.size		= sys->BufLen ;	// Source data size
			UseFB0Copy.offset	=   0 ;		// Source data offset
			UseFB0Copy.swivel	=   0 ;		// Swivel level
			ioctl( sys->nCFXGAHandle, CFXGA_COPY_FB2, &UseFB0Copy ) ;
			result = 0 ;
//		} else if ( nNowMode == W_LT_H ) {
// read Buffer
//			buf = new unsigned char[ 320*240*(16/8) ] ;
//			read( sys->nFB0Handle, buf, 320*240*(16/8) ) ;
//			UseBufCopy.x		=   0 ;		// Destnation x
//			UseBufCopy.y		=   0 ;		// Destnation y
//			UseBufCopy.w		= 240 ;		// Width
//			UseBufCopy.h		= 320 ;		// Height
//			UseBufCopy.bpp		=  16 ;		// Source bit per pixel
//			UseBufCopy.stride	= UseBufCopy.w * UseBufCopy.bpp / 8 ;	// src screen stride
//			UseBufCopy.adr		= MirrorBuf ;		// Source Data Start adr
//			ioctl( sys->nCFXGAHandle, CFXGA_COPY_FB, &UseBufCopy ) ;
//			delete buf ;
//			result = 0 ;
//		} else {
// read Buffer with rotate
//			UseFB0Copy.x		=   0 ;		// Destnation x
//			UseFB0Copy.y		=   0 ;		// Destnation y
//			UseFB0Copy.w		= 240 ;		// width
//			UseFB0Copy.h		= 320 ;		// height
//			UseFB0Copy.bpp		=  16 ;		// Source bit per pixel
//			UseFB0Copy.stride	= UseFB0Copy.w * UseFB0Copy.bpp / 8 ;	// src screen stride
//			UseFB0Copy.phys_adr	= sys->SrcAdr ;	// Source data start address
//			UseFB0Copy.size		= sys->BufLen ;	// Source data size
//			UseFB0Copy.offset	=   0 ;		// Source data offset
//			UseFB0Copy.swivel	=   1 ;		// Swivel level
//			ioctl( sys->nCFXGAHandle, CFXGA_COPY_FB2, &UseFB0Copy ) ;
//			result = 0 ;
//
//#if 0
//			buf = new unsigned char[ 640*480*(16/8) ] ;
//			if ( buf == 0 ) {
//				MsgPrint( LOG_ERR, "<<Err:new>> %s\n" ) ;
//				return 1 ;
//			}
//			RotateFB16( 480, 640, 480, 640, (unsigned short *)buf, (unsigned short *)MirrorBuf ) ;
//			UseBufCopy.x		=   0 ;		// Destnation x
//			UseBufCopy.y		=   0 ;		// Destnation y
//			UseBufCopy.w		= 640 ;		// Width
//			UseBufCopy.h		= 480 ;		// Height
//			UseBufCopy.bpp		=  16 ;		// Source bit per pixel
//			UseBufCopy.stride	= UseBufCopy.w * UseBufCopy.bpp / 8 ;	// src screen stride
//			UseBufCopy.adr		= MirrorBuf ;		// Source Data Start adr
//			ioctl( sys->nCFXGAHandle, CFXGA_COPY_FB, &UseBufCopy ) ;
//			delete []buf ;
//			result = 0 ;
//#endif
//
//		}
	}
	return result ;

}


/*********************************************************
  CFXGAInit
*********************************************************/
int CFXGAInit()
{
	int	result ;

	result = open( "/dev/cfxga0a", O_RDWR ) ;
	if ( result == 0 ) {
		MsgPrint( LOG_ERR, "<<Err:CFXGAopen>> %s\n" ) ;
	}

	return result ;
}


#include <stdlib.h>

/*********************************************************
  main
*********************************************************/
int main( int argc, char **argv )
{
	int		pid ;
	SysInfo		sys ;


int nWait ;
if ( argc == 2 ) {
 nWait = atoi( argv[ 1 ] ) ;
} else {
 printf( "usage: %s count\n", argv[ 0 ] ) ;
 exit( 2 ) ;
}


	if ( ( sys.nCFXGAHandle = CFXGAInit() ) == 0 ) {
	    MsgPrint( LOG_ERR, "<<Err:CFXGAhandle>> %s\n" ) ;
	    exit( errno ) ;
	}

	//( isRotate() == W_GT_H ) ? 
	int mode = CFXGA_CRT_640_480_72_16;
	ioctl( sys.nCFXGAHandle, CFXGA_SET_RESO, &mode );
	//ioctl( sys.nCFXGAHandle, CFXGA_SET_RESO, CFXGA_CRT_800_600_60_16 ) ;

    ioctl( sys.nCFXGAHandle, CFXGA_CLEAR_SCREEN ) ;	// always return 0

	pid = fork() ;
	switch ( pid ) {
	  case -1 :
	    printf( "<< iocpd >> %s\n", strerror( errno ) ) ;
	    break ;
	  case  0 :
		MsgPrint( LOG_INFO, "<< iocpd >> Child Porcess is generated\n" ) ;
	    for ( ; ; ) {
		if ( MirrorMode( &sys ) ) break ;
//		usleep( 100000 ) ;			// 0.1 sec
		usleep( nWait ) ;
	    }
	    MsgPrint( LOG_INFO, "<< iocpd >> Child Porcess is terminated\n" ) ;
	    break ;
	  default :
	    MsgPrint( LOG_INFO, "<< iocpd >> Parents do nothing\n" ) ;
	}

	exit( 0 ) ;
}
