import os
import rox
from rox import OptionsBox, g

def add_themes(themes, dir):
	if not os.path.isdir(dir):
		return
	for theme in os.listdir(dir):
		if theme.startswith('.'): continue
		if os.path.exists(os.path.join(dir, theme, 'gtk-2.0')):
			themes[theme] = True

def build_gtk_theme(box, node, label, option):
	hbox = g.HBox(False, 4)

	hbox.pack_start(g.Label(_(label)), False, True, 0)

	button = g.OptionMenu()
	hbox.pack_start(button, True, True, 0)

	menu = g.Menu()
	button.set_menu(menu)

	themes = {}
	user_dir = os.path.expanduser('~/.themes')
	add_themes(themes, user_dir)
	add_themes(themes, g.rc_get_theme_dir())

	names = themes.keys()
	names.sort()

	for name in names:
		item = g.MenuItem(name)
		menu.append(item)
		item.show_all()

	def update_theme():
		i = -1
		for kid in menu.get_children():
			i += 1
			item = kid.child

			# The label actually moves from the menu!!
			if not item:
				item = button.child
			label = item.get_text()
			if label == option.value:
				button.set_history(i)
	
	def read_theme(): return button.child.get_text()

	box.handlers[option] = (read_theme, update_theme)

	button.connect('changed', lambda w: box.check_widget(option))

	return [hbox]

OptionsBox.widget_registry['gtk-theme'] = build_gtk_theme
