/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DICT_H__
#define __DICT_H__

#include "main.h"

typedef struct dict_s {
	struct dict_s **childs;		/*  */
	unsigned char num_childs;	/*   */
	int index;					/*  */
	char letter;				/*  */
	char *word;					/*    */
	char *trans;				/*    */
} dict_t;

char *dict_word_find(dict_t *root,char *word,int *index);
dict_t *dict_load(char *name);
int dict_add(dict_t *root,char *name);
int dict_index(dict_t *root);
void dict_free(dict_t *root);

#endif /* __DICT_H__ */
