/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "core/gimpbuffer.h"
#include "core/gimpcontainer-filter.h"
#include "core/gimpcontainer.h"
#include "gimp-intl.h"

static ProcRecord buffers_get_list_proc;
static ProcRecord buffer_rename_proc;
static ProcRecord buffer_delete_proc;
static ProcRecord buffer_get_width_proc;
static ProcRecord buffer_get_height_proc;
static ProcRecord buffer_get_bytes_proc;
static ProcRecord buffer_get_image_type_proc;

void
register_buffer_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &buffers_get_list_proc);
  procedural_db_register (gimp, &buffer_rename_proc);
  procedural_db_register (gimp, &buffer_delete_proc);
  procedural_db_register (gimp, &buffer_get_width_proc);
  procedural_db_register (gimp, &buffer_get_height_proc);
  procedural_db_register (gimp, &buffer_get_bytes_proc);
  procedural_db_register (gimp, &buffer_get_image_type_proc);
}

static Argument *
buffers_get_list_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *filter;
  gint32 num_buffers;
  gchar **buffer_list = NULL;

  filter = (gchar *) args[0].value.pdb_pointer;
  if (filter && !g_utf8_validate (filter, -1, NULL))
    success = FALSE;

  if (success)
    buffer_list = gimp_container_get_filtered_name_array (gimp->named_buffers, filter, &num_buffers);

  return_args = procedural_db_return_args (&buffers_get_list_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_buffers;
      return_args[2].value.pdb_pointer = buffer_list;
    }

  return return_args;
}

static ProcArg buffers_get_list_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "filter",
    "An optional regular expression used to filter the list"
  }
};

static ProcArg buffers_get_list_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num-buffers",
    "The number of buffers"
  },
  {
    GIMP_PDB_STRINGARRAY,
    "buffer-list",
    "The list of buffer names"
  }
};

static ProcRecord buffers_get_list_proc =
{
  "gimp-buffers-get-list",
  "gimp-buffers-get-list",
  "Retrieve a complete listing of the available buffers.",
  "This procedure returns a complete listing of available named buffers.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffers_get_list_inargs,
  2,
  buffers_get_list_outargs,
  { { buffers_get_list_invoker } }
};

static Argument *
buffer_rename_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *buffer_name;
  gchar *new_name;
  gchar *real_name = NULL;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  new_name = (gchar *) args[1].value.pdb_pointer;
  if (new_name == NULL || !g_utf8_validate (new_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      GimpBuffer *buffer;

      buffer = (GimpBuffer *)
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL && strlen (new_name) > 0);

      if (success)
        {
          gimp_object_set_name (GIMP_OBJECT (buffer), new_name);
          real_name = g_strdup (gimp_object_get_name (GIMP_OBJECT (buffer)));
        }
    }

  return_args = procedural_db_return_args (&buffer_rename_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = real_name;

  return return_args;
}

static ProcArg buffer_rename_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  },
  {
    GIMP_PDB_STRING,
    "new-name",
    "The buffer's new name"
  }
};

static ProcArg buffer_rename_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "real-name",
    "The real name given to the buffer"
  }
};

static ProcRecord buffer_rename_proc =
{
  "gimp-buffer-rename",
  "gimp-buffer-rename",
  "Renames a named buffer.",
  "This procedure renames a named buffer.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  2,
  buffer_rename_inargs,
  1,
  buffer_rename_outargs,
  { { buffer_rename_invoker } }
};

static Argument *
buffer_delete_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  gchar *buffer_name;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      GimpBuffer *buffer;

      buffer = (GimpBuffer *) 
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL);

      if (success)
        success = gimp_container_remove (gimp->named_buffers, GIMP_OBJECT (buffer));
    }

  return procedural_db_return_args (&buffer_delete_proc, success);
}

static ProcArg buffer_delete_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  }
};

static ProcRecord buffer_delete_proc =
{
  "gimp-buffer-delete",
  "gimp-buffer-delete",
  "Deletes a named buffer.",
  "This procedure deletes a named buffer.",
  "David Gowers <neota@softhome.net>",
  "David Gowers <neota@softhome.net>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffer_delete_inargs,
  0,
  NULL,
  { { buffer_delete_invoker } }
};

static Argument *
buffer_get_width_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *buffer_name;
  GimpBuffer *buffer = NULL;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      buffer = (GimpBuffer *) 
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL);
    }

  return_args = procedural_db_return_args (&buffer_get_width_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_buffer_get_width (buffer);

  return return_args;
}

static ProcArg buffer_get_width_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  }
};

static ProcArg buffer_get_width_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The buffer width"
  }
};

static ProcRecord buffer_get_width_proc =
{
  "gimp-buffer-get-width",
  "gimp-buffer-get-width",
  "Retrieves the specified buffer's width.",
  "This procedure retrieves the specified named buffer's width.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffer_get_width_inargs,
  1,
  buffer_get_width_outargs,
  { { buffer_get_width_invoker } }
};

static Argument *
buffer_get_height_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *buffer_name;
  GimpBuffer *buffer = NULL;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      buffer = (GimpBuffer *) 
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL);
    }

  return_args = procedural_db_return_args (&buffer_get_height_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_buffer_get_height (buffer);

  return return_args;
}

static ProcArg buffer_get_height_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  }
};

static ProcArg buffer_get_height_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "height",
    "The buffer height"
  }
};

static ProcRecord buffer_get_height_proc =
{
  "gimp-buffer-get-height",
  "gimp-buffer-get-height",
  "Retrieves the specified buffer's height.",
  "This procedure retrieves the specified named buffer's height.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffer_get_height_inargs,
  1,
  buffer_get_height_outargs,
  { { buffer_get_height_invoker } }
};

static Argument *
buffer_get_bytes_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *buffer_name;
  GimpBuffer *buffer = NULL;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      buffer = (GimpBuffer *) 
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL);
    }

  return_args = procedural_db_return_args (&buffer_get_bytes_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_buffer_get_bytes (buffer);

  return return_args;
}

static ProcArg buffer_get_bytes_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  }
};

static ProcArg buffer_get_bytes_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "bytes",
    "The buffer bpp"
  }
};

static ProcRecord buffer_get_bytes_proc =
{
  "gimp-buffer-get-bytes",
  "gimp-buffer-get-bytes",
  "Retrieves the specified buffer's bytes.",
  "This procedure retrieves the specified named buffer's bytes.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffer_get_bytes_inargs,
  1,
  buffer_get_bytes_outargs,
  { { buffer_get_bytes_invoker } }
};

static Argument *
buffer_get_image_type_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *buffer_name;
  GimpBuffer *buffer = NULL;

  buffer_name = (gchar *) args[0].value.pdb_pointer;
  if (buffer_name == NULL || !g_utf8_validate (buffer_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      buffer = (GimpBuffer *) 
        gimp_container_get_child_by_name (gimp->named_buffers, buffer_name);

      success = (buffer != NULL);
    }

  return_args = procedural_db_return_args (&buffer_get_image_type_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_buffer_get_image_type (buffer);

  return return_args;
}

static ProcArg buffer_get_image_type_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "buffer-name",
    "The buffer name"
  }
};

static ProcArg buffer_get_image_type_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "image-type",
    "The buffer image type"
  }
};

static ProcRecord buffer_get_image_type_proc =
{
  "gimp-buffer-get-image-type",
  "gimp-buffer-get-image-type",
  "Retrieves the specified buffer's image type.",
  "This procedure retrieves the specified named buffer's image type.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  buffer_get_image_type_inargs,
  1,
  buffer_get_image_type_outargs,
  { { buffer_get_image_type_invoker } }
};
