/*
 *  linux/arch/arm/mach-lh79520/arch.c
 *
 *  Architecture specific fixups.
 *
 *  Copyright (C) 2001 Lineo, Inc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>

extern void genarch_init_irq(void);
extern void lh79520_map_io(void);

#ifdef CONFIG_ARCH_LH79520

//#define USE_BLOB_PARAMS

static void __init
fixup_lh79520(struct machine_desc *desc, struct param_struct *unused,
			  char **cmdline, struct meminfo *mi)
{
#ifndef USE_BLOB_PARAMS
	mi->nr_banks      = 1;
	mi->bank[0].start = PHYS_OFFSET;
	mi->bank[0].size  = (32*1024*1024);
	mi->bank[0].node  = 0;

	ROOT_DEV = MKDEV(RAMDISK_MAJOR,0);
	setup_ramdisk(1, 0, 0, CONFIG_BLK_DEV_RAM_SIZE);
	setup_initrd(__phys_to_virt(0x20400000), 16 * 1024 * 1024);

	/* Serial Console on UART 1 */
	strcpy(*cmdline, "console=ttyAM1,115200 ");

#endif // USE_BLOB_PARAMS
#ifdef CONFIG_LPD_79520_10
	strcat(*cmdline, (char *)__phys_to_virt(0x200c0100));
#endif
}


MACHINE_START(LH79520LPD, "LogicPD LH79520 Card Engine")
	MAINTAINER("Mike Tesch")
	BOOT_MEM(0x20000000, 0xff800000, 0xff800000)
	FIXUP(fixup_lh79520)
	MAPIO(lh79520_map_io)
	INITIRQ(genarch_init_irq)
MACHINE_END

MACHINE_START(LH79520EVB, "Sharp LH79520 Evaluation Board")
	MAINTAINER("Duck")
	BOOT_MEM( 0x20000000, 0xff800000, 0xff800000)		// pio, vio must be 8MB
#ifdef USE_BLOB_PARAMS
	BOOT_PARAMS(0x20000100)
#endif // USE_BLOB_PARAMS
	FIXUP( fixup_lh79520)
	MAPIO( lh79520_map_io)
	INITIRQ( genarch_init_irq)
MACHINE_END

#endif
