/*
 *  linux/include/asm-arm/arch-lh79520/irq.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/arch/hardware.h>
#include <asm/arch/rcpc.h>
#include <asm/arch/iocon.h>
#include <asm/arch/cpld.h>		// DDD only for testing the switches
#include <asm/arch/platform.h>


#define NR_VEC	16			/* number of vectors */
/*
 * Vectored Interrupt Controller Module Register Structure
 */ 
typedef struct {
	u32	IRQStatus;		/* masked IRQ status	*/
	u32	FIQStatus;		/* masked FIQ status	*/
	u32	RawIntr;		/* raw status		*/
	u32	IntSelect;		/* select whether source generates IRQ or FIQ	*/
	u32	IntEnable;		/* int enable mask				*/
	u32	IntEnClear;		/* writes here clear bits in IntEnable		*/
	u32	SoftInt;		/* gen soft interrupts				*/
	u32	SoftIntClear;		/* writes here clear bits in SoftInt		*/
	u32	Protection_NONO;		/* protection enable				*/
	u32	reserved1[3];
	u32	CurrentISR;		/* interrupt vector address of current interrupt */
	u32	DefVectAddr;		/* default vector address			*/
	u32	reserved2[50];
	u32	VectAddr[NR_VEC];	/* interrupt vector address 0...NR_VEC		*/
	u32	reserved3[48];
	u32	VectCntl[NR_VEC];	/* vector control 0...NR_VEC			*/
	u32	reserved4[48];
	u32	ITCR;			/* test mode	*/
	u32	ITIP1;			/* test mode	*/
	u32	ITIP2;			/* test mode	*/
	u32	ITOP1;			/* test mode	*/
	u32	ITOP2;			/* test mode	*/
	u32	reserved5[819];		/* empty	*/
	u32	periphid[4];		/* Peripheral ID register bits			*/
	u32	cellid[4];		/* PrimeCell  ID register bits			*/
} vicRegs_t;


/**********************************************************************
 * Vectored Interrupt Controller Register Bit Fields
 *********************************************************************/ 

/**********************************************************************
 * The bit fields of the following registers have implementation
 * specific meaning, and must be defined at the implementation level.
 *
 * 		irqstatus	- VICIRQStatus
 * 		fiqstatus	- VICFIQStatus
 * 		rawintr		- VICRawIntr
 * 		intselect	- VICIntSelect
 * 		intenable	- VICIntEnable
 * 		intenclear	- VICIntEnClear
 * 		softint		- VICSoftInt
 * 		softintclear- VICSoftIntClear
 *
 * The following definitions for these registers are generic,
 * i.e., they are implementation independent. They can be used to
 * create implementation specific macros.
 *********************************************************************/ 

/**********************************************************************
 * VIC Interrupt Select Register Bit Fields
 *********************************************************************/ 
/* The following can be OR'd with the IntSelect Register to select
 * an interrupt as FIQ. */ 
#define VIC_INTSELECT_FIQ(n)	_BIT((n) & 0x1F)
/* The following can be AND'd with the IntSelect Register to select
 * an interrupt as IRQ. */ 
#define VIC_INTSELECT_IRQ(n)	~(_BIT((n) & 0x1F))

/**********************************************************************
 * VIC Interrupt Enable, Interrupt Enable Clear Register Bit Fields
 * VIC Soft Interrupt, Soft Interrupt Clear Register Bit Fields
 *********************************************************************/ 
#define VIC_INT_ENABLE(n)		_BIT((n) & 0x1F)
#define VIC_INT_CLEAR(n)		_BIT((n) & 0x1F)

/**********************************************************************
 * VIC Protection Enable Register Bit Fields
 *********************************************************************/ 
#define VIC_PROTECTION		_BIT(0)

/**********************************************************************
 * VIC Vector Address Clear Register 
 *********************************************************************/ 
#define VIC_VECTORADDR_CLEAR	0

/**********************************************************************
 * VIC Vector Control Register Bit Fields
 *********************************************************************/ 
/* To revise a Vector Control Register, clear the register, then 
 * use the SELECT macro to associate a line and enable the vector 
 * with the same operation.
 * The ENABLE macro is provided for completeness.
 * Use this register to enable and disable the VECTOR feature;
 * use the intenable register to enable the interrupt
 * itself, and the intenclear register to clear the interrupt. */ 
#define VIC_VECTCNTL_SELECT(n)	(_SBF(0,((n) & 0x1F)) | _BIT(5))
#define VIC_VECTCNTL_ENABLE	_BIT(5)

/**********************************************************************
 * Vectored Interrupt Controller Test Registers
 *********************************************************************/ 
/**********************************************************************
 * 	itcr	- Test Control
 *********************************************************************/ 
#define	VIC_ITCR_ITEN		_BIT(0)

/**********************************************************************
 *	itip1	- Test Input 1
 *********************************************************************/ 
#define	VIC_ITIP1_F		_BIT(6)
#define	VIC_ITIP1_I		_BIT(7)

/**********************************************************************
 *	itop1	- Test Output 1
 *********************************************************************/ 
#define	VIC_ITOP1_F		_BIT(6)
#define	VIC_ITOP1_I		_BIT(7)



#define fixup_irq(i)	(i)



#if 0 // DDD
static unsigned int myReadCp15()
{
    unsigned int x;
    asm ("mrc p15, 0, %0, c1, c0, 0;" : "=r"(x) : );
    return x;
}
#endif

static void lh79520_mask_irq( u32 irq)
{
    vicRegs_t *vic = (vicRegs_t *)VIC_BASE;
    u32 irq_num;

#ifdef CONFIG_LPD_79520_10
    if (irq == IRQ_TOUCH) {
		REG16(CPLD_CE_REG_INTMASK) |= CPLD_CE_INTMASK_MSK_TOUCH;
		boink();
		return;
	} else if (irq == IRQ_ETHERNET) {
		REG16(CPLD_CE_REG_INTMASK) |= CPLD_CE_INTMASK_MSK_WRLAN;
		boink();
		return;
	} else
		irq_num = irq;
#else
    irq_num = irq;
#endif

#if 0
	if (irq_num != IRQ_TIMER0)
		printk( "*************  mask irq %d/%d\n", irq_num, irq);
#endif

    vic->IntEnClear = (1 << irq_num);
}

static void lh79520_unmask_irq( u32 irq)
{
    vicRegs_t *vic = (vicRegs_t *)VIC_BASE;
    u32 irq_num;

#ifdef CONFIG_LPD_79520_10
    if (irq == IRQ_TOUCH) {
		REG16(CPLD_CE_REG_INTMASK) &= ~CPLD_CE_INTMASK_MSK_TOUCH;
		boink();
		irq_num = IRQ_ETHERNET;
	} else if (irq == IRQ_ETHERNET) {
		REG16(CPLD_CE_REG_INTMASK) &= ~CPLD_CE_INTMASK_MSK_WRLAN;
		boink();
		irq_num = irq;
	} else
		irq_num = irq;
#else
    irq_num = irq;
#endif

#if 0
	if (irq_num != IRQ_TIMER0)
		printk( "*************  unmask irq %d/%d\n", irq_num, irq);
#endif

    vic->IntEnable = (1 << irq_num);
}

static __inline__ void irq_init_irq(void)
{
    int		irq, i;
    vicRegs_t	*vic   = (vicRegs_t *)VIC_BASE;
    rcpcRegs_t	*rcpc  = (rcpcRegs_t *)IO_ADDRESS( RCPC_PHYS);
    ioconRegs_t *iocon = (ioconRegs_t *)IO_ADDRESS( IOCON_PHYS);

    /* allow external interrupts to come in */
    iocon->MiscMux =
		MISCMUX_PWM1 | 
		MISCMUX_RCCLKOUT |
		MISCMUX_RCEII0 |  /* interrupt pins 0-4 */
		MISCMUX_RCEII1 |
		MISCMUX_RCEII2 |
		MISCMUX_RCEII3 |
		MISCMUX_RCEII4 | 
		MISCMUX_DCDACK1 | /* dma channel */
		MISCMUX_NWAIT |   /* it's a wait pin for us */
		MISCMUX_PIOF1 |   /* standby pin to debug header on lce */
		MISCMUX_RCCLKIN;
/* replaced kev setup */
//		MISCMUX_RCEII0 |
//		MISCMUX_RCEII1 |
//		MISCMUX_RCEII2 |
//		MISCMUX_RCEII5;

#if 0 // DDD
    printk( "irq_init_irq() cr1=%x\n", myReadCp15());
    printk( "vic=%x  rcpc=0x%x\n", vic, rcpc);
    printk( "id = %x %x %x %x\n", vic->periphid[0], vic->periphid[1], vic->periphid[2], vic->periphid[3]);
#endif // 0 

    vic->IntEnClear = 0xffffffff;			/* clear all interrupt enables	*/
    vic->IntSelect  = 0;				/* everything generates IRQ	*/

    // DDD don't want to do this !!  vic->Protection = 1;	/* allow only priviledged access */

    /* disable vectored interrupts */
    for( i = 0; i < NR_VEC; i++) {
	vic->VectAddr[i] = 0;
	vic->VectCntl[i] = 0;
    }

    for (irq = 0; irq < NR_IRQS; irq++) {
	irq_desc[irq].valid     = 1;
	irq_desc[irq].probe_ok  = 1;
	irq_desc[irq].mask_ack	= lh79520_mask_irq;
	irq_desc[irq].mask      = lh79520_mask_irq;
	irq_desc[irq].unmask    = lh79520_unmask_irq;
    }

	/* disablt cpld interrupts */
	REG16(CPLD_CE_REG_INTMASK) |= 
		CPLD_CE_INTMASK_MSK_WRLAN | CPLD_CE_INTMASK_MSK_TOUCH;

    /*
     * External interrupts 0-2 and 6-7 are active LOW, and External
     * interrupts 3-5 are active HIGH. <---= DDD wrong
     */
    rcpc->control   |=  RCPC_CTRL_WRTLOCK_ENABLED;		/* unlock RCPC registers */
    barrier();

    rcpc->intClear  = 0xff;					/* clear all external interrupts */
    
	barrier();
    rcpc->intConfig =   (
			RCPC_INTCONFIG( RCPC_INT0, RCPC_INT_LLT) |	// irq 0 NMI
			RCPC_INTCONFIG( RCPC_INT1, RCPC_INT_LLT) |	// irq 1 ?
			RCPC_INTCONFIG( RCPC_INT2, RCPC_INT_LLT) |	// irq 2 ?
			RCPC_INTCONFIG( RCPC_INT3, RCPC_INT_LLT) |	// irq 3 ?
			RCPC_INTCONFIG( RCPC_INT4, RCPC_INT_LLT) |	// irq 4 - cpld act low
			RCPC_INTCONFIG( RCPC_INT5, RCPC_INT_LLT) |	// irq 5 - not connected
			RCPC_INTCONFIG( RCPC_INT6, RCPC_INT_LLT) |  // irq 6 - not connected
			RCPC_INTCONFIG( RCPC_INT7, RCPC_INT_LLT)	// irq 7 - not connected
			);

	barrier();
    rcpc->control   &=  ~RCPC_CTRL_WRTLOCK_ENABLED;		/* lock RCPC registers   */
    // DDD printk( "after lock control=0x%x\n", rcpc->control);

#if CONFIG_LH79520_EVB
    {		// DDD test the switches
	cpldRegs_t *cpld = (cpldRegs_t *)CPLD_BASE;
	cpld->intr_mask = 0x1f;
    }
#endif

    // DDD init_FIQ();
}
