/* vi: set sw=4 ts=4 ai: */

#ifndef _LH79X_7SEG_H_
#define _LH79X_7SEG_H_

/**********************************************************************
*  linux/drivers/misc/lh79x_7seg.c
*
*  Provide ADS_784x 7-Segment access for LH7x EVB boards
*
*  Copyright (C) 2002  Lineo, Inc.
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License (GPL) version 2
*  as published by the Free Software Foundation.
*
**********************************************************************/

/**********************************************************************
* The sharp 7-segment display
*
*   _   ==   a
*  | |  ==  f b
*   -   ==   g
*  | |  ==  e c
*   -.  ==   d dot
*
* NOTE: The 7-segment display bars are bit-mapped.
* NOTE: The 7-segment display bars are ACTIVE LOW.
* 
* NOTE: When read, the 7-segment display does not return valid data.  As a
*       result, it is HIGHLY recommended daemons accessing the display
*       use the provided routines which programatically track the current
*       value of the display to simulate read functionality.  Otherwise,
*       application access of the display will be tainted.
*
**********************************************************************/

#define SSD_A	0x01
#define SSD_B	0x02
#define SSD_C	0x04
#define SSD_D	0x08
#define SSD_E	0x10
#define SSD_F	0x20
#define SSD_G	0x40
#define SSD_DOT	0x80
#define SSD_DP	SSD_DOT

#ifdef KERNEL

extern uint16_t lh79x_7seg_read_raw_display(void);
extern u_char lh79x_7seg_read_raw_display_lsb(void);
extern u_char lh79x_7seg_read_raw_display_msb(void);

extern uint16_t lh79x_7seg_read_display(void);
extern u_char lh79x_7seg_read_display_lsb(void);
extern u_char lh79x_7seg_read_display_msb(void);

extern void lh79x_7seg_write_raw_display(uint16_t raw_val);
extern void lh79x_7seg_write_raw_display_lsb(u_char raw_lsb);
extern void lh79x_7seg_write_raw_display_msb(u_char raw_msb);

extern void lh79x_7seg_write_display(uint16_t val)
extern void lh79x_7seg_write_display_lsb(u_char lsb)
extern void lh79x_7seg_write_display_msb(u_char msb)
extern void lh79x_7seg_write_display_str(u_char *str);

#endif /* KERNEL */

#endif /* _LH79X_7SEG_H_ */

