
/*
 *	FILE    	monpar.h
 *
 *	Version 	1.2
 *	Author  	Marc A. Viredaz
 *	        	Compaq Western Research Laboratory, Palo Alto, CA
 *	        	(DEC Western Research Laboratory, Palo Alto, CA)
 *	Date    	January 1999 (April 1998)
 *	System  	Itsy versions 1.0/1.1 and 1.5 (StrongARM SA-1100)
 *	Language	C or ARM Assembly
 *	Purpose 	Itsy monitor parameters.
 *
 * Copyright (c) Compaq Computer Corporation, 1998, 1999
 */

#ifndef MONPAR
#define MONPAR

/* linux includes */
#include "./ARMv4.h"
#include "./SA-1100.h"
#include "./Itsy.h"


/*
 * GLOBAL DEFINITIONS
 */

#define ItsyVUnkwn	0x00000000
#define ItsyV1_1	0x00010001
#define ItsyV1_5	0x00010005

#define MonVUnkwn	0x00000000
#define MonV1_0 	0x00010000
#define MonV1_1 	0x00010001
#define MonV1_2 	0x00010002

#ifndef MonV
#define MonV    	MonVUnkwn
#endif /* !defined (MonV) */

#ifndef _MonDRAM
#define _MonDRAM	_DRAM
#endif /* !defined (_MonDRAM) */

typedef struct
{
   unsigned int 	Version ;
   Word         	ClkFreqNb ;
   Word         	UARTConfig ;
   Word         	UARTBdRtDiv ;
   void         	(*SysStartAdd) (Word, Word, Word, Word) ;
   Word         	SysArgmt1 ;
   Word         	SysArgmt2 ;
   Word         	SysArgmt3 ;
   Word         	SysArgmt4 ;
   ExcpHndlr    	*IntReqTblPtr ;
}               	MonParStruct ;

typedef struct
{
   Word         	Ident ;
   Address      	CtrlTbl ;
}               	StMemParStruct ;

typedef struct
{
   MonParStruct 	*MonParPtr ;
   Word         	ItsyVersion ;
   StMemParStruct	StMemPar [4] ;
   Address      	DRAMCtrlTbl ;
   Word         	MonVersion ;
}               	ItsyParStruct ;

#define ItsyPar 	(*((volatile ItsyParStruct *) VirtAdd (_MonDRAM)))

#endif /* !defined (MONPAR) */
