/*
 *
 * I2C image sensor definitions
 *
 * Copyright 2002 Philips Semiconductors
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 *
 * Author: Wim de haan
 *         <Wim.de.Haan@philips.com>
 *         25 feb 2002
 *
 */

#ifndef _PHILIPS_IMAGE_SENSOR_H
#define _PHILIPS_IMAGE_SENSOR_H

#define UPA1021_BASEADDRESS	0x66	/* Base address of VGA sensor */
#define UPA1022_BASEADDRESS	0x66	/* Base address of VGA sensor */

#define I2C_100K_SPEED		107
#define I2C_400K_SPEED		81
#define I2C_FAST_SPEED          0x18

#define PARAM_IMAGER_PH_ALLREGS           (1 << 0) /* Write all I2C registers */
#define PARAM_IMAGER_PH_ESHUTTER        (1 << 1) /* Write exposure time (# of line times) */
#define PARAM_IMAGER_PH_SUBROW          (1 << 2) /* Write sub row exposure */
#define PARAM_IMAGER_PH_PGA             (1 << 3) /* Write Programmable Gain Amp */
#define PARAM_IMAGER_PH_WINSIZE         (1 << 13) /* Write subimage selection */
#define PARAM_IMAGER_PH_GAINS           (1 << 14) /* Write independent gains */
#define PARAM_IMAGER_PH_BLACK_OFFSET	(1 << 15) /* Write black offset */


#define FPGA_I2C_STATUS_BITS_MASK	7
#define START_I2C_TRANSACTION		0x80
#define I2C_BUSY			0x80
#define I2C_STOP			0x07

/* I2C status bits for error conditions */
#define I2C_ACK_SLAVE_ADDRESS		(1 << 0)
#define I2C_ACK_REG_ADDRESS		(1 << 1)
#define I2C_ACK_DATA			(1 << 2)

/* Register list for UPA1021 image sensor */
/* Ordered by increasing sub-address */
#define UPA1021_CR1		0x00
#define UPA1021_CR2		0x01
#define UPA1021_CR3		0x02
#define UPA1021_XROW		0x03
#define UPA1021_YROWL		0x04
#define UPA1021_HSTARTL		0x05
#define UPA1021_SYSBLREL	0x06
#define UPA1021_SYSBLFEL	0x07
#define UPA1021_HSYH		0x08
#define UPA1021_GOOB		0x09
#define UPA1021_GEOB		0x0A
#define UPA1021_GOEB		0x0B
#define UPA1021_GEEB		0x0C
// 0x0D is reserved
#define UPA1021_REL		0x0E
#define UPA1021_REH		0X0F
#define UPA1021_FIEX		0X10
#define UPA1021_SRER		0x11
#define UPA1021_BOR		0x12
#define UPA1021_BOCL		0x13
#define UPA1021_HCRE		0x14
#define UPA1021_HCFE		0x15
// 0x16 0x21
#define UPA1021_CLKLINL		0x1C
#define UPA1021_LINFIL		0x1D
#define UPA1021_HCKLFL		0x1E
#define UPA1021_HDREL		0x1F
#define UPA1021_HDFEL		0x20
#define UPA1021_HDRFH		0x21
#define UPA1021_VDRCL		0x22
#define UPA1021_VDFCL		0x23
#define UPA1021_VRFCH		0x24
#define UPA1021_VDRLL		0x25
#define UPA1021_VDFLL		0x26
#define UPA1021_VRFLH		0x27


/* Register list for UPA1022 image sensor */
/* Ordered by increasing sub-address */
#define UPA1022_CR1		0x00
#define UPA1022_CR2		0x01
#define UPA1022_CR3		0x02
#define UPA1022_XROW		0x03
#define UPA1022_YROWL		0x04
#define UPA1022_HSTARTL		0x05
#define UPA1022_SYSBLREL	0x06
#define UPA1022_SYSBLFEL	0x07
#define UPA1022_HSYH		0x08
#define UPA1022_GOOB		0x09
#define UPA1022_GEOB		0x0A
#define UPA1022_GOEB		0x0B
#define UPA1022_GEEB		0x0C
#define UPA1022_GINCB		0x0C
#define UPA1022_REL		0x0E
#define UPA1022_REH		0X0F
#define UPA1022_FIEX		0X10
#define UPA1022_SRER		0x11
#define UPA1022_BOR		0x12
#define UPA1022_BOCL		0x13
#define UPA1022_HCRE		0x14
#define UPA1022_FEKP		0x15
#define UPA1022_GCORE		0x16
#define UPA1022_GCOFE		0x17
#define UPA1022_BPRE		0x18
#define UPA1022_BPFE		0x19
#define UPA1022_GMSRE		0x1A
#define UPA1022_GMSFE		0x1B
#define UPA1022_CLKLINL		0x1C
#define UPA1022_LINFIL		0x1D
#define UPA1022_HCKLFL		0x1E
#define UPA1022_HDREL		0x1F
#define UPA1022_HDFEL		0x20
#define UPA1022_HDRFH		0x21
#define UPA1022_VDRCL		0x22
#define UPA1022_VDFCL		0x23
#define UPA1022_VRFCH		0x24
#define UPA1022_VDRLL		0x25
#define UPA1022_VDFLL		0x26
#define UPA1022_VRFLH		0x27
#define UPA1022_CR5		0x28
#define UPA1022_CR6		0x29
#define UPA1022_DPC_PARAM	0x2A
#define UPA1022_BLACKROWS	0x2B
#define UPA1022_GC3RE		0x2C
#define UPA1022_GC3FE		0x2D


enum Philips_sub_type {
	PHILIPS_UPA1021,
	PHILIPS_UPA1022
};

#endif /* _PHILIPS_IMAGE_SENSOR_H */
