#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <byteswap.h>

void usage(char *s)
{
	fprintf(stderr,"%s FNAME PREFIX\n",s);
	exit(1);
}

int main(int argc, char *argv[])
{
	struct stat s;
	unsigned short *p,*b;
	int fd;
	int i,j;

	if (argc != 3)
	{
		usage(argv[0]);
	}

	if (stat(argv[1],&s))
	{
		fprintf(stderr,"Could not stat %s\n",argv[1]);
		usage(argv[0]);
	}
	if (s.st_size & 1)
	{
		fprintf(stderr,"%s is odd size.\n",argv[1]);
		usage(argv[0]);
	}

	if (!(p = (unsigned short *)malloc(s.st_size)))
	{
		fprintf(stderr,"Could not malloc(%d) \n",s.st_size);
		exit(1);
	}

	if ((fd = open(argv[1],0)) <= 0)
	{
		fprintf(stderr,"Could not open %s\n",argv[1]);
		exit(1);
	}

	if (read(fd,p,s.st_size) != s.st_size)
	{
		fprintf(stderr,"Could not read %d bytes from %s\n", s.st_size, argv[1]);
		exit(1);
	}

	printf("ULONG %sLEN = %d;\n",argv[2],s.st_size/2);

	printf("USHORT %s[] = {\n",argv[2]);
	for (b=p,i=j=0; i<(s.st_size/2); i++,b++)
	{
		unsigned short v;
#if FIXME

#if __BYTE_ORDER == __LITTLE_ENDIAN
		v = bswap_16(*b);
#else
		v = *b;
#endif

#else
		v = *b;
#endif
		printf("0x%04x",v);

		if (i < (s.st_size/2)-1)
		{
			printf(", ");
		}

		j++;
		if (j >= 8)
		{
			printf("\n");
			j = 0;
		}
	}
	printf("\n};\n");

	exit(0);
}

