/* 
 * linux/arch/arm/boot/compressed/head-s3c2410.S
 * 
 * Copyright (C) 2002 Samsung Electronics SW.LEE  <hitchcar@sec.samsung.com>
 * 
 * This is merged into head.S by the linker.
 *
 */

#include <linux/config.h>
#include <linux/linkage.h>
#include <asm/mach-types.h>

		.section        ".start", #alloc, #execinstr

/* If you change the main clock  
 *  Aync mode CP15   
 *  uncompresse.h 
 *	
 */
				
		
/**********  MEMORY TIMING PARAMETER ****/
 
/* BWSCON */
#define DW8		 	(0x0)
#define DW16		 	(0x1)
#define DW32		 	(0x2)
#define WAIT		 	(0x1<<2)
#define UBLB		 	(0x1<<3)

#define B1_BWSCON	  (DW32)
#define B2_BWSCON	  (DW16 + WAIT + UBLB)
#define B3_BWSCON	  (DW16 + WAIT + UBLB)
#define B4_BWSCON	  (DW16)
#define B5_BWSCON	  (DW16)
#define B6_BWSCON	  (DW32)
#define B7_BWSCON	  (DW32)


/* BANK0CON */
#define B0_Tacs		 	0x0	//0clk
#define B0_Tcos		 	0x0	//0clk
#define B0_Tacc		 	0x7	//14clk
#define B0_Tcoh		 	0x0	//0clk
#define B0_Tah		 	0x0	//0clk
#define B0_Tacp		 	0x0	
#define B0_PMC		 	0x0	//normal

/* BANK1CON */
#define B1_Tacs		 	0x0	//0clk
#define B1_Tcos		 	0x0	//0clk
#define B1_Tacc		 	0x7	//14clk
#define B1_Tcoh		 	0x0	//0clk
#define B1_Tah		 	0x0	//0clk
#define B1_Tacp		 	0x0	
#define B1_PMC		 	0x0	

/* BANK2CON --- PCMCIA */
#define B2_Tacs		 	0x0	
#define B2_Tcos		 	0x0	
#define B2_Tacc		 	0x7	
#define B2_Tcoh		 	0x0	
#define B2_Tah		 	0x0	
#define B2_Tacp		 	0x0	
#define B2_PMC		 	0x0	

/* BANK3C0N ---- CS8900A Ethernet Controller on GCS3 */
#define B3_Tacs		 	0x0	//0clk
#define B3_Tcos		 	0x3	//4clk
#define B3_Tacc		 	0x7	//14clk
#define B3_Tcoh		 	0x1	//1clk
#define B3_Tah		 	0x3     //4clk	
#define B3_Tacp		 	0x3     //6clk	
#define B3_PMC		 	0x0	//normal

#define B4_Tacs		 	0x0	//0clk
#define B4_Tcos		 	0x0	//0clk
#define B4_Tacc		 	0x7	//14clk
#define B4_Tcoh		 	0x0	//0clk
#define B4_Tah		 	0x0	//0clk
#define B4_Tacp		 	0x0	
#define B4_PMC		 	0x0	//normal

#define B5_Tacs		 	0x0	//0clk
#define B5_Tcos		 	0x0	//0clk
#define B5_Tacc		 	0x7	//14clk
#define B5_Tcoh		 	0x0	//0clk
#define B5_Tah		 	0x0	//0clk
#define B5_Tacp		 	0x0	
#define B5_PMC		 	0x0	//normal

#define B6_MT		 	0x3	//SDRAM
#define B6_Trcd	 	 	0x1	
#define B6_SCAN		 	0x1	//9bit

#define B7_MT		 	0x3	//SDRAM
#define B7_Trcd		 	0x1	//3clk
#define B7_SCAN		 	0x1	//9bit

/* REFRESH parameter */
#define REFEN		 	0x1	//Refresh enable
#define TREFMD		 	0x0	//CBR(CAS before RAS)/Auto refresh
#define Trp		 	0x0	//2clk
#define Trc		 	0x3	//7clk
#define Tchr		 	0x2	//3clk
#define REFCNT		 	1113	//period=15.6us, HCLK=60Mhz, (2048+1-15.6*60)
/**************************************/


#define FCLK_SPEED 1
	
/*********************  CLOCK  ******** */
#if FCLK_SPEED==0   /*  FCLK=203Mhz, Fin=12Mhz for AUDIO	*/
	#define M_MDIV		0xc3
	#define M_PDIV		0x4
	#define M_SDIV		0x1
#elif FCLK_SPEED==1        /* FCLK = 202.8Mhz */
	#define M_MDIV          0xa1		
	#define M_PDIV		0x3 
	#define M_SDIV		0x1
#endif
/**************************************/

#define USB_CLOCK 1
/****** USB Clock  *******************/
#if USB_CLOCK==0
	#define U_M_MDIV 0xa1
	#define U_M_PDIV 0x3
	#define U_M_SDIV 0x1
#elif USB_CLOCK==1
	#define U_M_MDIV 0x48
	#define U_M_PDIV 0x3
	#define U_M_SDIV 0x2
#endif
/*************************************

/************* REGISTER ***********/
#define INTMSK             0x4A000008
#define INTSUBMSK	    0x4A00001C
#define WTCON              0x53000000
#define LOCKTIME           0x4C000000
#define MPLLCON            0x4C000004
#define UPLLCON            0x4C000008
#define CLKDIVN            0x4C000014
#define BWSCON             0x48000000
#define REFRESH            0x48000024
#define BANKSIZE	    0x48000028
#define GPFCON   	    0x56000050
#define GPFDAT		    0x56000054
#define GPFUP		    0x56000058
/***************************************/


/* #define  CONFIG_ARCH_S3C2410_LED   */
		
__S3C2410_start:

		@ Preserve r8/r7 i.e. kernel entry values

#if defined(CONFIG_ARCH_S3C2410)
	mov	r7, #MACH_TYPE_S3C2410
	mov	r8, #0
#endif
			
	ldr	r0,=WTCON       /*watch dog disable  */
	ldr	r1,=0x0         
	str	r1,[r0]

	ldr	r0,=INTMSK
	ldr	r1,=0xffffffff  /*all interrupt disable */
	str	r1,[r0]

	ldr	r0,=INTSUBMSK
	ldr	r1,=0x3ff		/*all sub interrupt disable */
	str	r1,[r0]
	
	/*	Initialize Ports...for display LED. */
	ldr     r0, =GPFCON
	ldr     r1, =0x55aa
	str     r1, [r0]
	
	ldr     r0, =GPFUP
	ldr     r1, =0xff
	str     r1, [r0]

#if defined( CONFIG_ARCH_S3C2410_LED) 
	ldr     r0, =GPFDAT
	ldr     r1, =0x70
	str     r1, [r0]
	mov	r0, #0x00100000
1:	subs	r0, r0, #1
	bne	1b
#endif	
				
 	/* Setup clock Divider control register  
	 * you must configure CLKDIVN before LOCKTIME or MPLL UPLL
	 * because default CLKDIVN 1,1,1 set the SDMRAM Timing Conflict
	 * FCLK:HCLK:PCLK = 1:2:4  in this case
	 */
	ldr	r0,=CLKDIVN
	ldr	r1,=0x3		
	str	r1,[r0]
	
				
	/*To reduce PLL lock time, adjust the LOCKTIME register. */
	ldr	r0,=LOCKTIME
	ldr	r1,=0xffffff
	str	r1,[r0]	

#if defined( CONFIG_ARCH_S3C2410_LED) 	
 	ldr     r0, =GPFDAT
	ldr     r1, =0xf0
	str     r1, [r0]
 	ldr     r0, =GPFDAT
	ldr     r1, =0xb0
	str     r1, [r0]
	mov	r0, #0x00100000
1:	subs	r0, r0, #1
	bne	1b	
#endif

	/*Configure MPLL */
	ldr	r0,=MPLLCON          
	ldr	r1,=((M_MDIV<<12)+(M_PDIV<<4)+M_SDIV)  //Fin=12MHz,Fout=203MHz
	str	r1,[r0]

#if defined( CONFIG_ARCH_S3C2410_LED)
 	ldr     r0, =GPFDAT
	ldr     r1, =0xf0
	str     r1, [r0]
 	ldr     r0, =GPFDAT
	ldr     r1, =0xd0
	str     r1, [r0]
	mov	r0, #0x00100000
1:	subs	r0, r0, #1
	bne	1b
#endif

	
	/* Some delay between MPLL and UPLL */
	mov	r0,#4000
1:		
	subs	r0,r0,#1
	bne	1b

	/*  Configure UPLL */
       ldr     r0, =UPLLCON
       ldr     r1, =((U_M_MDIV<<12) + (U_M_PDIV<<4) + U_M_SDIV) // Fin=12Mhz, Fout=48Mhz
       str     r1, [r0]

	
#if defined( CONFIG_ARCH_S3C2410_LED)	
	ldr     r0, =GPFDAT
	ldr     r1, =0xff
	str     r1, [r0]
	ldr     r0, =GPFDAT
	ldr     r1, =0xe0
	str     r1, [r0]
	mov	r0, #0x00100000
1:	subs	r0, r0, #1
	bne	1b
#endif
			
	/* Some delay between configuring MPLL and UPLL */
	mov	r0,#8000
1:		
	subs	r0,r0,#1
	bne	1b	


	/* Make AsyncBusMode...
	 * (FCLK,HCLK,PCLK)=(1,2,2) (1,2,4)  AsyncBusMode
	 *                  (1,1,1) (1,1,2)  FastBusMode
	 */
		
	ldr	r1,=0xc0000000
	mrc	p15,0,r0,c1,c0,0
	orr	r0,r0,r1
	mcr	p15,0,r0,c1,c0,0
	

	/* MEMORY CONTROLLER(MC)  SETTING */
	add	r0,pc,#MCDATA - (.+8)
	ldr	r1,=BWSCON		
	add	r2,r0,#52	//  End address of MEMORY CONTROLLER
1:	
	ldr	r3,[r0],#4
	str	r3,[r1],#4
	cmp	r2,r0
	bne	1b
	
	b	1f

	.pool		

    /***
     * Memory configuration should be optimized for best performance 
     * The following parameter is not optimized.                     
     * Memory access cycle parameter strategy
     * 1) The memory settings is safe parameters even at HCLK=75Mhz.
     * 2) SDRAM refresh period is for HCLK=75Mhz. 
     */

	.align 2
		
MCDATA:
    .word (0+(B1_BWSCON<<4)+(B2_BWSCON<<8)+(B3_BWSCON<<12)+(B4_BWSCON<<16)+(B5_BWSCON<<20)+(B6_BWSCON<<24)+(B7_BWSCON<<28))
    .word ((B0_Tacs<<13)+(B0_Tcos<<11)+(B0_Tacc<<8)+(B0_Tcoh<<6)+(B0_Tah<<4)+(B0_Tacp<<2)+(B0_PMC))   
    .word ((B1_Tacs<<13)+(B1_Tcos<<11)+(B1_Tacc<<8)+(B1_Tcoh<<6)+(B1_Tah<<4)+(B1_Tacp<<2)+(B1_PMC))  
    .word ((B2_Tacs<<13)+(B2_Tcos<<11)+(B2_Tacc<<8)+(B2_Tcoh<<6)+(B2_Tah<<4)+(B2_Tacp<<2)+(B2_PMC))  
    .word ((B3_Tacs<<13)+(B3_Tcos<<11)+(B3_Tacc<<8)+(B3_Tcoh<<6)+(B3_Tah<<4)+(B3_Tacp<<2)+(B3_PMC))  
    .word ((B4_Tacs<<13)+(B4_Tcos<<11)+(B4_Tacc<<8)+(B4_Tcoh<<6)+(B4_Tah<<4)+(B4_Tacp<<2)+(B4_PMC))  
    .word ((B5_Tacs<<13)+(B5_Tcos<<11)+(B5_Tacc<<8)+(B5_Tcoh<<6)+(B5_Tah<<4)+(B5_Tacp<<2)+(B5_PMC))
    .word ((B6_MT<<15)+(B6_Trcd<<2)+(B6_SCAN))    
    .word ((B7_MT<<15)+(B7_Trcd<<2)+(B7_SCAN))    
    .word ((REFEN<<23)+(TREFMD<<22)+(Trp<<20)+(Trc<<18)+(Tchr<<16)+REFCNT)    
    .word 0xB2          /* REFRESH Control Register  */ 
    .word 0x30          /* BANKSIZE Register : Burst Mode       */ 
    .word 0x30          /* SDRAM Mode Register       */ 

	
1:
			@ tempoary value 
	mov	r7,#21
	mov	r8,#0
