/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002
*/

#ifndef ASIC2_IO_H
#define ASIC2_IO_H

int h3600_asic_spi_read(unsigned short address, unsigned char *data, unsigned short len);
int h3600_asic_get_version( struct h3600_ts_version *version );
int h3600_asic_spi_read_pcmcia_battery( unsigned char *chem, unsigned char *percent, unsigned char *flag );
int h3600_asic_spi_set_ebat( void );

int h3600_asic_adc_read_channel( int mux );

/* common initialization/cleanup functions */

int  h3600_asic_adc_init(void);
void h3600_asic_adc_cleanup(void);
int  h3600_asic_adc_suspend(void);
void h3600_asic_adc_resume(void);

int  h3600_asic_key_init(void);
void h3600_asic_key_cleanup(void);
int  h3600_asic_key_suspend(void);
void h3600_asic_key_resume(void);

int  h3600_asic_spi_init(void);
void h3600_asic_spi_cleanup(void);
int  h3600_asic_spi_suspend(void);
void h3600_asic_spi_resume (void);

int  h3600_asic_touchscreen_init(void); 
void h3600_asic_touchscreen_cleanup(void);
int  h3600_asic_touchscreen_suspend(void); 
void h3600_asic_touchscreen_resume (void);

#endif
