/*
 *  linux/bootldr/bootldr-commands.c
 *
 *  Copyright (C) 2003 Joshua Wise
 *  Bootloader port to Linux Kernel, May 07, 2003
 *
 *  cli for LAB
 */

#include <linux/init.h>
#include <asm/dma.h>
#include <asm/io.h>
#include <linux/config.h>
#include <linux/slab.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/unistd.h>
#include <linux/ctype.h>
#include <linux/blk.h>
#include <linux/fd.h>
#include <linux/fs.h>
#include <linux/tty.h>
#include <linux/termios.h>
#include <linux/bootldr/commands.h>

struct lab_cmdlist* cmdlist = NULL;
void lab_command_help(int,char**);

void lab_cmdinit()
{
	if (cmdlist) return;
	cmdlist = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
	cmdlist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
	cmdlist->command->cmdname = "help";
	cmdlist->command->func = &lab_command_help;
	cmdlist->command->help = "Displays this help";
	cmdlist->command->subcmd = NULL;
	cmdlist->next = NULL;
	
};

void lab_addcommand(char* cmd, void(*func)(int,const char**), char* help)
{
	struct lab_cmdlist* mylist;
	mylist = cmdlist;
	
	if (mylist == NULL)
	{
		lab_cmdinit();
		mylist = cmdlist;
	};
	
	while (mylist)
	{
		if (!strcmp(cmd, mylist->command->cmdname))
		{
			if (mylist->command->func)
			{
				printk(KERN_NOTICE "lab: tried to insert command %s, but it already exists!\n", cmd);
				return;
			} else 
				/* exists, but only has subcommands. go ahead and just set it. */
				goto justset;
		};
		mylist = mylist->next;
	};
	
	mylist = cmdlist;
	
	while (mylist->next)
		mylist = mylist->next;
	
	mylist->next = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
	mylist = mylist->next;
	mylist->next = NULL;
	mylist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
	mylist->command->subcmd = NULL;
	mylist->command->cmdname = cmd;
justset:
	mylist->command->func = func;
	mylist->command->help = help;
	
	printk(KERN_NOTICE "lab: loaded command %s\n", cmd);
};

void lab_addsubcommand(char* cmd, char* cmd2, void(*func)(int,const char**), char* help)
{
	struct lab_cmdlist* mylist;
	mylist = cmdlist;
	
	if (mylist == NULL)
	{
		lab_cmdinit();
		mylist = cmdlist;
	};
	
	while(mylist)
	{
		if (!strcmp(cmd, mylist->command->cmdname))
		{
			/* found an entry for cmd, let's see if it has subcmds. */
			if (mylist->command->subcmd)
			{
				/* already has subcommands. let's seek through 'em. */
				mylist = mylist->command->subcmd;
				while (mylist->next)
					mylist = mylist->next;
				
				/* ok, we're at the end, let's add a new one. */
				mylist->next = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
				mylist = mylist->next;
				mylist->next = NULL;
				mylist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
				mylist->command->cmdname = cmd2;
				mylist->command->func = func;
				mylist->command->help = help;
				mylist->command->subcmd = NULL;
				printk(KERN_NOTICE "lab: loaded command [%s]%s\n", cmd, cmd2);
				return; /* all done */
			};
			
			/* ok, it didn't have subcommands already, but that's ok,
			 * we'll start a new chain.
			 */
			
			mylist->command->subcmd = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
			mylist = mylist->command->subcmd;
			/* no backing out now. */
			mylist->next = NULL;
			mylist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
			mylist->command->cmdname = cmd2;
			mylist->command->func = func;
			mylist->command->help = help;
			mylist->command->subcmd = NULL;
			printk(KERN_NOTICE "lab: loaded command [%s]%s\n", cmd, cmd2);
			return; /* all done. */
		};
		mylist = mylist->next;
	};
	
	/* ok, the command itself doesn't already exist. that's ok anyway. */
	mylist = cmdlist;
	while (mylist->next)
		mylist = mylist->next;
		
	mylist->next = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
	mylist = mylist->next;
	mylist->next = NULL;
	mylist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
	mylist->command->cmdname = cmd;
	mylist->command->func = NULL;
	mylist->command->help = NULL;
	mylist->command->subcmd = kmalloc(sizeof(struct lab_cmdlist), GFP_KERNEL);
	/* ok, created the command, now to create the subcmd tree */
	mylist = mylist->command->subcmd;
	mylist->next = NULL;
	mylist->command = kmalloc(sizeof(struct lab_command), GFP_KERNEL);
	mylist->command->cmdname = cmd2;
	mylist->command->func = func;
	mylist->command->help = help;
	mylist->command->subcmd = NULL;
	printk(KERN_NOTICE "lab: loaded command [%s]%s\n", cmd, cmd2);
};

void lab_execcommand(int argc, char** argv)
{
	void(*func)(int,const char**);
	struct lab_cmdlist* mylist;
	
	mylist=cmdlist;
	
	if (mylist == NULL)
	{
		lab_cmdinit();
		mylist = cmdlist;
	};
	
	func = 0;
	
	while (mylist)
	{
		if (!strcmp(argv[0],mylist->command->cmdname))
		{
			if (mylist->command->subcmd && (argc > 1))
			{
				struct lab_cmdlist* sublist;
				/* it might be a subcommand we're calling... */
				sublist = mylist->command->subcmd;
				while(sublist)
				{
					if (!strcmp(argv[1],sublist->command->cmdname))
					{
						if (sublist->command->func)
						{
							func = sublist->command->func;
							goto breakout;
						};
					};
					sublist = sublist->next;
				};
				
				if (!func)
				{
					func = 1;
					goto breakout;
				};
			};
			
			if (mylist->command->func)		/* subcommands might not have functions */
			{
				func = mylist->command->func;
				goto breakout;
			}
		};
		mylist = mylist->next;
	};

breakout:	
	if (func == 0)
	{
		putstr("Couldn't find command ");
		putstr(argv[0]);
		putstr(".\r\n");
		return;
	};
	
	if (func == 1)
	{
		putstr("Couldn't find subcommand ");
		putstr(argv[0]);
		putstr(" ");
		putstr(argv[1]);
		putstr(".\r\n");
		return;
	};
	
	func(argc,argv);
};

void lab_command_help(int argc, char** argv)
{
	struct lab_cmdlist* mylist;
	int iscorrect;
	
	mylist = cmdlist;
	
	while (mylist)
	{
		if (argc > 1)
			if (strcmp(argv[1], mylist->command->cmdname))
			{
				mylist = mylist->next;
				continue;
			};
		
		if (mylist->command->func)
		{
			putstr(mylist->command->cmdname);
			putstr(" - ");
			if (mylist->command->help)
				putstr(mylist->command->help);
			else
				putstr("No help");
			putstr("\r\n");
		};
		
		if (mylist->command->subcmd)
		{
			struct lab_cmdlist* sublist;
			
			sublist = mylist->command->subcmd;
			
			while (sublist)
			{
				if (argc > 2)
					if (strcmp(argv[2], sublist->command->cmdname))
					{
						sublist = sublist->next;
						continue;
					};
					
				if (sublist->command->func)
				{
					putstr(mylist->command->cmdname);
					putstr(" ");
					putstr(sublist->command->cmdname);
					putstr(" - ");
					if (sublist->command->help)
						putstr(sublist->command->help);
					else
						putstr("No help");
					putstr("\r\n");
				} else {
					putstr("BUG: Subcommand [");
					putstr(mylist->command->cmdname);
					putstr("]");
					putstr(sublist->command->cmdname);
					putstr(" exists with no function! Fix me!\r\n");
				};
				sublist = sublist->next;
			};
		};
		
		mylist = mylist->next;
	};
};

