/*
 * drivers/pcmcia/sa1100_jornada56x.c
 *
 * Jornada56x CF specific routines
 *
 */
#include <linux/kernel.h>
#include <linux/sched.h>
#include <asm/hardware.h>
#include "sa1100_generic.h"
#include <asm/arch/irqs.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/config.h>
#include <linux/cpufreq.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/tqueue.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/notifier.h>
#include <linux/proc_fs.h>
#include <linux/version.h>
#include <linux/cpufreq.h>
#include <pcmcia/version.h>
#include <pcmcia/cs_types.h>
#include <pcmcia/cs.h>
#include "sa1100.h" /* for sa1100_pcmcia_mecr_bs */

#define SOCKET0_POWER   GPIO_GPIO7

static int jornada56x_pcmcia_init(struct pcmcia_init *init)
{
	int return_val = 0;

	JORNADA_GPDPDR |= SOCKET0_POWER;
	JORNADA_GPDPSR = SOCKET0_POWER;	/* Setting to 1 turns OFF power to CF */
        return_val += request_irq(IRQ_JORNADA_CF_REMOVE, init->handler,
                0, "Jornada56x CF Remove", 0);
        return_val +=  request_irq(IRQ_JORNADA_CF_INSERT, init->handler,
                0, "Jornada56x CF Insert", 0);
        return_val +=  request_irq(IRQ_JORNADA_CF_STSCHG, init->handler,
                0, "Jornada56x CF Status", 0);
        return_val +=  request_irq(IRQ_JORNADA_CF_WAIT_ERR, init->handler,
                0, "Jornada56x CF Wait err", 0);
#if 0
	JORNADA_INT_EN |= JORNADA_CF_REMOVE;
	JORNADA_INT_EN2 |= JORNADA_CF_INT | JORNADA_CF_INSERT
		| JORNADA_CF_STSCHG | JORNADA_CF_WAIT_ERR;
#endif
	return (return_val<0) ? -1 : 1;
}

static int jornada56x_pcmcia_shutdown(void)
{
printk("[%s:%d] %s()\n", __FILE__, __LINE__, __FUNCTION__);
  return 0;
}

static int jornada56x_pcmcia_socket_state(struct pcmcia_state_array
					*state_array)
{
  unsigned long status;
  int return_val=1;

  if(state_array->size<1) return -1;

  memset(state_array->state, 0,
	 (state_array->size)*sizeof(struct pcmcia_state));
  status=JORNADA_CFSR;
  state_array->state[0].detect=(status & JORNADA_CF_VALID)?1:0;
  state_array->state[0].ready=(status & JORNADA_CF_READY)?1:0;
  state_array->state[0].bvd1=(status & JORNADA_CF_BVD1)?1:0;
  state_array->state[0].bvd2=(status & JORNADA_CF_BVD2)?1:0;
  state_array->state[0].wrprot=(status & JORNADA_CF_WP)?1:0;
  state_array->state[0].vs_3v=(status & JORNADA_CF_VS1)?0:1;
  state_array->state[0].vs_Xv=(status & JORNADA_CF_VS2)?0:1;
  if(state_array->size>1) {
	state_array->state[1].detect=0;
	state_array->state[1].ready=0;
	state_array->state[1].bvd1=0;
	state_array->state[1].bvd2=0;
	state_array->state[1].wrprot=0;
	state_array->state[1].vs_3v=0;
	state_array->state[1].vs_Xv=0;
  }
  return return_val;
}

static int jornada56x_pcmcia_get_irq_info(struct pcmcia_irq_info *info)
{
  switch(info->sock){
  case 0:
    info->irq=IRQ_JORNADA_CF;
    break;

  default:
    return -1;
  }
  return 0;
}

static int jornada56x_pcmcia_configure_socket(const struct pcmcia_configure
					    *configure)
{
int i;
int this_x, this_y;

/* Here is where we turn on power to the socket,
 * perform reset (if requested) and remove the 'float'
 * from the I/O pins */

  if (configure->sock != 0)
    return -1;
    switch(configure->vcc){
    case 0:
	JORNADA_GPDPSR = SOCKET0_POWER; /* Turn off power to card */
	break;

    case 33:
	JORNADA_GPDPCR = SOCKET0_POWER; /* Turn on power to card */
	JORNADA_CFCR = JORNADA_CF_PWAIT_EN /* Enable Pwait for card */
		| JORNADA_CF_FLT; /* we want to un-'float' card lines */
	break;

    default:
      printk(KERN_ERR "%s(): unrecognized Vcc %u\n", __FUNCTION__,
	     configure->vcc);
      return -1;
    }
    if(configure->vpp!=configure->vcc && configure->vpp!=0){
      printk(KERN_ERR "%s(): CF slot cannot support Vpp %u\n", __FUNCTION__,
	     configure->vpp);
      return -1;
    }
    if (configure->reset)	/* reset CF card */
	JORNADA_CFCR |= JORNADA_CF_RESET;
    else
	JORNADA_CFCR &= ~JORNADA_CF_RESET;
    return 0;
}
static int jornada56x_pcmcia_socket_init(int sock)
{
	/* Initialize card interface */
	JORNADA_GPDPSR = SOCKET0_POWER; /* power off */
	return 0;
}
static int jornada56x_pcmcia_socket_suspend(int sock)
{
printk("[%s:%d] %s() stub\n", __FILE__, __LINE__, __FUNCTION__);
	return 0;
}
struct pcmcia_low_level jornada56x_pcmcia_ops = {
  init: jornada56x_pcmcia_init,
  shutdown: jornada56x_pcmcia_shutdown,
  socket_state: jornada56x_pcmcia_socket_state,
  get_irq_info: jornada56x_pcmcia_get_irq_info,
  configure_socket: jornada56x_pcmcia_configure_socket,
  socket_init: jornada56x_pcmcia_socket_init,
  socket_suspend: jornada56x_pcmcia_socket_suspend,
};
