#ifndef __ASM_ARM_DIV64
#define __ASM_ARM_DIV64

/*
 * The 64-bit unsigned __udivmoddi4 is implemented in
 * arch/arm/lib/udivdi3.c.
 */
extern u64 __udivmoddi4 (u64 n, u64 d, u64* rp);

#define do_div(n, d)	({	\
        u32 r;                  \
	if (sizeof(n) <= 4) {    \
		(n) = (n) / (d);\
		r = (n) % (d);  \
	} else {		\
		u64 __r;        \
                (n) = __udivmoddi4((u64)(n), (u64)(d), &__r); \
		r = (u32)__r;   \
	}			\
	r;       		\
})

#endif
