/*
 * linux/arch/arm/mach-omap/av500.c
 *
 * This file contains AV500 platform specific code.
 *
 * Copyright (C) 2003 LSE Linux & Security Experts GmbH
 *
 * Copyright (C) 2002 MontaVista Software, Inc.
 *
 * Copyright (C) 2001 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *         Greg Lonnon (glonnon@ridgerun.com) or info@ridgerun.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/tty.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/serial.h>
#include <linux/serial_core.h>

#include <asm/serial.h>
#include <asm/string.h>

#include <asm/io.h>
#include <asm/hardware.h>
#include <asm/setup.h>
#include <asm/page.h>
#include <asm/pgtable.h>

#include <asm/irq.h>
#include <asm/mach/irq.h>
#include <asm/arch/irq.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/arch/ck.h>
#include <asm/arch/irqs.h>
#include <asm/arch/pm.h>

#include <asm/arch/hwtimer.h>
#include <asm/fiq.h>
#include <asm/arch/system.h>

#include "generic.h"
#include "av500_funcmux.h"

static void __init
fixup_av500(struct machine_desc *desc, struct param_struct *params,
	        char **cmdline, struct meminfo *mi)
{
	struct tag *t = (struct tag *)params;

	if (t->hdr.tag != ATAG_CORE) {
		t->hdr.tag = ATAG_CORE;
		t->hdr.size = tag_size(tag_core);
		t->u.core.flags = 0;
		t->u.core.pagesize = PAGE_SIZE;
		t->u.core.rootdev = RAMDISK_MAJOR << 8 | 0;
		t = tag_next(t);

		t->hdr.tag = ATAG_MEM;
		t->hdr.size = tag_size(tag_mem32);
		t->u.mem.start = PHYS_OFFSET;
		t->u.mem.size  = 32 * 1024 * 1024;
		t = tag_next(t);
		
#ifdef	CONFIG_BLK_DEV_RAM
		t->hdr.tag = ATAG_RAMDISK;
		t->hdr.size = tag_size(tag_ramdisk);
		t->u.ramdisk.flags = 1;
		t->u.ramdisk.size = CONFIG_BLK_DEV_RAM_SIZE;
		t->u.ramdisk.start = 0;
		t = tag_next(t);
#endif

		t->hdr.tag = ATAG_NONE;
		t->hdr.size = 0;
	}
}

static void __init
av500_serial_init(void)
{
#ifdef	CONFIG_SERIAL
	struct serial_struct s;

	memset(&s, 0, sizeof(s));

	s.line = 0;	/* ttyS0 */
	s.type = PORT_OMAP;
	s.xmit_fifo_size = 64;
	s.baud_base = BASE_BAUD;
	s.iomem_base = (u8*)OMAP1510_UART1_BASE;
	s.iomem_reg_shift = 2;
	s.io_type = SERIAL_IO_MEM;
	s.irq = INT_UART1;
	s.flags = STD_COM_FLAGS;
	if (early_serial_setup(&s) != 0) {
		panic("Could not register ttyS0!");
	}
	s.line = 1;	/* ttyS1 */
	s.iomem_base = (u8*)OMAP1510_UART2_BASE;
	s.irq = INT_UART2;
	if (early_serial_setup(&s) != 0) {
		panic("Could not register ttyS1!");
	}
#if 0
	s.line = 2;	/* ttyS2 */
	s.iomem_base = (u8*)OMAP1510_UART3_BASE;
	s.irq = INT_UART3;
	if (early_serial_setup(&s) != 0) {
		panic("Could not register ttyS2!");
	}
#endif
#endif
}

extern unsigned char irr_fiq_start;
extern unsigned char irr_fiq_end;
extern unsigned char fiq_stack[];

#ifdef CONFIG_AV500_KEEPALIVE
static struct fiq_handler fh = {
        name:   "irr_fiq"
};

#define MPUIO_OUTPUT_REG     ((volatile unsigned short*)0xfffb5004)
void av500_trig(int v)
{
	if (v) 
		*MPUIO_OUTPUT_REG |= (1<<12);
	else
		*MPUIO_OUTPUT_REG &= ~(1<<12);
}

void 
av500_wd_toggle(void)
{
	volatile int j;
	int i;
	for (i=0; i<99; i++)
	{
		*MPUIO_OUTPUT_REG ^= (1<<7); 	
		for (j=0; j<10000; j++);
	}
}

void 
av500_start_wd_toggle(void)
{
        void *fiqhandler_start = &irr_fiq_start;
        unsigned int fiqhandler_length = &irr_fiq_end - &irr_fiq_start;
        struct pt_regs fiq_regs;

        if (claim_fiq(&fh)) {
                //DPRINTK(KERN_ERR "%s failed to claim FIQ\n", __FUNCTION__);
                return;
        }
        set_fiq_handler(fiqhandler_start, fiqhandler_length);
        fiq_regs.ARM_sp = fiq_stack+128;
        set_fiq_regs(&fiq_regs);
        start_mputimer3(3000);
        enable_fiq(INT_TIMER3);
	stf();
	printk("Keepalive started\n");
}

#endif

void 
av500_sramcode_init(void)
{
        extern unsigned char __sram_lma[];
        extern unsigned char __sram_start[];
        extern unsigned char __sram_end[];

	/*
	 * We copy the assembler sleep/wakeup/fiq routines to SRAM.
	 * These routines need to be in SRAM as that's the only
	 * memory the MPU can see when it wakes up.
	 */
	
	memcpy(__sram_start, __sram_lma, __sram_end-__sram_start);
}



#define PA_DM270_BASE        (0x04000000UL)
#define VA_DM270_BASE        (0xE2000000UL)

#define MAP_DESC(base,start,size,domain,r,w,c,b) { base,start,size,domain,r,w,c,b }
static struct map_desc dm270_io_desc[] __initdata = {
	MAP_DESC(VA_DM270_BASE,
		 PA_DM270_BASE,
		 SZ_64K,
		 DOMAIN_IO,
		 0, 1, 0, 0),
        MAP_DESC(OMAP_BOOTFLASH_BASE,
                 OMAP_BOOTFLASH_START,
                 OMAP_BOOTFLASH_SIZE,
                 DOMAIN_IO,
                 0, 1, 0, 0),
        LAST_DESC
};

static void __init av500_map_io(void)
{
	extern int omap1510_dsp_idle(void);

	omap1510_map_io();
        iotable_init(dm270_io_desc);

        /* default pin multiplexing, should be done by bootloader */
        outl(VAL_FUNC_MUX_CTRL_4, FUNC_MUX_CTRL_4);
        outl(VAL_FUNC_MUX_CTRL_5, FUNC_MUX_CTRL_5);
        outl(VAL_FUNC_MUX_CTRL_6, FUNC_MUX_CTRL_6);
        outl(VAL_FUNC_MUX_CTRL_7, FUNC_MUX_CTRL_7);
        outl(VAL_FUNC_MUX_CTRL_8, FUNC_MUX_CTRL_8);
        outl(VAL_FUNC_MUX_CTRL_9, FUNC_MUX_CTRL_9);
        outl(VAL_FUNC_MUX_CTRL_A, FUNC_MUX_CTRL_A);
        outl(VAL_FUNC_MUX_CTRL_B, FUNC_MUX_CTRL_B);
        outl(VAL_FUNC_MUX_CTRL_C, FUNC_MUX_CTRL_C);
        outl(VAL_FUNC_MUX_CTRL_D, FUNC_MUX_CTRL_D);

        outl(VAL_PULL_DWN_CTRL_0, PULL_DWN_CTRL_0);
        outl(VAL_PULL_DWN_CTRL_1, PULL_DWN_CTRL_1);
        outl(VAL_PULL_DWN_CTRL_2, PULL_DWN_CTRL_2);
        outl(VAL_PULL_DWN_CTRL_3, PULL_DWN_CTRL_3);

        outl(VAL_MOD_CONF_CTRL_0, MOD_CONF_CTRL_0);

        /* setup software control for RST_HOST_OUT */
        *ULPD_POWER_CTRL_REG |= (1UL<<2);

        /* assert LOW_POWER_EN to give ULPD control of the pin */
	*ULPD_POWER_CTRL_REG |=  (1UL<<0);
        *ULPD_POWER_CTRL_REG &= ~(1UL<<1);

	*ULPD_SOFT_REQ_REG = 1;

#ifdef CONFIG_AV500_REV10
        /*
         * FIXME: work around bug in AV500 PCB V1.0
         * PWL_OUT is hardwired to DM270 LCD_BRIGHT
         */
        outl(inl(FUNC_MUX_CTRL_6) & ~(7UL<<3), FUNC_MUX_CTRL_6);
#endif

	av500_serial_init();

#ifndef CONFIG_AV500_KEEPALIVE
	av500_sramcode_init();
#endif
	omap1510_dsp_idle();

	return;
}

MACHINE_START(AV500, "AV500/OMAP5910")
	MAINTAINER("LSE Linux and Security Experts GmbH")
	BOOT_MEM(0x10000000, 0xe0000000, 0xe0000000)
	BOOT_PARAMS(0x10000100)
	FIXUP(fixup_av500)
	MAPIO(av500_map_io)
	INITIRQ(omap1510_init_irq)
MACHINE_END

EXPORT_SYMBOL(fiq_stack);
EXPORT_SYMBOL(irr_fiq_start);
EXPORT_SYMBOL(irr_fiq_end);
