/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Report class
 *   Handles the reporting of error, warning, and debug messages
 *
 * Author: Kevin H. Grace, kgrace@mitre.org
 *         The MITRE Corporation
 *         202 Burlington Rd
 *         Bedford, MA  01730
 *         
 *
 * $Id: UtReport.h,v 1.3 2003/12/20 15:42:36 br1 Exp $
 *  
 */

#ifndef __Report_h
#define __Report_h

#include <UtString.h>
#include <syslog.h>

class Report {
  static int cSyslogFlags;
  static int cOstreamFlags;
  static ostream* cOs;
  
public:
  enum Flags { fError = 0x1, fWarn = 0x2, fDebug = 0x4 };

  static void UseSyslog(const String& ident, int flags) {
    openlog(ident.str(),LOG_PID,LOG_USER);
    cSyslogFlags = flags;
  }

  static void UseOstream(ostream* os, int flags = 0) {
    cOs = os;
    cOstreamFlags = flags;
  }

  static void Error(const String& s) {
    if(cSyslogFlags  & fError) syslog(LOG_ERR, s.c_str());
    if(cOs && (cOstreamFlags & fError)) 
      *cOs << s << endl;
    exit(1);
  }
  
  static void Warn(const String& s) {
    if(cSyslogFlags & fWarn) syslog(LOG_WARNING, s.c_str());
    if(cOs && (cOstreamFlags & fWarn))
      *cOs << s << endl;
  }

  static void Info(const String& s) {
    if(cSyslogFlags & fWarn) syslog(LOG_INFO, s.c_str());
    if(cOs && (cOstreamFlags & fWarn))
      *cOs << s << endl;
  }

  static void Debug(const String& s) {
    if(cSyslogFlags & fDebug) syslog(LOG_DEBUG, s.c_str());
    if(cOs && (cOstreamFlags & fDebug))
      *cOs << s << endl;
  }

};

#endif
