#ifndef __WIRELESS_QUALITY_MONITOR_H
#define __WIRELESS_QUALITY_MONITOR_H


#include <map>

#include <arpa/inet.h>		// inet_addr, sockaddr_in
#include <sys/ioctl.h>		// ioctl
#include <net/if_arp.h>		// arp_request, ARPHRD_ETHER
#include <sys/socket.h>		// For AF_INET & struct sockaddr
#include <linux/wireless.h>	// wireless extensions

#include "IwQual.h"


typedef std::map<__u32, IwQual*> QualMap;
typedef std::map<EthAddr, IwQual*> MacMap;


class WirelessQualityMonitor {
private:
	int skfd;			/* generic raw socket desc.	*/
	char ifname[16];
	unsigned int cUpdateThreshold;
//	iw_range range;
//	int has_range;

	QualMap* qualMap;
	MacMap* macMap;

	QualMap* toArpMap; // contains IwQual objects which we still have to get the MAC address for

	bool arp(IwQual* q);

public:
	WirelessQualityMonitor( const char* ifname, const unsigned int updateThreshold );
	~WirelessQualityMonitor();

	bool add( const struct sockaddr_in );
	void remove( const struct sockaddr_in );

	int getMetric( const __u32 ip );
	int getMetric( struct sockaddr_in ip );
	int getSNR( const __u32 ip );

	bool updateThreshold( const __u32 ip );

	void print();
	void printMac();

	int setSpy();
	int getSpy();

	bool resolveRemainingMacs();
};


class IwSpyException { };
class GetIwSpyException: public IwSpyException { };
class SetIwSpyException: public IwSpyException { };

#endif
