/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.1 2003/12/12 16:53:37 welwarsky Exp $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_exthost.h"

MU_exthost_config_t config;

static void
get_info_exthost(void)
{
	if (get_interface(&config) == INVALID)
		exit(1);
}

static void
end_exthost(struct mu_op *opp,int timing)
{
	exec_device_script(opp,timing);
}

struct mu_op mu_op = {
	device: exthost,
	device_name: MU_ARG_EXTHOST,
	command: MU_MURASAKI "." MU_ARG_EXTHOST,
	mappath: NULL,
	default_mapname: NULL,
	action: ACTION_NONE,
	config: &config,
	get_info: get_info_exthost,
	get_list: NULL,
	match_map: NULL,
	run: NULL,
	prepare: exec_device_script,
	end: end_exthost,
};
