/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: path.c,v 1.1 2002/04/20 18:37:06 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<limits.h>

char *
get_path(char *fname)
{
	int fd;
	char buf[PATH_MAX+1];
	ssize_t len;
	char *path;

	if ((fd = open(fname,O_RDONLY)) == -1)
		return NULL;
	if ((len = read(fd,buf,PATH_MAX)) <= 0)
		return NULL;
	close(fd);
	if (buf[len-1] == '\n')
		buf[len-1] = '\0';
	else
		buf[len] = '\0';
	if (access(buf,X_OK) != 0)
		return NULL;
	if((path = strdup(buf)) == NULL)
		return NULL;

	return path;
}
