/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: match.c,v 3.8 2002/04/20 18:56:29 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define	CHAR_COMMENT	'#'
#define	CHAR_RSEP		'\n'

#define	ST_COMMENT		255
#define	ST_SKIP			(ST_COMMENT - 1)
#define	ST_MODULE		1
#define	ST_MATCH_FLAGS	(ST_MODULE + 1)
#define	ST_VENDOR		(ST_MATCH_FLAGS + 1)
#define	ST_PRODUCT		(ST_VENDOR + 1)
#define	ST_DEV_LO		(ST_PRODUCT + 1)
#define	ST_DEV_HI		(ST_DEV_LO + 1)
#define	ST_DCLASS		(ST_DEV_HI + 1)
#define	ST_DSUBCLASS	(ST_DCLASS + 1)
#define	ST_DPROTOCOL	(ST_DSUBCLASS + 1)
#define	ST_ICLASS		(ST_DPROTOCOL + 1)
#define	ST_ISUBCLASS	(ST_ICLASS + 1)
#define	ST_IPROTOCOL	(ST_ISUBCLASS + 1)
#define	ST_INFO			(ST_IPROTOCOL + 1)

static int
real_match(MU_usb_config_t *active,MU_usb_config_t *map)
{
	if (active->product.vendor == 0 &&
		active->device.class == 0 &&
		active->interface.class == 0)
		return INVALID;
	if (map->match_flags == 0) /* umm... */
		return INVALID;
#ifdef	DEBUG_ALL
	DPRINTF(LOG_LEVEL,"match_flags:0x%x vendor:0x%x product:0x%x Dclass:0x%x Dsubclass:0x%x Dprotocol:0x%x Iclass:0x%x Isubclass:0x%x Iprotocol:0x%x",
	map->match_flags,
	map->product.vendor, map->product.product,
	map->device.class, map->device.subclass,
	map->device.protocol,
	map->interface.class, map->interface.subclass,
	map->interface.protocol);
#endif

	/* Vendor */
	if ((map->match_flags & USB_DEVICE_ID_MATCH_VENDOR) &&
		(active->product.vendor != map->product.vendor))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_PRODUCT) &&
		(active->product.product != map->product.product))
		return INVALID;
	/* bsdDevice value in the member device_lo */
	if ((map->match_flags & USB_DEVICE_ID_MATCH_DEV_LO) &&
		(active->product.device_lo < map->product.device_lo))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_DEV_HI) &&
		(active->product.device_lo > map->product.device_hi))
		return INVALID;

	/* DeviceClass */
	if ((map->match_flags & USB_DEVICE_ID_MATCH_DEV_CLASS) &&
		(active->device.class != map->device.class))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_DEV_SUBCLASS) &&
		(active->device.subclass != map->device.subclass))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_DEV_PROTOCOL) &&
		(active->device.protocol != map->device.protocol))
		return INVALID;

	/* InterfaceClass */
	if ((map->match_flags & USB_DEVICE_ID_MATCH_INT_CLASS) &&
		(active->interface.class != map->interface.class))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_INT_SUBCLASS) &&
		(active->interface.subclass != map->interface.subclass))
		return INVALID;
	if ((map->match_flags & USB_DEVICE_ID_MATCH_INT_PROTOCOL) &&
		(active->interface.protocol != map->interface.protocol))
		return INVALID;

	return GOOD;
}

int
match_config(char **list,char *start,char *end,void *conf)
{
	MU_usb_config_t *config = conf;
	MU_usb_config_t map;
	char *ptr,*module,*module_start,*module_end = NULL;
	int status = ST_MODULE;
	unsigned int len,value;
	char *fwdp;
	int mod_count = 0;

	DPRINTF(LOG_LEVEL,"vendor:0x%x product:0x%x device:0x%x Dclass:0x%x Dsubclass:0x%x Dprotocol:0x%x Iclass:0x%x Isubclass:0x%x Iprotocol:0x%x",
		config->product.vendor, config->product.product,
		config->product.device_lo,
		config->device.class, config->device.subclass,
		config->device.protocol,
		config->interface.class, config->interface.subclass,
		config->interface.protocol);
	for(module_start = ptr = start; ptr < end;ptr++) {
		if (status == ST_COMMENT) {
			while(*ptr != CHAR_RSEP) {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			status = ST_MODULE;
			continue;
		} else if (*ptr == CHAR_COMMENT) {
			status = ST_COMMENT;
			continue;
		}
		if (status == ST_MODULE) {
			module_start = ptr;
			while(*ptr != ' ' && *ptr != '\t') {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			module_end = ptr;
		} else {
			value = (unsigned int)strtoul(ptr,&fwdp,0);
			ptr = fwdp;
			switch(status) {
			case ST_MATCH_FLAGS:
				map.match_flags = value;
				break;
			case ST_VENDOR:
				map.product.vendor = value;
				break;
			case ST_PRODUCT:
				map.product.product = value;
				break;
			case ST_DEV_LO:
				map.product.device_lo = value;
				break;
			case ST_DEV_HI:
				map.product.device_hi = value;
				break;
			case ST_DCLASS:
				map.device.class = value;
				break;
			case ST_DSUBCLASS:
				map.device.subclass = value;
				break;
			case ST_DPROTOCOL:
				map.device.protocol = value;
				break;
			case ST_ICLASS:
				map.interface.class = value;
				break;
			case ST_ISUBCLASS:
				map.interface.subclass = value;
				break;
			case ST_IPROTOCOL:
				map.interface.protocol = value;
				break;
			case ST_INFO:		/* ignore */
				status = ST_MODULE;
				/* for exclusive */
				if (config->match_flags &&
					config->match_flags == map.match_flags)
					continue;
				if (real_match(config,&map) == GOOD) {
					config->match_flags = map.match_flags; /* for exclusive */
					len = module_end - module_start;
					module = malloc(len+1);
					if (module == NULL)
						goto error_return;
					memcpy(module,module_start,len);
					module[len] = '\0';

					syslog(LOG_LEVEL,"MATCH(%s) -> match_flags:0x%x vendor:0x%x product:0x%x Dclass:0x%x Dsubclass:0x%x Dprotocol:0x%x Iclass:0x%x Isubclass:0x%x Iprotocol:0x%x",
					module,map.match_flags,
					map.product.vendor,map.product.product,
					map.device.class,map.device.subclass,map.device.protocol,
					map.interface.class,map.interface.subclass,
					map.interface.protocol);

					if (add_to_list(list,module,LIST_MAX) == INVALID)
						goto error_return;
					mod_count++;
				}
				continue;
			default:
				goto error_return;
			}
		}
		status++;
	}
	return mod_count;

error_return:
	return INVALID;
}
