/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "signal.h"
#include "unistd.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "servermd.h"
#include "mi.h"

#include "Agent.h"
#include "Args.h"
#include "Atoms.h"
#include "Color.h"
#include "Display.h"
#include "Screen.h"
#include "Window.h"
#include "Keyboard.h"
#include "Events.h"
#include "Pointer.h"
#include "Splash.h"

#ifdef NXAGENT_FIXKEYS
#include "inputstr.h"
#include "input.h"
#endif

#include "XKBlib.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * Message to be showed to users when the close
 * button is pressed. The right message is chosen
 * according if session does or does not run in
 * persistent mode.
 */

#define MESSAGE_KILL_SESSION \
\
"\
Do you really want to close the session?\
"

#define MESSAGE_SUSPEND_SESSION \
\
"\
Press the suspend button to disconnect the running session.\n\
You will be able to resume the session at later time. Press the\n\
close button to exit the session and terminate all the running\n\
programs.\
"

/*
 * Reduce latency by enabling generation
 * of expose events internally to agent.
 */

#ifdef NXAGENT_EXPOSURES
extern Bool nxagentAutoExposures;
#endif

#if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS) || defined(NXAGENT_KARMA)

#include NXAGENT_NXPROTO_INCLUDE

#include "Control.h"

#endif

#ifdef NXAGENT_VISIBILITY
#include NXAGENT_NXLIB_INCLUDE
int prov;
#endif

#ifdef NXAGENT_ONEXIT
extern Atom nxagent_WM;
extern Bool nxagentOnce;
extern int nxagentClients;
#endif

#ifdef NXAGENT_LOGO
extern WindowPtr nxagentRootTileWindow;
extern int nomachineLogoCount;
#endif

#ifdef NXAGENT_FORCEBACK
extern Bool nxagentForceBackingStore;
#endif

#ifdef NXAGENT_FULLSCREEN
#define XK_MISCELLANY
#include "keysymdef.h"
KeyCode escapecode = 9;
extern Window nxagentFullscreenWindow;
extern Window nxagentIconWindow;
extern void MaximizeToFullScreen(ScreenPtr pScreen);
extern void MinimizeFromFullScreen(ScreenPtr pScreen);

Bool   xkbdRunning = False;
pid_t  pidkbd;
extern Bool nxagentIpaq;
#endif

/*
 * Used to mask the appropriate bits in
 * the state reported by XkbStateNotify
 * and XkbGetIndicatorState.
 */

#define CAPSFLAG_IN_REPLY     1
#define CAPSFLAG_IN_EVENT     2
#define NUMFLAG_IN_EVENT      16
#define NUMFLAG_IN_REPLY      2

CARD32 nxagentLastEventTime     = 0;
CARD32 nxagentLastKeyPressTime  = 0;
Time   nxagentLastServerTime    = 0;

void ProcessInputEvents()
{
  mieqProcessInputEvents();
}

int TimeSinceLastInputEvent()
{
    if (nxagentLastEventTime == 0)
    {
      nxagentLastEventTime = GetTimeInMillis();
    }

    return GetTimeInMillis() - nxagentLastEventTime;
}

void SetTimeSinceLastInputEvent()
{
  nxagentLastEventTime = GetTimeInMillis();
}

#ifdef NXAGENT_LOGO
void nxagentLogoDebug(char *msg)
{
#ifdef NXAGENT_LOGO_DEBUG
    fprintf(stderr, msg);
#endif
}
#endif

static Bool nxagentExposurePredicate(Display *display, XEvent *event, char *window)
{
  /*
   *  Handle both Expose and ProcessedExpose events.
   *  The latters are those not filtered by function
   *  nxagentWindowExposures().
   */

  if (window)
  {
    return ((event -> type == Expose || event -> type == ProcessedExpose) &&
                event -> xexpose.window == *((Window *) window));
  }
  else
  {
    return (event -> type == Expose || event -> type == ProcessedExpose);
  }
}

static Bool nxagentNotExposurePredicate(Display *display, XEvent *event, char *window)
{
  return !nxagentExposurePredicate(display, event, window);
}

static Bool nxagentAnyEventPredicate(Display *display, XEvent *event, char *parameter)
{
  return True;
}

/*
GFPZR
*/
#if 0

void nxagentCollectExposures()
{
  XEvent X;
  WindowPtr pWin;
  RegionRec Rgn;
  BoxRec Box;

#ifdef NXAGENT_EXPOSURES_DEBUG
  /*
   * XXX too verbose
   * fprintf(stderr, "nxagentCollectExposures: Checking remote expose events.\n");
   */
#endif

      while (XCheckIfEvent(nxagentDisplay, &X, nxagentExposurePredicate, NULL)) {

      pWin = nxagentWindowPtr(X.xexpose.window);
      if (pWin) {
        Box.x1 = pWin->drawable.x + wBorderWidth(pWin) + X.xexpose.x;
        Box.y1 = pWin->drawable.y + wBorderWidth(pWin) + X.xexpose.y;
        Box.x2 = Box.x1 + X.xexpose.width;
        Box.y2 = Box.y1 + X.xexpose.height;

        REGION_INIT(pWin->drawable.pScreen, &Rgn, &Box, 1);

#ifdef NXAGENT_EXPOSURES_DEBUG
        fprintf(stderr, "nxagentCollectExposures: Handling remote expose event for window [%x].\n",
                  X.xexpose.window);
#endif
        miWindowExposures(pWin, &Rgn, NullRegion);
      }
#ifdef NXAGENT_EXPOSURES_DEBUG
      else
      {
         fprintf(stderr, "nxagentCollectExposures: Ignoring remote expose event for window [%x].\n",
                  X.xexpose.window);
      }
#endif

#ifdef NXAGENT_LOGO
      if(nxagentRootTileWindow){
          if(pWin)
          {
              if (nxagentWindowPriv(nxagentRootTileWindow)->window == nxagentWindowPriv(pWin)->window &&
                      nomachineLogoCount == 1 && X.xexpose.count == 0)
              {
                  XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
              }
          }
      }
#endif


  }
}

#endif

void nxagentDispatchEvents()
{
  XEvent X;
  xEvent x;
  ScreenPtr pScreen = NULL;

  #ifdef  NXAGENT_MOTION
  int nloop = 0;
  int nSent = 0;
  int postForce = 0;
  int lastMotion = 0;
  #endif

  #ifdef NXAGENT_FULLSCREEN
  Bool Minimize = False;
  #endif

/*
GFPZR

  while (XCheckIfEvent(nxagentDisplay, &X, nxagentNotExposurePredicate, (XPointer) NULL))
*/
  while (XCheckIfEvent(nxagentDisplay, &X, nxagentAnyEventPredicate, (XPointer) NULL))
  {
    #ifdef DEBUG
    fprintf(stderr, "nxagentDispatchEvents: Going to handle new event type [%d].\n",
                X.type);
    #endif

    #ifdef NXAGENT_MOTION

    if (lastMotion > 0 &&
            (X.type != MotionNotify || nSent == 0 ||
                 postForce > 0))
    {
      mieqEnqueue(&x);

      lastMotion = 0;

      nSent++;

      if (X.type != MotionNotify)
      {
        postForce = 1;
      }
      else
      {
        postForce = 0;
      }
    }

    #endif

    #ifdef NXAGENT_VISIBILITY

    if (!nxagentVisibilityStop &&
            (nxagentVisibility == VisibilityUnobscured) &&
                (nxagentVisibilityTimeout < GetTimeInMillis()))
    {
      /*
       * Tell proxy to suppress the
       * Expose events.
       */

      extern Bool nxagentUseNXTrans;

      if (nxagentUseNXTrans &&
              !nxagentOption(Rootless) &&
                  !nxagentOption(Nested))
      {
        NXSetExposeEvents(nxagentDisplay, False, False, False);

        nxagentVisibilityStop = True;
      }
    }

    #endif

    /*
     * Handle the incoming event.
     */

    switch (X.type)
    {
      #ifdef NXAGENT_CLIPBOARD

      case SelectionClear:
      {
        extern void nxagentClearSelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionClear event.\n");
        #endif

        nxagentClearSelection(&X);

        break;
      }
      case SelectionRequest:
      {
        extern void nxagentRequestSelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionRequest event.\n");
        #endif

        nxagentRequestSelection(&X);

        break;
      }
      case SelectionNotify:
      {
        extern void nxagentNotifySelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionNotify event.\n");
        #endif

        nxagentNotifySelection(&X);

        break;
      }

      #endif /* NXAGENT_CLIPBOARD */

      case KeyPress:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeyPress event.\n");
        #endif

        if (nxagentXkbState.Initialized == 0)
        {
          nxagentInitKeyboardState();
        }

        #ifdef NXAGENT_FULLSCREEN

        if (X.xkey.keycode == 130 && nxagentIpaq)
        {
          if (xkbdRunning)
          {
            #ifdef NXAGENT_XKBD_DEBUG
            fprintf(stderr, "Events: nxkbd now is NOT running: %d, %d\n",
                        X.xkey.keycode, escapecode);
            #endif

            xkbdRunning = False;

            kill(pidkbd, 9);
          }
          else
          {
            char kbddisplay[6];
            char *kbdargs[6];

            strcpy(kbddisplay,":");
            strncat(kbddisplay, display, 4);

            kbdargs[0] = "nxkbd";
            kbdargs[1] = "-geometry";
            kbdargs[2] = "240x70+0+250";
            kbdargs[3] = "-display";
            kbdargs[4] = kbddisplay;
            kbdargs[5] = NULL;

            switch (pidkbd = fork())
            {
              case 0:
              {
                execvp(kbdargs[0], kbdargs);

                #ifdef NXAGENT_XKBD_DEBUG
                fprintf(stderr, "Events: execvp of nxkbd failed\n");
                #endif

                exit(1);

                break;
              }
              case -1:
              {
                #ifdef NXAGENT_XKBD_DEBUG
                fprintf(stderr, "Events: can't fork to run nxkbd\n");
                #endif

                break;
              }
              default:
              {
                break;
              }
            }

            #ifdef NXAGENT_XKBD_DEBUG
            fprintf(stderr, "Events: nxkbd now is running: %d, %d\n",
                        X.xkey.keycode, escapecode);
            #endif

            xkbdRunning = True;
          }

          break;
        }

        #endif /* NXAGENT_FULLSCREEN */

        nxagentLastEventTime = nxagentLastKeyPressTime = GetTimeInMillis();

        x.u.u.type = KeyPress;
        x.u.u.detail = X.xkey.keycode;
        x.u.keyButtonPointer.time = nxagentLastKeyPressTime;

        nxagentLastServerTime = X.xkey.time;

        #ifdef NXAGENT_FULLSCREEN

        if (nxagentOption(Fullscreen))
        {
          if (nxagent_WM != None)
          {
            #ifdef NXAGENT_FULLSCREEN_DEBUG
            fprintf(stderr, "key pressed: %d, a: %d\n", X.xkey.keycode, escapecode);
            #endif

            if (X.xkey.keycode == escapecode &&
                   ((X.xkey.state & (ControlMask | Mod1Mask | ShiftMask)) ==
                       (ControlMask|Mod1Mask)))
            {
              pScreen = nxagentScreen(X.xkey.window);

              Minimize =True;

              break;
            }
          }
        }

        #endif /* NXAGENT_FULLSCREEN */

        mieqEnqueue(&x);

        break;
      }
      case KeyRelease:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeyRelease event.\n");
        #endif

        if (nxagentXkbState.Initialized == 0)
        {
          nxagentInitKeyboardState();
        }

        x.u.u.type = KeyRelease;
        x.u.u.detail = X.xkey.keycode;
        x.u.keyButtonPointer.time = nxagentLastKeyPressTime + (X.xkey.time - nxagentLastServerTime);

        nxagentLastServerTime = X.xkey.time;

        nxagentLastEventTime = GetTimeInMillis();

        mieqEnqueue(&x);

        break;
      }
      case ButtonPress:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ButtonPress event.\n");
        #endif

        #ifdef NXAGENT_FULLSCREEN

        if (nxagentOption(Fullscreen))
        {
          if (nxagent_WM != None)
          {
            extern Bool magicPixelZone(int, int);

            if (magicPixelZone(X.xbutton.x, X.xbutton.y))
            {
              pScreen = nxagentScreen(X.xbutton.window);

              Minimize = True;

              break;
            }
          }
        }

        if (nxagentIpaq && nxagentClients <= 0)
        {
          char onexitDisplay[16];

          strcpy(onexitDisplay, ":");
          strncat(onexitDisplay, display, 14);

          NXDialog(nxagentDialogName, MESSAGE_KILL_SESSION,
                       "yesno", 0, onexitDisplay);
        }

        #endif /* NXAGENT_FULLSCREEN */

        x.u.u.type = ButtonPress;
        x.u.u.detail = X.xbutton.button;
        x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

        mieqEnqueue(&x);

        break;
      }
      case ButtonRelease:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ButtonRelease event.\n");
        #endif

        if (Minimize != True)
        {
          x.u.u.type = ButtonRelease;
          x.u.u.detail = X.xbutton.button;
          x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

          mieqEnqueue(&x);
        }

        break;
      }
      case MotionNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new MotionNotify event.\n");
        #endif

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Handling motion notify window [%ld] root [%ld] child [%ld].\n",
                    X.xmotion.window, X.xmotion.root, X.xmotion.subwindow);

        fprintf(stderr, "nxagentDispatchEvents: Pointer at [%d][%d] relative root [%d][%d].\n",
                    X.xmotion.x, X.xmotion.y, X.xmotion.x_root, X.xmotion.y_root);
        #endif

        x.u.u.type = MotionNotify;

        if (nxagentOption(Rootless))
        {
          x.u.keyButtonPointer.rootX = X.xmotion.x_root;
          x.u.keyButtonPointer.rootY = X.xmotion.y_root;
        }
        else
        {
          x.u.keyButtonPointer.rootX = X.xmotion.x;
          x.u.keyButtonPointer.rootY = X.xmotion.y;
        }

        x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

        #ifdef NXAGENT_MOTION

        lastMotion = 1;

        nloop++;

        #else

        mieqEnqueue(&x);

        #endif

        break;
      }
      case FocusIn:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new FocusIn event.\n");
        #endif

        #ifndef NXAGENT_REPARENT
        if (X.xfocus.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xfocus.window);

          if (pScreen)
            nxagentDirectInstallColormaps(pScreen);
        }
        #endif

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)
        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans)
          {
            nxagentFocusKarma = False;
          }
        }
        #endif
/*
FIXME
*/
/*
        {
          extern void nxagentResetSelectionOwner();

          fprintf (stderr, "nxagentDispatchEvents: Resetting clipboard state on focus in.\n");

          nxagentResetSelectionOwner();
        }
*/
        break;
      }
      case FocusOut:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new FocusOut event.\n");
        #endif

        #ifndef NXAGENT_REPARENT

        if (X.xfocus.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xfocus.window);

          if (pScreen)
            nxagentDirectUninstallColormaps(pScreen);
        }

        #endif

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans)
          {
            nxagentFocusKarmaTimeOut = GetTimeInMillis();

            nxagentFocusKarma = True;
          }
        }

        #endif /* defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA) */

        #ifdef NXAGENT_FIXKEYS

        {
          /*
           * Force the keys all up when focus is lost.
           */

          int i, k;
          int mask = 1;
          CARD8 val;

          for (i = 0; i < DOWN_LENGTH; i++) /* input.h */
          {
            val = inputInfo.keyboard->key->down[i];

            if (val != 0)
            {
              for (k = 0; k < 8; k++)
              {
                if (val & (mask << k))
                {
                  #ifdef NXAGENT_FIXKEYS_DEBUG
                  fprintf(stderr, "sending KeyRelease event for keycode: %d\n",
                              i * 8 + k);
                  #endif

                  x.u.u.type = KeyRelease;
                  x.u.u.detail = i * 8 + k;
                  x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

                  mieqEnqueue(&x);
                }
              }
            }
          }
        }

        #endif /* NXAGENT_FIXKEYS */

        break;
      }
      case KeymapNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeymapNotify event.\n");
        #endif

        #ifdef NXAGENT_FULLSCREEN

        if (nxagentOption(Fullscreen))
        {
          escapecode = XKeysymToKeycode(nxagentDisplay, XK_Escape);
        }

        #endif

        break;
      }
      case EnterNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new EnterNotify event.\n");
        #endif

        #ifdef NXAGENT_FULLSCREEN

        if (nxagentOption(Fullscreen))
        {
          if (X.xcrossing.window == nxagentFullscreenWindow &&
                  X.xcrossing.detail != NotifyInferior)
          {
            nxagentGrabPointerAndKeyboard(&X);
          }
        }

        #endif

        #ifdef NXAGENT_REPARENT

        /* quick hack */
        pScreen = screenInfo.screens[0];

        #else

        if (X.xcrossing.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xcrossing.window);

          if (pScreen)
          {
            NewCurrentScreen(pScreen, X.xcrossing.x, X.xcrossing.y);

            x.u.u.type = MotionNotify;
            x.u.keyButtonPointer.rootX = X.xcrossing.x;
            x.u.keyButtonPointer.rootY = X.xcrossing.y;
            x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

            mieqEnqueue(&x);

            nxagentDirectInstallColormaps(pScreen);
          }
        }

        #endif

        break;
      }
      case LeaveNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new LeaveNotify event.\n");
        #endif

        #ifdef NXAGENT_FORCEBACK

        {
          if (nxagentForceBackingStore)
          {
            extern nxbsQueuePtr pbsQueue;
            extern void realizebsQueue(nxbsQueuePtr);

            if(pbsQueue)
            {
              realizebsQueue(pbsQueue);
            }
          }
        }

        #endif

        #ifdef NXAGENT_FULLSCREEN

        if (nxagentOption(Fullscreen))
        {
          if (X.xcrossing.window == nxagentFullscreenWindow &&
                  X.xcrossing.detail != NotifyInferior)
          {
            nxagentUngrabPointerAndKeyboard(&X);

            pScreen = nxagentScreen(X.xcrossing.window);

            Minimize = True;
          }
        }

        #endif

        #ifndef NXAGENT_REPARENT

        if (X.xcrossing.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xcrossing.window);

          if (pScreen)
          {
            nxagentDirectUninstallColormaps(pScreen);
          }
        }

        #endif

        break;
      }
      case DestroyNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new DestroyNotify event.\n");
        #endif

        if (nxagentParentWindow != (Window) 0 &&
                X.xdestroywindow.window == nxagentParentWindow)
        {
          fprintf(stderr, "Warning: Unhandled destroy notify event received in agent.\n");
        }

        break;
      }
      case ClientMessage:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ClientMessage event.\n");
        #endif

        nxagentHandleClientMessageEvent(&X);

        break;
      }

      #ifdef NXAGENT_VISIBILITY

      case VisibilityNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new VisibilityNotify event.\n");
        #endif

        /*
         * FIXME: Why the check on the atom here?
         */

        if (!nxagentOption(Fullscreen) ||
                (nxagentOption(Fullscreen) &&
                     nxagentAtoms[9] != None))
        {
          nxagentVisibility = X.xvisibility.state;

          nxagentVisibilityStop = False;
        }

        if (X.xvisibility.state == VisibilityUnobscured)
        {
          nxagentVisibility = X.xvisibility.state;
          nxagentVisibilityStop = False;
          nxagentVisibilityTimeout = GetTimeInMillis() + 2000;

          #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

          nxagentFocusKarma = False;

          #endif
        }
        else
        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans &&
                  !nxagentOption(Rootless) &&
                      !nxagentOption(Nested))
          {
            if (!nxagentOption(Fullscreen) || (nxagent_WM != None))
            {
              NXSetExposeEvents(nxagentDisplay, True, False, False);

              nxagentVisibilityStop = False;

              #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

              if (X.xvisibility.state == VisibilityFullyObscured)
              {
                nxagentFocusKarmaTimeOut = GetTimeInMillis();

                nxagentFocusKarma = True;
              }

              #endif
            }
          }
        }

        break;
      }

      #endif /* NXAGENT_VISIBILITY */

      #ifdef NXAGENT_MANAGECLIENTS

      case VisibilityNotify:
      {
        ClientPtr client;
        int ret;
        WindowPtr pWin;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new VisibilityNotify event.\n");
        #endif

        if (X.xvisibility.window == nxagentParentWindow)
        {
          break;
        }

        pWin = nxagentWindowPtr(X.xvisibility.window);

        fprintf(stderr, "VisibilityNotify event, state: %d\n", X.xvisibility.state);

        client = wClient(pWin);
        fprintf(stderr, "client ID: %x\n", client);

        if (X.xvisibility.state == VisibilityUnobscured)
          {
            ClientWakeup(client);
          }
        else if (X.xvisibility.state == VisibilityPartiallyObscured)
          {
            ClientSleep(client, (void (*)()) 0, NULL);
          }
        else
          {
            ErrorF("nxagent warning: unhandled VisibilityNotify state\n");
          }

        break;
      }

      #endif /* NXAGENT_MANAGECLIENTS */

      case Expose:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new Expose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received Expose event "
                    "for drawable [%lx] geometry [%d, %d, %d, %d] count [%d].\n",
                        X.xexpose.window, X.xexpose.x, X.xexpose.y, X.xexpose.width,
                            X.xexpose.height, X.xexpose.count);
        #endif

        nxagentHandleExposeEvent(&X);
      }

      #ifdef NXAGENT_NOEXPOSEOPTIMIZE

      case GraphicsExpose:
      {
/*
DARIO
*/
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new GraphicsExpose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received GraphicsExpose event "
                    "for drawable [%lx] geometry [%d, %d, %d, %d] count [%d].\n",
                        X.xgraphicsexpose.drawable, X.xgraphicsexpose.x, X.xgraphicsexpose.y,
                            X.xgraphicsexpose.width, X.xgraphicsexpose.height,
                                X.xgraphicsexpose.count);
        #endif

        #if 0
        nxagentHandleGraphicsExposeEvent(&X);
        #endif

        break;
      }
      case NoExpose:
      {
/*
DARIO
*/
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new NoExpose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received NoExpose event for "
                    "drawable [%lx].\n", X.xnoexpose.drawable);
        #endif

        break;
      }

      #endif /* NXAGENT_NOEXPOSEOPTIMIZE */

      #if defined(NXAGENT_FULLSCREEN) || defined(NXAGENT_VISIBILITY)

      case CirculateNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new CirculateNotify event.\n");
        #endif

        break;
      }
      case ConfigureNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ConfigureNotify event.\n");
        #endif

        if (nxagentOption(Rootless) == True)
        {
          ClientPtr pClient;
          WindowPtr pWinEvent;
          WindowPtr pWinWindow;

          int ret;

          pWinEvent  = nxagentWindowPtr(X.xconfigure.event);
          pWinWindow = nxagentWindowPtr(X.xconfigure.window);

          #ifdef TEST
          fprintf(stderr, "nxagentDispatchEvents: Generating window is [%p][%ld] target [%p][%ld].\n",
                      (void *) pWinEvent, X.xconfigure.event, (void *) pWinWindow, X.xconfigure.window);
          #endif

          #ifdef TEST
          fprintf(stderr, "nxagentDispatchEvents: New configuration for window [%p][%ld] is [%d][%d][%d][%d].\n",
                      (void *) pWinWindow, X.xconfigure.window, X.xconfigure.x, X.xconfigure.y,
                          X.xconfigure.width, X.xconfigure.height);
          #endif

          if (nxagentWindowTopLevel(pWinWindow))
          {
/*
FIXME
            #define wClient(w)            (clients[CLIENT_ID((w)->drawable.id)])
*/

/*
FIXME
            fprintf(stderr, "nxagentDispatchEvents: pWinWindow -> drawable.id is [%ld]\n",
                        pWinWindow -> drawable.id);

            fprintf(stderr, "nxagentDispatchEvents: CLIENT_ID((pWinWindow)->drawable.id) is [%d]\n",
                        CLIENT_ID((pWinWindow)->drawable.id));

            fprintf(stderr, "nxagentDispatchEvents: wClient(pWinWindow) is [%p]\n",
                        (void *) wClient(pWinWindow));
*/
            pClient = wClient(pWinWindow);
/*
FIXME


            fprintf(stderr, "pClient: %p\n", (void *) pClient);

            fprintf(stderr, "border: %d\n", wBorderWidth(pWinWindow));
            fprintf(stderr, "X.xconfigure.x %d\n", X.xconfigure.x);
            fprintf(stderr, "X.xconfigure.y %d\n", X.xconfigure.y);
            fprintf(stderr, "pWinWindow->origin.x %d\n", pWinWindow->origin.x);
            fprintf(stderr, "pWinWindow->origin.y %d\n", pWinWindow->origin.y);
*/

            if (0)
            {
              nxagentWindowPriv(pWinWindow)->x = X.xconfigure.x;
              nxagentWindowPriv(pWinWindow)->y = X.xconfigure.y;
              nxagentWindowPriv(pWinWindow)->width = X.xconfigure.width;
              nxagentWindowPriv(pWinWindow)->height = X.xconfigure.height;

              miSlideAndSizeWindow(pWinWindow,
                                   X.xconfigure.x,
                                   X.xconfigure.y,
                                   X.xconfigure.width,
                                   X.xconfigure.height,
                                   NULL);
            }

            if (1)
            {
              /* from ReconfWin.c::XConfigureWindow */
              /* it should only work on 32 bit machines */

              /* take into account the possibility of using */
              /* InsertFakeRequest */

              unsigned int values[7];
              register unsigned int *value = values;
              Mask mask = 0;

              /*           *value++ = (unsigned long)X.xconfigure.x + wBorderWidth(pWinWindow); */
              /*           *value++ = (unsigned long)X.xconfigure.y + wBorderWidth(pWinWindow); */
              *value++ = (unsigned long)X.xconfigure.x;
              *value++ = (unsigned long)X.xconfigure.y;
              *value++ = (unsigned long)X.xconfigure.width;
              *value++ = (unsigned long)X.xconfigure.height;
              *value++ = (unsigned long)X.xconfigure.border_width;
              /*           *value++ = sibling; */
              /*           *value++ = stackmode; */

              nxagentWindowPriv(pWinWindow)->x = X.xconfigure.x;
              nxagentWindowPriv(pWinWindow)->y = X.xconfigure.y;
              nxagentWindowPriv(pWinWindow)->width = X.xconfigure.width;
              nxagentWindowPriv(pWinWindow)->height = X.xconfigure.height;

              mask |= CWX | CWY | CWHeight | CWWidth;

              ret = ConfigureWindow(pWinWindow, mask, (XID *) values, pClient);
            }

/*
FIXME

            fprintf(stderr, "After (ret: %d):\n", ret);
            fprintf(stderr, "pWinWindow->origin.x %d\n", pWinWindow->origin.x);
            fprintf(stderr, "pWinWindow->origin.y %d\n", pWinWindow->origin.y);
            fprintf(stderr, "\n");
*/
            /*         miSlideAndSizeWindow(pWinWindow, */
            /*                              0, */
            /*                              0, */
            /*                              X.xconfigure.width, */
            /*                              X.xconfigure.height, */
            /*                              NULL); */

            /*         pWinWindow->origin.x = X.xconfigure.x + wBorderWidth(pWinWindow); */
            /*         pWinWindow->origin.y = X.xconfigure.y + wBorderWidth(pWinWindow); */
            /*         pWinWindow->drawable.width = X.xconfigure.width; */
            /*         pWinWindow->drawable.height = X.xconfigure.height; */

          }
        }

        break;
      }
      case GravityNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new GravityNotify event.\n");
        #endif

        break;
      }
      case ReparentNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ReparentNotify event.\n");
        #endif

        break;
      }
      case UnmapNotify:
      {
        extern Bool nxagentUseNXTrans;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new UnmapNotify event.\n");
        #endif

        if (nxagentUseNXTrans &&
                !nxagentOption(Rootless) &&
                    !nxagentOption(Nested) &&
                        X.xmap.window != nxagentIconWindow)
        {
          nxagentVisibility = VisibilityFullyObscured;
          nxagentVisibilityStop = False;

          NXSetExposeEvents(nxagentDisplay, True, False, False);

          #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

          nxagentFocusKarmaTimeOut = GetTimeInMillis();
          nxagentFocusKarma = True;

          #endif
        }

        break;
      }
      case MapNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new MapNotify event.\n");
        #endif

        if (nxagentOption(Fullscreen))
        {
          if (X.xmap.window == nxagentIconWindow)
          {
            pScreen = nxagentScreen(X.xmap.window);
            MaximizeToFullScreen(pScreen);
          }

          nxagentVisibility = VisibilityUnobscured;
          nxagentVisibilityStop = False;
          nxagentVisibilityTimeout = GetTimeInMillis() + 2000;
        }

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

        nxagentFocusKarma = False;

        #endif

        break;
      }

      #endif /* defined(NXAGENT_FULLSCREEN) || defined(NXAGENT_VISIBILITY) */

      case MappingNotify:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Going to handle new MappingNotify event.\n");
        #endif

        break;
      }
      default:
      {
        /*
         * Let's check if this is a XKB
         * state modification event.
         */

        if (nxagentHandleKeyboardEvent(&X) == 0)
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentDispatchEvents: WARNING! Unhandled event code [%d].\n",
                      X.type);
          #endif
        }

        break;
      }

    } /* End of switch (X.type) */

  } /* End of while (XCheckIfEvent(...) */

  if (Minimize)
  {
    if (nxagent_WM != None)
    {
      MinimizeFromFullScreen(pScreen);
    }

    Minimize = False;
  }

  #ifdef NXAGENT_MOTION

  if (lastMotion > 0)
  {
    mieqEnqueue(&x);

    nSent++;
  }

  #ifdef NXAGENT_MOTION_DEBUG

  if (nloop)
  {
    fprintf(stderr, "MotionNotify received=%d sent=%d\n", nloop, nSent);
  }

  #endif /* NXAGENT_MOTION_DEBUG */

  #endif /* NXAGENT_MOTION */
}

#ifdef NXAGENT_ONSTART
void setOwnerNX_WM(WindowPtr pWin)
{
  extern Atom   nxagent_WM_START;
  extern Bool   nxagentWMpassed;
  extern Pixmap nxagentPixmapLogo;

  #ifdef TEST
  fprintf(stderr, "setOwnerNX_WM: Destroying the splash window.\n");
  #endif

  if (!nxagentWMpassed)
  {
    XSetSelectionOwner(nxagentDisplay, nxagent_WM_START, nxagentDefaultWindows[0], CurrentTime);
    nxagentWMpassed = True;
  }
#ifdef NXAGENT_SPLASH
  if (nxagentSplashWindow != None)
  {
    extern void nxagentRefreshWindows(WindowPtr);
    XDestroyWindow(nxagentDisplay, nxagentSplashWindow);
    nxagentSplashWindow = None;
    nxagentRefreshWindows(WindowTable[0]);
  }
  if (nxagentPixmapLogo)
  {
    XFreePixmap(nxagentDisplay, nxagentPixmapLogo);
    nxagentPixmapLogo = (Pixmap)0;
  }
#endif
}
#endif

/*
 * Functions providing the ad-hoc handling
 * of the remote X events.
 */

/*
GFPZR: This is optimized.
*/

int nxagentHandleExposeEvent(XEvent *X)
{
  WindowPtr pWin = NULL;
  Window window = None;

  RegionRec sum;
  RegionRec add;
  BoxRec box;

  #ifdef DEBUG
  fprintf(stderr, "nxagentHandleExposeEvent: Checking remote expose events.\n");
  #endif

  do
  {
    if (window == None || X -> xexpose.window != window)
    {
      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Looking for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      window = X -> xexpose.window;

      pWin = nxagentWindowPtr(window);
    }

    if (pWin)
    {
      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Checking first event for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      box.x1 = pWin -> drawable.x + wBorderWidth(pWin) + X -> xexpose.x;
      box.y1 = pWin -> drawable.y + wBorderWidth(pWin) + X -> xexpose.y;

      box.x2 = box.x1 + X -> xexpose.width;
      box.y2 = box.y1 + X -> xexpose.height;

      REGION_INIT(pWin -> drawable.pScreen, &sum, &box, 1);

      while (XCheckIfEvent(nxagentDisplay, X, nxagentExposurePredicate, (char *) &window))
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentHandleExposeEvent: Adding event for window id [%ld].\n",
                    X -> xexpose.window);
        #endif

        box.x1 = pWin -> drawable.x + wBorderWidth(pWin) + X -> xexpose.x;
        box.y1 = pWin -> drawable.y + wBorderWidth(pWin) + X -> xexpose.y;

        box.x2 = box.x1 + X -> xexpose.width;
        box.y2 = box.y1 + X -> xexpose.height;

        REGION_INIT(pWin -> drawable.pScreen, &add, &box, 1);

        REGION_UNION(pWin -> drawable.pScreen, &sum, &sum, &add);
      }

      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Sending events for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      miWindowExposures(pWin, &sum, NullRegion);

      if (nxagentRootTileWindow)
      {
        if (nxagentWindowPriv(nxagentRootTileWindow) -> window == nxagentWindowPriv(pWin) -> window &&
                nomachineLogoCount == 1 && X -> xexpose.count == 0)
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentHandleExposeEvent: Clearing root tile window id [%ld].\n",
                      nxagentWindowPriv(nxagentRootTileWindow) -> window);
          #endif

          XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow) -> window);
        }
      }
    }
  }
  while (XCheckIfEvent(nxagentDisplay, X, nxagentExposurePredicate, NULL));

  return 1;
}

/*
GFPZR: This should be safe but not optimized.
*/

#if 0

int nxagentHandleExposeEvent(XEvent *X)
{
  WindowPtr pWin = NULL;

  RegionRec sum;
  BoxRec box;

#define TEST
#define DEBUG

  #ifdef DEBUG
  fprintf(stderr, "nxagentHandleExposeEvent: Checking remote expose events.\n");
  #endif

  do
  {
    pWin = nxagentWindowPtr(X -> xexpose.window);

    if (pWin)
    {
      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Checking first event for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      box.x1 = pWin -> drawable.x + wBorderWidth(pWin) + X -> xexpose.x;
      box.y1 = pWin -> drawable.y + wBorderWidth(pWin) + X -> xexpose.y;

      box.x2 = box.x1 + X -> xexpose.width;
      box.y2 = box.y1 + X -> xexpose.height;

      REGION_INIT(pWin -> drawable.pScreen, &sum, &box, 1);

      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Sending events for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      miWindowExposures(pWin, &sum, NullRegion);

      if (nxagentRootTileWindow)
      {
        if (nxagentWindowPriv(nxagentRootTileWindow) -> window == nxagentWindowPriv(pWin) -> window &&
                nomachineLogoCount == 1 && X -> xexpose.count == 0)
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentHandleExposeEvent: Clearing root tile window id [%ld].\n",
                      nxagentWindowPriv(nxagentRootTileWindow) -> window);
          #endif

          XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow) -> window);
        }
      }
    }
  }
  while (XCheckIfEvent(nxagentDisplay, X, nxagentExposurePredicate, NULL));

  return 1;

#undef TEST
#undef DEBUG
}

#endif

int nxagentHandleGraphicsExposeEvent(XEvent *X)
{
/*
DARIO
*/
  xEvent x;

  WindowPtr pWin = nxagentGetWindowFromID(X -> xgraphicsexpose.drawable);

  if (pWin)
  {
    /*
     * Can handle both GraphicsExpose and NoExpose
     * in the same function, anyway there is no
     * need to call it if event is NoExpose.
     */

    x.u.u.type = X -> type;

    x.u.graphicsExposure.drawable = pWin -> drawable.id;
    x.u.graphicsExposure.x = X -> xgraphicsexpose.x;
    x.u.graphicsExposure.y = X -> xgraphicsexpose.y;
    x.u.graphicsExposure.width = X -> xgraphicsexpose.width;
    x.u.graphicsExposure.height = X -> xgraphicsexpose.height;
    x.u.graphicsExposure.majorEvent = X -> xgraphicsexpose.major_code;
    x.u.graphicsExposure.minorEvent = X -> xgraphicsexpose.minor_code;
    x.u.graphicsExposure.count = X -> xgraphicsexpose.count;

    TryClientEvents(wClient(pWin), &x, 1, 1, 1, 0);
  }

  return 1;
}

int nxagentHandleClientMessageEvent(XEvent *X)
{
  ScreenPtr pScreen;

  if (X -> xclient.message_type == nxagentAtoms[1]) /* WM_PROTOCOLS */
  {
    Atom deleteWMatom, wmAtom;

    wmAtom = (Atom) X -> xclient.data.l[0];

    deleteWMatom = nxagentAtoms[2]; /* WM_DELETE_WINDOW */

    if (wmAtom == deleteWMatom)
    {
      if (nxagentOnce && (nxagentClients == 0))
      {
        GiveUp(0);
      }
      else
      {
        char onexitDisplay[16];

        strcpy(onexitDisplay,":");
        strncat(onexitDisplay, display, 14);

        #ifdef TEST
        fprintf(stderr, "Events: WM_DELETE_WINDOW arrived Atom = %ld.\n", wmAtom);
        #endif

        if (X -> xclient.window == nxagentIconWindow)
        {
          pScreen = nxagentScreen(X -> xmap.window);

          MaximizeToFullScreen(pScreen);
        }

        if (nxagentOption(Persistent))
        {
          NXDialog(nxagentDialogName, MESSAGE_SUSPEND_SESSION,
                       "yesnosuspend", False, onexitDisplay);
        }
        else
        {
          NXDialog(nxagentDialogName, MESSAGE_KILL_SESSION,
                       "yesno", False, onexitDisplay);
        }
      }
    }
  }
  else
  {
    #ifdef TEST
    fprintf(stderr, "nxagentDispatchEvents: ClientMessage event window [%ld] type [%ld] format [%d].\n",
                X -> xclient.window, X -> xclient.message_type, X -> xclient.format);
    #endif

    /*
     *  If window is 0, message_type is 0 and format is
     *  32 then we assume event is coming from proxy.
     */

    if (X -> xclient.window == 0 &&
            X -> xclient.message_type == 0 &&
                X -> xclient.format == 32)
    {
      nxagentHandleProxyEvent(X);
    }
    #ifdef DEBUG
    else
    {
      fprintf(stderr, "nxagentDispatchEvents: WARNING! Not a recognized ClientMessage.\n");
    }
    #endif
  }

  return 1;
}

int nxagentHandleKeyboardEvent(XEvent *X)
{
  XkbEvent *xkbev = (XkbEvent *) X;

  #ifdef TEST
  fprintf(stderr, "nxagentHandleKeyboardEvent: Handling event with caps [%d] num [%d] locked [%d].\n",
              nxagentXkbState.Caps, nxagentXkbState.Num, nxagentXkbState.Locked);
  #endif

  if (xkbev -> type == nxagentXkbInfo.EventBase + XkbEventCode &&
          xkbev -> any.xkb_type == XkbStateNotify)
  {
    nxagentXkbState.Locked = xkbev -> state.locked_mods;

    #ifdef TEST
    fprintf(stderr, "nxagentHandleKeyboardEvent: Updated XKB locked modifier bits to [%x].\n",
                nxagentXkbState.Locked);
    #endif

    nxagentXkbState.Initialized = 1;

    if (nxagentXkbState.Caps == 0 &&
            (nxagentXkbState.Locked & CAPSFLAG_IN_EVENT))
    {
      nxagentXkbState.Caps = 1;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [66] to engage capslock.\n");
      #endif

      nxagentSendFakeKey(66);
    }

    if (nxagentXkbState.Caps == 1 &&
          !(nxagentXkbState.Locked & CAPSFLAG_IN_EVENT))
    {
      nxagentXkbState.Caps = 0;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [66] to release capslock.\n");
      #endif

      nxagentSendFakeKey(66);
    }

    if (nxagentXkbState.Num == 0 &&
            (nxagentXkbState.Locked & NUMFLAG_IN_EVENT))
    {
      nxagentXkbState.Num = 1;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [77] to engage numlock.\n");
      #endif

      nxagentSendFakeKey(77);
    }

    if (nxagentXkbState.Num == 1 &&
            !(nxagentXkbState.Locked & NUMFLAG_IN_EVENT))
    {
      nxagentXkbState.Num = 0;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [77] to release numlock.\n");
      #endif

      nxagentSendFakeKey(77);
    }

    return 1;
  }

  return 0;
}

int nxagentHandleProxyEvent(XEvent *X)
{
  switch (X -> xclient.data.l[0])
  {
    case NXSplitNotify:
    {
      int id        = (int) X -> xclient.data.l[1];
      int request   = (int) X -> xclient.data.l[2];
      int position  = (int) X -> xclient.data.l[3];

      /*
       * There are two cases to handle:
       *
       * - We need to commit an image. Image can be the
       *   result of a PutSubImage() generated by Xlib
       *   for whatever reason. So there can be more
       *   than one image to commit because of a single
       *   PutImage performed by agent.
       *
       * - All images for the split where transferred and
       *   we need to restart the client.
       *
       * - The client which issued the PutImage has closed
       *   the connection and the pointer in clients[] is
       *   null. In this case let anyway proxy to commit
       *   image as:
       *
       *   - Proxy needs to free all resources associated
       *     with the recomposed image.
       *
       *   - Target of PutImage can be a pixmap used by
       *     another client.
       */

      if (id < 0 && position >= 0)
      {
        #ifdef TEST
        fprintf(stderr, "nxagentHandleProxyEvent: Commit of request [%d] with position [%d] "
                    "due to split notify.\n", request, position);
        #endif

        nxCommitBigRequest(request, position);
      }
      else if (id >= 0 && position < 0)
      {
        #ifdef TEST
        fprintf(stderr, "nxagentHandleProxyEvent: Wakeup of client id [%d] due to split notify.\n",
                    id);
        #endif

        if (id < MAX_CONNECTIONS && clients[id] != NULL)
        {
          nxWakeByBigRequest(clients[id]);
        }
        #ifdef TEST
        else
        {
          fprintf(stderr, "nxagentHandleProxyEvent: Can't wakeup client id [%d]. Pointer is NULL.\n",
                      id);
        }
        #endif
      }
      #ifdef TEST
      else
      {
        fprintf(stderr, "nxagentHandleProxyEvent: Ignored split notify with client [%d] operation [%d] "
                    "and position [%d].\n", id, request, position);
      }
      #endif

      return 1;
    }
    case NXSyncNotify:
    {
      int id = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: Wakeup of client id [%d] due to sync notify.\n",
                  id);
      #endif

      if (id > 0 && id < MAX_CONNECTIONS && clients[id] != NULL)
      {
        nxWakeByGetIFocus(clients[id]);
      }
      #ifdef TEST
      else
      {
        fprintf(stderr, "nxagentHandleProxyEvent: Can't wakeup client id [%d]. Pointer is NULL.\n",
                    id);
      }
      #endif

      return 1;
    }
    case NXKarmaNotify:
    {
      int id = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: Wakeup of client id [%d] due to karma notify.\n",
                  id);
      #endif

      if (id > 0 && id < MAX_CONNECTIONS && clients[id] != NULL)
      {
        nxWakeByKarma(clients[id]);
      }
      #ifdef TEST
      else
      {
        fprintf(stderr, "nxagentHandleProxyEvent: Can't wakeup client id [%d]. Pointer is NULL.\n",
                    id);
      }
      #endif

      return 1;
    }
    case NXCongestionNotify:
    {
      int state = (int) X -> xclient.data.l[1];

/*
GFPZR
*/
#define TEST

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCongestionNotify received with state [%d].\n",
                  state);
      #endif

#undef TEST

      nxagentCongestion = state;

      nxagentAdjustKarma();

      return 1;
    }
    case NXResetNotify:
    {
      int state = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXResetNotify received with state [%d].\n",
                  state);
      #endif

      nxagentReset = state;

      return 1;
    }
    case NXCollectPropertyNotify:
    {
      int resource = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectPropertyNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentCollectPropertyEvent(resource);

      return 1;
    }
    case NXCollectImageNotify:
    {
      int resource = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectImageNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentCollectImageEvent(resource);

      return 1;
    }
    default:
    {
      /*
       *  Not a recognized ClientMessage event.
       */

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: WARNING! Not a recognized ClientMessage proxy event [%d].\n",
                  (int) X -> xclient.data.l[0]);
      #endif

      return 0;
    }
  }
}

void nxagentEnableKeyboardEvents()
{
  int i;

  nxagentEventMask |= NXAGENT_KEYBOARD_EVENT_MASK;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    XSelectInput(nxagentDisplay, nxagentDefaultWindows[i],
                     nxagentEventMask);
  }

  XkbSelectEvents(nxagentDisplay, XkbUseCoreKbd,
                      NXAGENT_KEYBOARD_EXTENSION_EVENT_MASK,
                          NXAGENT_KEYBOARD_EXTENSION_EVENT_MASK);
}

void nxagentDisableKeyboardEvents()
{
  int i;

  nxagentEventMask &= ~NXAGENT_KEYBOARD_EVENT_MASK;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    XSelectInput(nxagentDisplay, nxagentDefaultWindows[i],
                     nxagentEventMask);
  }

  XkbSelectEvents(nxagentDisplay, XkbUseCoreKbd, 0x0, 0x0);
}

void nxagentEnablePointerEvents()
{
  int i;

  nxagentEventMask |= NXAGENT_POINTER_EVENT_MASK;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    XSelectInput(nxagentDisplay, nxagentDefaultWindows[i],
                     nxagentEventMask);
  }
}

void nxagentDisablePointerEvents()
{
  int i;

  nxagentEventMask &= ~NXAGENT_POINTER_EVENT_MASK;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    XSelectInput(nxagentDisplay, nxagentDefaultWindows[i],
                     nxagentEventMask);
  }
}

void nxagentSendFakeKey(int key)
{
  xEvent fake;
  Time   now;

  now = GetTimeInMillis();

  fake.u.u.type = KeyPress;
  fake.u.u.detail = key;
  fake.u.keyButtonPointer.time = now;

  mieqEnqueue(&fake);
                                                                                                                             
  fake.u.u.type = KeyRelease;
  fake.u.u.detail = key;
  fake.u.keyButtonPointer.time = now;

  mieqEnqueue(&fake);
}

int nxagentInitKeyboardState()
{
  XEvent X;

  unsigned int modifiers;

  XkbEvent *xkbev = (XkbEvent *) &X;

  #ifdef TEST
  fprintf(stderr, "nxagentInitKeyboardState: Initializing XKB state.\n");
  #endif

  XkbGetIndicatorState(nxagentDisplay, XkbUseCoreKbd, &modifiers);

  xkbev -> state.locked_mods = 0x0;

  if (modifiers & CAPSFLAG_IN_REPLY)
  {
    xkbev -> state.locked_mods |= CAPSFLAG_IN_EVENT;
  }

  if (modifiers & NUMFLAG_IN_REPLY)
  {
    xkbev -> state.locked_mods |= NUMFLAG_IN_EVENT;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentInitKeyboardState: Assuming XKB locked modifier bits [%x].\n",
              xkbev -> state.locked_mods);
  #endif

  xkbev -> type         = nxagentXkbInfo.EventBase + XkbEventCode;
  xkbev -> any.xkb_type = XkbStateNotify;

  nxagentHandleKeyboardEvent(&X);

  return 1;
}

void nxagentGrabPointerAndKeyboard(XEvent *X)
{
  unsigned long now;

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Grabbing pointer and keyboard with event at [%p].\n",
              (void *) X);
  #endif

  if (X != NULL)
  {
    now = X -> xcrossing.time;
  }
  else
  {
    now = CurrentTime;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to grab the keyboard in context [B1].\n");
  #endif

  XGrabKeyboard(nxagentDisplay, nxagentFullscreenWindow,
                    True, GrabModeAsync, GrabModeAsync, now);

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to grab the pointer in context [B2].\n");
  #endif

  XGrabPointer(nxagentDisplay, nxagentFullscreenWindow,
                   True, NXAGENT_POINTER_EVENT_MASK, GrabModeAsync,
                       GrabModeAsync, None, None, now);

  /*
   * This should not be needed.
   *
   * XGrabKey(nxagentDisplay, AnyKey, AnyModifier, nxagentFullscreenWindow,
   *              True, GrabModeAsync, GrabModeAsync);
   */

  if (X != NULL)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to force focus in context [B4].\n");
    #endif

    XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                       RevertToParent, now);
  }
}

void nxagentUngrabPointerAndKeyboard(XEvent *X)
{
  unsigned long now;

  #ifdef TEST
  fprintf(stderr, "nxagentUngrabPointerAndKeyboard: Ungrabbing pointer and keyboard with event at [%p].\n",
              (void *) X);
  #endif

  if (X != NULL)
  {
    now = X -> xcrossing.time;
  }
  else
  {
    now = CurrentTime;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentUngrabPointerAndKeyboard: Going to ungrab the keyboard in context [B5].\n");
  #endif

  XUngrabKeyboard(nxagentDisplay, now);

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to ungrab the pointer in context [B6].\n");
  #endif

  XUngrabPointer(nxagentDisplay, now);
}

