#!/bin/sh
CONF_FLAGS=""

NOCONFIGURE=""

for p in $*; do
    case $p in
	"noconf")
	    noconf=1
	    export NOCONFIGURE=1
	    ;;

	"debug")
	    debug=1
	    CONF_FLAGS="${CONF_FLAGS} --enable-debug"
	    ;;

	"home")
	    home=1
	    PKG_CONFIG_PATH="${PKG_CONFIG_PATH}:$HOME/lib/pkgconfig"
	    CONF_FLAGS="--prefix=$HOME --exec-prefix=$HOME"
	    ;;	

	"maintainer")
	    maintainer=1
	    CONF_FLAGS="$CONF_FLAGS --enable-maintainer-mode"
	    ;;

    	*)
	    EXTRA_FLAGS="$EXTRA_FLAGS $p"
	    
    esac
done

echo
autogen=./autogen.sh

cmd="$autogen "
echo "running $cmd" 

$cmd

configure="./configure"

cmd="$configure $CONF_FLAGS"
if [ -z $noconf  ]; then    
    echo "running $cmd"
    $cmd
else 
    echo "now run $cmd"
fi

