#include "DebugTreePrinters.h"

// Example how to use WebCore tree copier callbacks.

// Nodes are created so we can find out the level information



class DebugDOMNode : public WebCoreDOMTreeCopier::Node
{
    DebugDOMNode* child;
    DebugDOMNode* peer; // avoid lists...

public:
    int level;
    
    // delete
    DebugDOMNode() : child(0), peer(0) {}
	
    ~DebugDOMNode() { delete child; delete peer; }
    void addChild(DebugDOMNode* achild) { if (child) child->addPeer(achild); else child = achild;}
    void addPeer(DebugDOMNode* apeer) { peer = apeer;} 
};

WebCoreDOMTreeCopier::Node* 
DebugDOMTreePrinter::nodeWithName(const gchar* name, 
				  const gchar* value,  
				  const gchar* source, 
				  Node* parent)
{
    DebugDOMNode* thisNode = new DebugDOMNode();

    thisNode->level = 0;

    if (parent) {
	DebugDOMNode* myparent = static_cast<DebugDOMNode*>(parent);
	thisNode->level = myparent->level +1;
	myparent->addChild(thisNode);
    }

    // action code
    for (int i=0;i < thisNode->level; i++) {
	g_printerr(" ");
    }

    g_printerr("name: %s, value:%s\n", name, value);


    return thisNode;
}



class DebugRenderNode : public WebCoreRenderTreeCopier::Node
{
    DebugRenderNode* child;
    DebugRenderNode* peer; // avoid lists...
    
public:
    int level;
	  
    // delete
    DebugRenderNode() : child(0), peer(0) {}
    
    ~DebugRenderNode() { delete child; delete peer; }	
    void addChild(DebugRenderNode* achild) { if (child) child->addPeer(achild); else child = achild;}
    void addPeer(DebugRenderNode* apeer) { peer = apeer;} 
};

WebCoreRenderTreeCopier::Node* 
DebugRenderTreePrinter::nodeWithName(const gchar* name, 
				     int x, int y, 
				     GdkRectangle* rect, 
				     GtkWidget* view, Node* parent)
{
    DebugRenderNode* thisNode = new DebugRenderNode();

    thisNode->level = 0;

    if (parent) {
	DebugRenderNode* myparent = static_cast<DebugRenderNode*>(parent);
	thisNode->level = myparent->level +1;
	myparent->addChild(thisNode);
    }

    // action code
    for (int i=0;i < thisNode->level; i++) {
	g_printerr(" ");
    }

    g_printerr("name: %s, absolute position:(%d, %d), relative rect:(%d,%d;%d,%d) is widget: %s \n", 
	       name, x, y, rect->x, rect->y, rect->width, rect->height, view?"yes":"no");


    return thisNode;
}
