/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef SVGImageRenderer_h
#define SVGImageRenderer_h

#include <glib.h>
#include <gdk/gdk.h>

#include <librsvg/rsvg.h>

#include "NRCore/WebCoreImageRenderer.h"

#include "GObjectMisc.h"

class SvgInfo;
class ImageRenderer;

class SVGImageRenderer : public WebCoreImageRenderer
{
public:
    SVGImageRenderer();
    SVGImageRenderer(const SVGImageRenderer&);
    ~SVGImageRenderer();
	
    bool incrementalLoadWithBytes(const void *bytes, unsigned length, bool isComplete);
    void size(GdkRectangle* outRect);
    void resize(GdkRectangle* size);
    void drawImageInRect(GdkRectangle* inRect, GdkRectangle* fromRect, NSCompositingOperation, CGContextRef context);
    void stopAnimation();
    void tileInRect(GdkRectangle *r, int x, int y, CGContextRef context);
    bool isNull();

    void increaseUseCount();
    void decreaseUseCount();
    void flushRasterCache();
    
    SVGImageRenderer* copy();
    
    GdkPixbuf* handle() const;
    
    void sizePrepared(int *width, int *height);
private:
    void cache();
    void invalidate();
    GdkPixbuf* getCurrentPixbuf();
    
    mutable GdkPixbuf* pixbuf;    

    struct Size {
      int w, h;
    };

    Size wantedSize;
    Size realSize;

    int loadOffset;
    
    RsvgHandle *svgHandle;
    bool svgHandleOpen;
    SvgInfo *info;
    ImageRenderer* rasterRenderer;
};

#endif
