/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef Win32TextRendererFactory_h
#define Win32TextRendererFactory_h

#include <glib.h>

#ifndef __WIN32__
#include <X11/Xlib.h>
#include <X11/Xft/Xft.h>
#endif

#include "NRCore/WebCoreTextRendererFactory.h"
#include "Win32TextRenderer.h" // returning

class Win32TextRendererFactory;
class Win32TextRenderer;

namespace Gdiplus {
  class Font;
}


class Win32NSFont : public NSFont
{
public:
    Win32NSFont(Win32TextRendererFactory* creator, Gdiplus::Font* font, gpointer ahash);
    ~Win32NSFont();
    static  gpointer createHash(const gchar * const * families, NSFontTraitMask traits, float size);

    void detach() { creator = 0; }
    Gdiplus::Font *win32Font;
    int ascent;
    int descent;
    int lineSpacing;
    float xHeight;
    int spaceWidth;
    bool fixedPitch;
    gpointer hash;
    Win32TextRendererFactory* creator;
    
};

class Win32TextRendererFactory : public WebCoreTextRendererFactory
{
    
public:

    NSFont* fontWithFamilies(const gchar * const * families, NSFontTraitMask traits, float size);

    Win32TextRenderer* rendererWithFont(NSFont* font, bool isPrinterFont);     // co-variant return type

    bool isFontFixedPitch(NSFont* f);
    
    static void useAsSharedFactory();

    void rendererDeleted(Win32TextRenderer* renderer);
    void fontDeleted(Win32NSFont* font);
protected:
    Win32TextRendererFactory();
    ~Win32TextRendererFactory();

private:
    Win32TextRendererFactory(const Win32TextRendererFactory&);
    Win32TextRendererFactory& operator=(const Win32TextRendererFactory&);
    GHashTable* nsfonts;
};

#endif
