/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef featuresimpl_h
#define featuresimpl_h

/** Features to be applied to current page. */
class FeaturesImpl  
{    
public:
  FeaturesImpl() : m_toolbalsVisible(true), m_statusBarVisible(true),
    m_scrollbarsVisible(true), m_windowIsResizable(true) {}
    
  void setToolbarsVisible(gboolean visible) { m_toolbalsVisible = visible; }
  gboolean areToolbarsVisible() const { return m_toolbalsVisible; }

  void setStatusBarVisible(gboolean visible) { m_statusBarVisible = visible; }
  gboolean isStatusBarVisible() const { return m_statusBarVisible; }

  void setScrollbarsVisible(gboolean visible) { m_scrollbarsVisible = visible; }
  gboolean areScrollbarsVisible() const { return m_scrollbarsVisible; }

  void setWindowIsResizable(gboolean resizable) { m_windowIsResizable = resizable; }
  gboolean windowIsResizable() const { return m_windowIsResizable; }


private:    
    gboolean m_toolbalsVisible;
    gboolean m_statusBarVisible;
    gboolean m_scrollbarsVisible;
    gboolean m_windowIsResizable;
};

#endif
