/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <string.h> /* memset() */
#include <assert.h>

#include "gtk-khtml.h"

#include "webi-marshal.h"

#include "osb.h"

/**
 * gtk_khtml_new:
 *
 * Makes a new #GtkKHTML widget
 *
 * Returns: a new widget
 **/
GtkWidget * 
gtk_khtml_new()
{
    return webi_new();
 }

void 
gtk_khtml_load_url (GtkKHTML * self, const gchar * url)
{
    webi_load_url(self, url);
}

void 
gtk_khtml_refresh (GtkKHTML * self)
{
    webi_refresh(self);
}

void 
gtk_khtml_stop_load (GtkKHTML * self)
{
    webi_refresh(self);
}

gboolean 
gtk_khtml_can_go_back (GtkKHTML * self)
{
    return webi_can_go_back(self);
}

gboolean 
gtk_khtml_can_go_forward (GtkKHTML * self)
{
    return webi_can_go_forward(self);
}

void 
gtk_khtml_go_back (GtkKHTML * self)
{
    return webi_go_back(self);

}

void 
gtk_khtml_go_forward (GtkKHTML * self)
{
    return webi_go_forward(self);
}

const gchar * 
gtk_khtml_get_location (GtkKHTML * self)
{
    return webi_get_location(self);
}

const gchar * 
gtk_khtml_get_title (GtkKHTML * self)
{
    return webi_get_title(self);
}


// const GtkKHTMLLoadStatus * 
// gtk_khtml_get_status (GtkKHTML * self)
// {
//     return webi_get_status(self);
// }


void gtk_khtml_set_settings (GtkKHTML * self, const GtkKHTMLSettings * settings)
{
    webi_set_settings(self, settings);
}

void
gtk_khtml_set_emit_internal_status (GtkKHTML* self, gboolean flag)
{
    webi_set_emit_internal_status(self, flag);
}

void
gtk_khtml_set_group (GtkKHTML * self, const gchar* group)
{
    webi_set_group(self, group);
}

const gchar * 
gtk_khtml_get_group (GtkKHTML * self)
{
    return webi_get_group(self);
}

void 
gtk_khtml_set_text_multiplier (GtkKHTML* self, gfloat multiplier)
{
    webi_set_text_multiplier(self, multiplier);
}

gfloat
gtk_khtml_get_text_multiplier (GtkKHTML* self)
{
    return webi_get_text_multiplier(self);
}

gboolean 
gtk_khtml_find (GtkKHTML* self, const gchar* text, gboolean case_sensitive, gboolean dir_down)
{
    return webi_find(self, text, case_sensitive, dir_down);
}

const gchar* 
gtk_khtml_get_current_selection_as_text(GtkKHTML* self)
{
    return webi_get_current_selection_as_text(self);
}


const gchar *
gtk_khtml_render_tree (GtkKHTML * self)
{
    return webi_render_tree(self);
}

/*
  Local Variables:
  c-basic-offset: 4
  End:
 */
