/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "osb.h"

namespace OSB{
class PreferencesImpl  : public 
{
public:
}
Preferences::Preferences()
{
    impl = new KWIQPreferences;
}

Preferences::~Preferences()
{
    delete impl;
}

void Preferences::setMinimumFontSize(float a)
{
}

float Preferences::minimumFontSize()
{
    return 6.0f;
}

void Preferences::setMinimumLogicalFontSize(float a)
{
}

float Preferences::minimumLogicalFontSize() 
{
    return 6.0f;
}

void Preferences::setDefaultFontSize(float a)
{
}

float Preferences::defaultFontSize()
{
    return 14.0f;
}

void Preferences::setDefaultFixedFontSize(float a){}
float Preferences::defaultFixedFontSize(){
    return 14.0f;
}
  
void Preferences::setJavaEnabled(bool a){}
bool Preferences::javaEnabled() {
    return true;
}

void Preferences::setPluginsEnabled(bool a){}
bool Preferences::pluginsEnabled(){
    return true;
}

void Preferences::setJavaScriptEnabled(bool a){}
bool Preferences::javaScriptEnabled(){
    return true;
}

void Preferences::setJavaScriptCanOpenWindowsAutomatically(bool a) {}
bool Preferences::javaScriptCanOpenWindowsAutomatically(){
    return false;
}

void Preferences::setWillLoadImagesAutomatically(bool a){}
bool Preferences::willLoadImagesAutomatically(){
    return true;
}

void Preferences::setShouldPrintBackgrounds(bool a){}
bool Preferences::shouldPrintBackgrounds(){
    return true;
}

void  Preferences::setUserStyleSheetLocation(const gchar* location){}  
const gchar* Preferences::userStyleSheetLocation(){
    return 0L;
}

void Preferences::setDefaultTextEncoding(const gchar* encoding){}
const gchar* Preferences::defaultTextEncoding(){
    return 0L;
}

void Preferences::setStandardFontFamily(const gchar* s)
{
}

const gchar* Preferences::standardFontFamily()
{
    return 0L;
}

void Preferences::setFixedFontFamily(const gchar* s)
{
}

const gchar* Preferences::fixedFontFamily()
{
    return 0L;
}
  
void Preferences::setSerifFontFamily(const gchar* s)
{
}

const gchar* Preferences::serifFontFamily()
{
    return impl->serifFontFamily();
}
  
void Preferences::setSansSerifFontFamily(const gchar* s)
{
     impl->setSansSerifFontFamily(s);
}
const gchar* Preferences::sansSerifFontFamily()
{
    return impl->sansSerifFontFamily();
}

void Preferences::setCursiveFontFamily(const gchar* s)
{
}

const gchar* Preferences::cursiveFontFamily()
{
    return 0L;
}

void Preferences::setFantasyFontFamily(const gchar* s)
{
}

const gchar* Preferences::fantasyFontFamily()
{
    return 0L;
}
