#!/bin/sh
CONF_FLAGS=""

NOCONFIGURE=""

for p in $*; do
    eval "$p=1"
done

if [ $noconf ]; then
    export NOCONFIGURE=1
fi

if [ $debug ]; then    
    CONF_FLAGS="${CONF_FLAGS} --enable-debug"
fi

if [ $home ]; then
    export PKG_CONFIG_PATH="${PKG_CONFIG_PATH}:$HOME/lib/pkgconfig"
    CONF_FLAGS="${CONF_FLAGS} --prefix=$HOME --exec-prefix=$HOME"
    if [ -n $sofia ] && [ -e $HOME/include/wengine.h ]; then
	echo "* using sofia from $HOME"
	CONF_FLAGS="${CONF_FLAGS} --with-sofia=$HOME"
	export ACLOCAL_FLAGS="-I ${HOME}/share/aclocal"
    fi
fi

if [ $curl ]; then 
    CONF_FLAGS="${CONF_FLAGS} --with-libcurl"
    echo "* using libcurl"
fi

if [ $sofia ]; then
    sofia=1
fi

if [ $maintainer ]; then
    maintainer=1
    CONF_FLAGS="$CONF_FLAGS --enable-maintainer-mode"
fi


echo
autogen=./autogen.sh

cmd="$autogen "
echo "running $cmd" 

$cmd

configure="./configure"

cmd="$configure $CONF_FLAGS"
if [ -z $noconf  ]; then    
    echo "running $cmd"
    $cmd
else 
    echo "now run $cmd"
fi

