#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "interface.h"
#include "support.h"

typedef char HWND;

#include "PSEmu Plugin Defs.h"

char *LibName = "Linuzappz X Windows Pad Driver";

const unsigned char version = 1;	// PSEmu 1.x library
const unsigned char revision = VERSION;
const unsigned char build = BUILD;

void LoadConf();
void SaveConf();

typedef struct {
	unsigned long keys[2][16];
} PADconf;

PADconf conf;

GtkWidget *MsgDlg;

void OnMsg_Ok() {
	gtk_widget_destroy(MsgDlg);
	gtk_main_quit();
}

void SysMessage(char *fmt, ...) {
	GtkWidget *Ok,*Txt;
	GtkWidget *Box,*Box1;
	va_list list;
	char msg[512];

	va_start(list, fmt);
	vsprintf(msg, fmt, list);
	va_end(list);

	if (msg[strlen(msg)-1] == '\n') msg[strlen(msg)-1] = 0;

	MsgDlg = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(MsgDlg), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(MsgDlg), "padXwin Msg");
	gtk_container_set_border_width(GTK_CONTAINER(MsgDlg), 5);

	Box = gtk_vbox_new(5, 0);
	gtk_container_add(GTK_CONTAINER(MsgDlg), Box);
	gtk_widget_show(Box);

	Txt = gtk_label_new(msg);
	
	gtk_box_pack_start(GTK_BOX(Box), Txt, FALSE, FALSE, 5);
	gtk_widget_show(Txt);

	Box1 = gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(Box), Box1, FALSE, FALSE, 0);
	gtk_widget_show(Box1);

	Ok = gtk_button_new_with_label("Ok");
	gtk_signal_connect (GTK_OBJECT(Ok), "clicked", GTK_SIGNAL_FUNC(OnMsg_Ok), NULL);
	gtk_container_add(GTK_CONTAINER(Box1), Ok);
	GTK_WIDGET_SET_FLAGS(Ok, GTK_CAN_DEFAULT);
	gtk_widget_show(Ok);

	gtk_widget_show(MsgDlg);	

	gtk_main();
}


GtkWidget *Conf;
GtkWidget *Btn;
char name[32];

int padn;

void UpdateConf() {
	int i;

	for (i=0; i<16; i++) {
	    char *tmp;

		if (i == 1) continue;
		if (i == 2) continue;

		sprintf(name, "Key%d", i);
		Btn = lookup_widget(Conf, name);
		tmp = XKeysymToString(conf.keys[padn][i]);
		if (tmp != NULL)
			gtk_label_set_text(GTK_LABEL(GTK_BIN(Btn)->child), tmp);
		else
			gtk_label_set_text(GTK_LABEL(GTK_BIN(Btn)->child), "Unknown");
		gtk_object_set_user_data(GTK_OBJECT(Btn), &conf.keys[padn][i]);
	}
}

void OnConf_Key(GtkButton *Btn) {
    GdkEvent *ev;
	unsigned long *key = (unsigned long*)gtk_object_get_user_data(GTK_OBJECT(Btn));
    char *tmp;

    for (;;) {
		ev = gdk_event_get();
		if (ev != NULL) {
	    	if (ev->type == GDK_KEY_PRESS) {
    		    *key = ev->key.keyval;
		    	tmp = XKeysymToString(*key);
		    	if (tmp != NULL)
					gtk_label_set_text(GTK_LABEL(GTK_BIN(Btn)->child), tmp);
			    else
					gtk_label_set_text(GTK_LABEL(GTK_BIN(Btn)->child), "Unknown");
				return;
			}
	    }
    }
}

void OnConf_Pad1() {
	padn = 0;
	UpdateConf();
}

void OnConf_Pad2() {
	padn = 1;
	UpdateConf();
}

void OnConf_Ok() {
	SaveConf();

	gtk_widget_destroy(Conf);
	gtk_main_quit();
}

void OnConf_Cancel() {
	gtk_widget_destroy(Conf);
	gtk_main_quit();
}

void PADconfigure() {
	LoadConf();

	Conf = create_Config();

	padn = 0;
	UpdateConf();

	gtk_widget_show_all(Conf);	
	gtk_main();
}

GtkWidget *About;

void OnAbout_Ok() {
	gtk_widget_destroy(About);
	gtk_main_quit();
}

void PADabout() {

	About = create_About();

	gtk_widget_show_all(About);
	gtk_main();
}

long PADtest() {
	return 0;
}

const char CfgHeader[32] = "padXwin Cfg v1";
int errmsg=0;

void LoadConf() {
	FILE *f;
	char cfg[255];
	char header[32];

	memset(&conf, 0, sizeof(conf));
	conf.keys[0][0] = XK_space;			// Select
	conf.keys[0][3] = XK_Return;		// Start
	conf.keys[0][4] = XK_Up;			// Up
	conf.keys[0][5] = XK_Right;			// Right
	conf.keys[0][6] = XK_Down;			// Down
	conf.keys[0][7] = XK_Left;			// Left
	conf.keys[0][8] = XK_1;				// L2
	conf.keys[0][9] = XK_3;				// R2
	conf.keys[0][10] = XK_q;			// L1
	conf.keys[0][11] = XK_e;			// R1
	conf.keys[0][12] = XK_w;			// Triangle
	conf.keys[0][13] = XK_d;			// Circle
	conf.keys[0][14] = XK_x;			// Cross
	conf.keys[0][15] = XK_a;			// Square

	sprintf(cfg, "%s/padXwin.cfg", getenv("HOME"));
	f = fopen(cfg, "r");
	if (f == NULL) return;
	fread(header, 1, 32, f);
	if (strcmp(header, CfgHeader)) {
		if (errmsg) return;
		errmsg=1;
		SysMessage("padXwin: the existing padXwin.cfg is from an old version, please reconfigure");
		return;
	}
	fread(&conf, 1, sizeof(conf), f);
	fclose(f);
}

void SaveConf() {
	FILE *f;
	char cfg[255];

	sprintf(cfg, "%s/padXwin.cfg", getenv("HOME"));
	f = fopen(cfg, "w");
	if (f == NULL) return;
	fwrite(CfgHeader, 1, 32, f);
	fwrite(&conf, 1, sizeof(conf), f);
	fclose(f);
}

int main(int argc, char *argv[]) {
	if (argc != 2) return 0;

	gtk_init(NULL, NULL);

	if (!strcmp(argv[1], "configure")) {
		PADconfigure();
	} else {
		PADabout();
	}

	return 0;
}