/*
 * Pad for Psemu Pro like Emulators
 *
 * By: linuzappz <linuzappz@hotmail.com>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "interface.h"
#include "support.h"

typedef char HWND;

#include "PSEmu Plugin Defs.h"

char *LibName = "Linuzappz X Windows Pad Driver";

const unsigned char version = 1;	// PSEmu 1.x library
const unsigned char revision = VERSION;
const unsigned char build = BUILD;

void LoadConf();
void SaveConf();

typedef struct {
	unsigned long keys[2][16];
} PADconf;

PADconf conf;

Display *Dsp;
XEvent E;
int PadOpened = 0;
int PadFlags = 0;

char *PSEgetLibName(void) {
	return LibName;
}

unsigned long PSEgetLibType(void) {
	return PSE_LT_PAD;
}

unsigned long PSEgetLibVersion(void) {
	return version << 16 | revision << 8 | build;
}

GtkWidget *MsgDlg;

void OnMsg_Ok() {
	gtk_widget_destroy(MsgDlg);
	gtk_main_quit();
}

void SysMessage(char *fmt, ...) {
	GtkWidget *Ok,*Txt;
	GtkWidget *Box,*Box1;
	va_list list;
	char msg[512];

	va_start(list, fmt);
	vsprintf(msg, fmt, list);
	va_end(list);

	if (msg[strlen(msg)-1] == '\n') msg[strlen(msg)-1] = 0;

	MsgDlg = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(MsgDlg), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(MsgDlg), "padXwin Msg");
	gtk_container_set_border_width(GTK_CONTAINER(MsgDlg), 5);

	Box = gtk_vbox_new(5, 0);
	gtk_container_add(GTK_CONTAINER(MsgDlg), Box);
	gtk_widget_show(Box);

	Txt = gtk_label_new(msg);
	
	gtk_box_pack_start(GTK_BOX(Box), Txt, FALSE, FALSE, 5);
	gtk_widget_show(Txt);

	Box1 = gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(Box), Box1, FALSE, FALSE, 0);
	gtk_widget_show(Box1);

	Ok = gtk_button_new_with_label("Ok");
	gtk_signal_connect (GTK_OBJECT(Ok), "clicked", GTK_SIGNAL_FUNC(OnMsg_Ok), NULL);
	gtk_container_add(GTK_CONTAINER(Box1), Ok);
	GTK_WIDGET_SET_FLAGS(Ok, GTK_CAN_DEFAULT);
	gtk_widget_show(Ok);

	gtk_widget_show(MsgDlg);	

	gtk_main();
}

int init=0;

long PADinit(long flags) {
	PadFlags |= flags;
	if (init) return 0;
	LoadConf();
	init = 1;

	return 0;
}

long PADshutdown(void) {
	init = 0;
	return 0;
}

long PADopen(unsigned long *Disp) {
	Dsp = (Display *) * Disp;
	PadOpened = 1;
	XAutoRepeatOff(Dsp);
	return 0;
}

long PADclose(void) {
	PadOpened = 0;
	XAutoRepeatOn(Dsp);
	return 0;
}

long PADquery(void) {
	return 3;					// both pads
}

typedef struct {
	unsigned char controllerType;
	unsigned short buttonStatus;
	unsigned char rightJoyX, rightJoyY, leftJoyX, leftJoyY;
	unsigned char moveX, moveY;
	unsigned char reserved[91];
} PadDataS;

unsigned short PressedKey;
unsigned short ReleasedKey;
unsigned short Pad1Stat = 0xffff;
unsigned short Pad2Stat = 0xffff;

void UpdatePads() {
	int i;

	while (XPending(Dsp)) {
		XNextEvent(Dsp, &E);
		switch (E.type) {
			case KeyPress:
				PressedKey = XLookupKeysym((XKeyEvent *)&E, 0);
				if (PadFlags & 1) {
					for (i = 0; i < 16; i++)
						if (PressedKey == conf.keys[0][i]) {
							PressedKey = 0;
							Pad1Stat &= ~(1 << i);
							break;
						}
					if (i != 16)
						break;
				}
				if (PadFlags & 2) {
					for (i = 0; i < 16; i++)
						if (PressedKey == conf.keys[1][i]) {
							PressedKey = 0;
							Pad2Stat &= ~(1 << i);
							break;
						}
					if (i != 16)
						break;
				}
				return;
			case KeyRelease:
				ReleasedKey = XLookupKeysym((XKeyEvent *)&E, 0);
				if (PadFlags & 1)
					for (i = 0; i < 16; i++)
						if (ReleasedKey == conf.keys[0][i]) {
							Pad1Stat |= (1 << i);
							break;
						}
				if (PadFlags & 2)
					for (i = 0; i < 16; i++)
						if (ReleasedKey == conf.keys[1][i]) {
							Pad2Stat |= (1 << i);
							break;
						}
				break;
			case FocusIn:
				XAutoRepeatOff(Dsp);
				break;
			case FocusOut:
				XAutoRepeatOn(Dsp);
				break;
		}
	}
}

long PADreadPort1(PadDataS * pad) {
	UpdatePads();

	pad->buttonStatus = Pad1Stat;
	pad->controllerType = 4;	// standard

	return 0;
}

long PADreadPort2(PadDataS * pad) {
	UpdatePads();

	pad->buttonStatus = Pad2Stat;
	pad->controllerType = 4;	// standard

	return 0;
}

long PADkeypressed(void) {
	long ret;

	if (PadOpened == 0)
		return 0;

	UpdatePads();

	if (PressedKey) {
		ret = (unsigned short)PressedKey;
		PressedKey = 0;
		return ret;
	}

	return 0;
}

void ExecCfg(char *arg) {
	char cfg[256];
	struct stat buf;

	strcpy(cfg, "./cfgPadXwin");
	if (stat(cfg, &buf) != -1) {
		sprintf(cfg, "%s %s", cfg, arg);
		system(cfg); return;
	}

	strcpy(cfg, "./cfg/cfgPadXwin");
	if (stat(cfg, &buf) != -1) {
		sprintf(cfg, "%s %s", cfg, arg);
		system(cfg); return;
	}

	sprintf(cfg, "%s/cfgPadXwin", getenv("HOME"));
	if (stat(cfg, &buf) != -1) {
		sprintf(cfg, "%s %s", cfg, arg);
		system(cfg); return;
	}

	printf("cfgPadXwin file not found!\n");
}

long PADconfigure() {
	ExecCfg("configure");

	return 0;
}

void PADabout() {
	ExecCfg("about");
}

long PADtest() {
	return 0;
}

const char CfgHeader[32] = "padXwin Cfg v1";
int errmsg=0;

void LoadConf() {
	FILE *f;
	char cfg[255];
	char header[32];

	memset(&conf, 0, sizeof(conf));
	conf.keys[0][0] = XK_space;			// Select
	conf.keys[0][3] = XK_Return;		// Start
	conf.keys[0][4] = XK_Up;			// Up
	conf.keys[0][5] = XK_Right;			// Right
	conf.keys[0][6] = XK_Down;			// Down
	conf.keys[0][7] = XK_Left;			// Left
	conf.keys[0][8] = XK_1;				// L2
	conf.keys[0][9] = XK_3;				// R2
	conf.keys[0][10] = XK_q;			// L1
	conf.keys[0][11] = XK_e;			// R1
	conf.keys[0][12] = XK_w;			// Triangle
	conf.keys[0][13] = XK_d;			// Circle
	conf.keys[0][14] = XK_x;			// Cross
	conf.keys[0][15] = XK_a;			// Square

	sprintf(cfg, "%s/padXwin.cfg", getenv("HOME"));
	f = fopen(cfg, "r");
	if (f == NULL) return;
	fread(header, 1, 32, f);
	if (strcmp(header, CfgHeader)) {
		if (errmsg) return;
		errmsg=1;
		SysMessage("padXwin: the existing padXwin.cfg is from an old version, please reconfigure");
		return;
	}
	fread(&conf, 1, sizeof(conf), f);
	fclose(f);
}

void SaveConf() {
	FILE *f;
	char cfg[255];

	sprintf(cfg, "%s/padXwin.cfg", getenv("HOME"));
	f = fopen(cfg, "w");
	if (f == NULL) return;
	fwrite(CfgHeader, 1, 32, f);
	fwrite(&conf, 1, sizeof(conf), f);
	fclose(f);
}

