#include <stdio.h>
#include <string.h>
#include <zlib.h>
typedef unsigned char UBYTE;
#include "floppy.h"

int loadDiskImage(char *name, int disk)
{
	gzFile inf = gzopen(name, "rb");
	if (!inf) return -1;
	if (!diskImage[disk]) diskImage[disk] = new char[737280*2];
	dSizes[disk] = gzread(inf, diskImage[disk], 737280*2);
	gzclose(inf);
	flopWrite[disk] = 0;
	return 0;
}

int unloadDiskImage(char *name, int disk)
{
	if (!diskImage[disk]) return -1;
	if (flopWrite[disk] == 0) {
		delete diskImage[disk];
		diskImage[disk] = NULL;
		return 0;
	}
	gzFile outf = gzopen(name, "wb9");
	if (!outf) {
		delete diskImage[disk];
		diskImage[disk] = NULL;
		flopWrite[disk] = 0;
		return -1;
	}
	gzwrite(outf, diskImage[disk], dSizes[disk]);
	delete diskImage[disk];
	diskImage[disk] = NULL;
	flopWrite[disk] = 0;
	gzclose(outf);
	return 0;
}
