/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef PLASMAMODEL_H
#define PLASMAMODEL_H

#include <qabstractitemmodel.h>
#include <qvector.h>

class PlasmaModel : public QAbstractTableModel
{
    Q_OBJECT
public:
    PlasmaModel(int rows, int cols, QObject *parent = 0);
    ~PlasmaModel();

    int rowCount(const QModelIndex &) const;
    int columnCount(const QModelIndex &) const;

    QVariant data(const QModelIndex &index, int role = QAbstractItemModel::DisplayRole) const;

protected:
    void timerEvent(QTimerEvent *e);

private:
    inline int rgb(unsigned char r, unsigned char g, unsigned char b) const
        { return (r << 16) + (g << 8) + b; }
    inline unsigned int value(int row, int column) const
        { return values.at((row * cols) + column); }
    inline void setValue(int row, int column, int val)
        { values[(row * cols) + column] = val; }

    int rows;
    int cols;
    int timer;

    QVector<unsigned int> values;
    QVector<unsigned int> colors;
    QVector<unsigned int> cosinus;
    QVector<unsigned char> waves;
};

#endif
