/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the painting module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QPAINTDEVICE_H
#define QPAINTDEVICE_H

#include "qwindowdefs.h"
#include "qrect.h"

#if defined(Q_WS_QWS)
class QWSDisplay;
#endif

class QPaintEngine;

class Q_GUI_EXPORT QPaintDevice                                // device for QPainter
{
public:
    enum PaintDeviceMetric {
        PdmWidth = 1,
        PdmHeight,
        PdmWidthMM,
        PdmHeightMM,
        PdmNumColors,
        PdmDepth,
        PdmDpiX,
        PdmDpiY,
        PdmPhysicalDpiX,
        PdmPhysicalDpiY
    };

    virtual ~QPaintDevice();

    int devType() const;
    bool isExtDev() const;
    bool paintingActive() const;
    virtual QPaintEngine *paintEngine() const = 0;

#if defined(Q_WS_QWS)
    static QWSDisplay *qwsDisplay();
    virtual unsigned char * scanLine(int) const;
    virtual int bytesPerLine() const;
#endif

#ifdef Q_WS_WIN
    virtual HDC getDC() const;
    virtual void releaseDC(HDC hdc) const;
#endif

    int width() const { return metric(PdmWidth); }
    int height() const { return metric(PdmHeight); }
    int widthMM() const { return metric(PdmWidthMM); }
    int heightMM() const { return metric(PdmHeightMM); }
    int logicalDpiX() const { return metric(PdmDpiX); }
    int logicalDpiY() const { return metric(PdmDpiY); }
    int physicalDpiX() const { return metric(PdmPhysicalDpiX); }
    int physicalDpiY() const { return metric(PdmPhysicalDpiY); }
    int numColors() const { return metric(PdmNumColors); }
    int depth() const { return metric(PdmDepth); }

protected:
    QPaintDevice(uint devflags);
    virtual int metric(PaintDeviceMetric metric) const;

    ushort        devFlags;                        // device flags
    ushort        painters;                        // refcount

private:
    Q_DISABLE_COPY(QPaintDevice)

#if defined(Q_WS_X11) && defined(QT_COMPAT)
public:
    QT_COMPAT Display *x11Display() const;
    QT_COMPAT int x11Screen() const;
    QT_COMPAT int x11Depth() const;
    QT_COMPAT int x11Cells() const;
    QT_COMPAT Qt::HANDLE x11Colormap() const;
    QT_COMPAT bool x11DefaultColormap() const;
    QT_COMPAT void *x11Visual() const;
    QT_COMPAT bool x11DefaultVisual() const;

    static QT_COMPAT Display *x11AppDisplay();
    static QT_COMPAT int x11AppScreen();
    static QT_COMPAT int x11AppDepth(int screen = -1);
    static QT_COMPAT int x11AppCells(int screen = -1);
    static QT_COMPAT Qt::HANDLE x11AppRootWindow(int screen = -1);
    static QT_COMPAT Qt::HANDLE x11AppColormap(int screen = -1);
    static QT_COMPAT void *x11AppVisual(int screen = -1);
    static QT_COMPAT bool x11AppDefaultColormap(int screen =-1);
    static QT_COMPAT bool x11AppDefaultVisual(int screen =-1);
    static QT_COMPAT int x11AppDpiX(int screen = -1);
    static QT_COMPAT int x11AppDpiY(int screen = -1);
    static QT_COMPAT void x11SetAppDpiX(int, int);
    static QT_COMPAT void x11SetAppDpiY(int, int);
#endif

    friend class QPainter;
    friend class QQuickDrawPaintEngine;
    friend class QFontEngineMac;
    friend void qt_bit_blt(QPaintDevice *, int, int, const QPaintDevice *, int, int, int, int, bool);
};

#ifdef QT_COMPAT
QT_COMPAT Q_GUI_EXPORT
void bitBlt(QPaintDevice *dst, int dx, int dy,
             const QPaintDevice *src, int sx=0, int sy=0, int sw=-1, int sh=-1,
             bool ignoreMask=false);

QT_COMPAT Q_GUI_EXPORT
void bitBlt(QPaintDevice *dst, int dx, int dy,
             const QImage *src, int sx=0, int sy=0, int sw=-1, int sh=-1,
             int conversion_flags=0);

QT_COMPAT Q_GUI_EXPORT
void bitBlt(QPaintDevice *dst, const QPoint &dp,
            const QPaintDevice *src, const QRect &sr=QRect(0,0,-1,-1),
            bool ignoreMask=false);
#endif

/*****************************************************************************
  Inline functions
 *****************************************************************************/

inline int QPaintDevice::devType() const
{ return devFlags & QInternal::DeviceTypeMask; }

inline bool QPaintDevice::isExtDev() const
{ return (devFlags & QInternal::ExternalDevice) != 0; }

inline bool QPaintDevice::paintingActive() const
{ return painters != 0; }

#endif // QPAINTDEVICE_H
