/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#include "qgridwidget.h"
#ifndef QT_NO_GRIDWIDGET
#include "qlayout.h"
#include "qapplication.h"
#include "qevent.h"
#include "qmenubar.h"
/*!
    \class QGridWidget qgridwidget.h
    \brief The QGridWidget class provides simple geometry management of its children.

    \ingroup geomanagement
    \ingroup appearance

    The grid places its widgets either in columns or in rows depending
    on its orientation.

    The number of rows \e or columns is defined in the constructor.
    All the grid's children will be placed and sized in accordance
    with their sizeHint() and sizePolicy().

    Use setMargin() to add space around the grid itself, and
    setSpacing() to add space between the widgets.

    If you just need a layout (not a widget) use QGridLayout instead.

    \img qgrid-m.png QGridWidget

    \sa QVBoxWidget QHBoxWidget
*/

/*!
    Constructs a grid widget with parent \a parent.
    If \a orientation is \c Qt::Horizontal, \a n specifies the number of
    columns. If \a orientation is \c Qt::Vertical, \a n specifies the number of
    rows. The widget flags \a f are passed to the QFrame constructor.
*/
QGridWidget::QGridWidget(int n, Qt::Orientation orientation, QWidget *parent, Qt::WFlags f)
    : QFrame(parent, f)
{
    lay = new QGridLayout(this);
    lay->setDefaultPositioning(n, orientation);
}



/*!
    Constructs a grid widget with parent \a parent.
    \a n specifies the number of columns. The widget flags \a f are
    passed to the QFrame constructor.
 */
QGridWidget::QGridWidget(int n, QWidget *parent, Qt::WFlags f)
    : QFrame(parent, f)
{
    lay = new QGridLayout(this);
    lay->setDefaultPositioning(n, Qt::Horizontal);
}


#ifdef QT_COMPAT
/*!
    Use one of the constructors that doesn't take the \a name
    argument and then use setObjectName() instead.
*/
QGridWidget::QGridWidget(int n, Qt::Orientation orientation, QWidget *parent, const char *name, Qt::WFlags f)
    : QFrame(parent, f)
{
    setObjectName(name);
    lay = new QGridLayout(this);
    lay->setObjectName(name);
    lay->setDefaultPositioning(n, orientation);
}

/*!
    Use one of the constructors that doesn't take the \a name
    argument and then use setObjectName() instead.
*/
QGridWidget::QGridWidget(int n, QWidget *parent, const char *name, Qt::WFlags f)
    : QFrame(parent, f)
{
    setObjectName(name);
    lay = new QGridLayout(this);
    lay->setObjectName(name);
    lay->setDefaultPositioning(n, Qt::Horizontal);
}
#endif

/*!
    \internal
*/
void QGridWidget::childEvent(QChildEvent *e)
{
    QWidget *child = qt_cast<QWidget*>(e->child());
    if (!child || child->isTopLevel())
        return;
    if (e->added()) {
        lay->addWidget(child);
    } else if (e->polished()) {
        QMenuBar *mb;
        if ((mb=qt_cast<QMenuBar*>(child))) {
            lay->removeWidget(mb);
            lay->setMenuBar(mb);
        }
    }
}

/*!
    Sets the margin around the grid to \a margin (expressed in pixels).

    \sa setSpacing()
*/

void QGridWidget::setMargin(int margin)
{
    if (layout())
        layout()->setMargin(margin);
}

/*!
    Sets the spacing between the child widgets to \a space (expressed
    in pixels).

    \sa setMargin()
*/

void QGridWidget::setSpacing(int spacing)
{
    if (layout())
        layout()->setSpacing(spacing);
}

#endif
