/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#ifndef QHBOXWIDGET_H
#define QHBOXWIDGET_H

#include "qwidget.h"
#include "qframe.h"

#ifndef QT_NO_HBOXWIDGET


class QBoxLayout;

class Q_GUI_EXPORT QHBoxWidget : public QFrame
{
    Q_OBJECT
public:
    QHBoxWidget(QWidget* parent=0, Qt::WFlags f=0);

    void setMargin(int);
    void setSpacing(int);
    bool setStretchFactor(QWidget*, int stretch);
    QSize sizeHint() const;

protected:
    void childEvent(QChildEvent *);

#ifdef QT_COMPAT
public:
    QT_COMPAT_CONSTRUCTOR QHBoxWidget(QWidget* parent, const char* name, Qt::WFlags f=0);
#endif
protected:
    QHBoxWidget(Qt::Orientation orientation, QWidget* parent, Qt::WFlags f);

private:
    Q_DISABLE_COPY(QHBoxWidget)
    QBoxLayout *lay;
};

#endif // QT_NO_HBOX

#endif // QHBOX_H
