/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qpropertyeditor.h"
#include "qpropertyeditor_model_p.h"
#include "qpropertyeditor_delegate_p.h"

#include <qitemdelegate.h>
#include <qheaderview.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qscrollbar.h>

using namespace QPropertyEditor;

Q_GLOBAL_STATIC_WITH_ARGS(PropertyCollection, dummy_collection, (QLatin1String("<empty>")))

View::View(QWidget *parent)
    : QTreeView(parent)
{
    m_model = new Model(this);
    setModel(m_model);
    m_itemDelegate = new Delegate(this);
    setItemDelegate(m_itemDelegate);
    setInitialInput(0);
    
    setAlternatingRowColors(true);
    setOddRowColor(QColor(250, 248, 235));
    setEvenRowColor(QColor(255, 255, 255));
    
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);

    connect(this, SIGNAL(doubleClicked(const QModelIndex &, Qt::MouseButton, Qt::KeyboardModifiers)),
            this, SLOT(open(const QModelIndex&)));

    connect(m_model, SIGNAL(propertyChanged(IProperty*)),
            this, SIGNAL(propertyChanged(IProperty*)));
}

View::~View()
{
}

bool View::isReadOnly() const
{
    return m_itemDelegate->isReadOnly();
}

void View::setReadOnly(bool readOnly)
{
    m_itemDelegate->setReadOnly(readOnly);
}

void View::setInitialInput(IProperty *initialInput)
{
    if (!initialInput)
        initialInput = dummy_collection();

    m_model->setInitialInput(initialInput);

    setSelectionMode(QTreeView::SingleSelection);
    setSelectionBehavior(QTreeView::SelectRows);
    setRootIsDecorated(true);

    setEditTriggers(QAbstractItemView::CurrentChanged|QAbstractItemView::SelectedClicked);
    setRoot(m_model->indexOf(initialInput));

    int rc = m_model->rowCount(root());
    if (rc > 0) {
        QModelIndex current = m_model->index(0, 0, root());
        setCurrentIndex(current);
    }

    header()->setResizeMode(QHeaderView::Stretch, 1);
}


IProperty *View::initialInput() const
{
    return m_model->initialInput();
}

void View::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index) const
{
    QStyleOptionViewItem opt = viewOptions();
    QStyleOptionViewItem option = opt;

    IProperty *property = static_cast<const Model*>(model())->privateData(index);
    if (index.column() == 0 && property && property->changed()) {
        option.font.setBold(true);
    }

    if (selectionModel()->isSelected(index))
        painter->fillRect(rect, QColor(230, 230, 230));

    painter->drawLine(rect.x(), rect.bottom(),
                      rect.right(), rect.bottom());

    if (model()->hasChildren(index)) {
        static const int size = 9;
        opt.state |= QStyle::Style_Children;
        opt.rect.setRect(rect.width() - (indentation() + size) / 2,
                         rect.y() + (rect.height() - size) / 2, size, size);
        if (isOpen(index))
            opt.state |= QStyle::Style_Open;
        style()->drawPrimitive(QStyle::PE_IndicatorBranch, &opt, painter, this);
    }
}

void View::keyPressEvent(QKeyEvent *ev)
{
    QApplication::syncX();
    QTreeView::keyPressEvent(ev);
}
